/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.channel.check;

import com.google.common.base.Preconditions;
import org.opendaylight.channel.check.ChannelInputCheck;
import org.opendaylight.channel.check.CheckResult;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.ModifyChannelInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyChannelInputCheck
extends ChannelInputCheck {
    private ModifyChannelInput modifyChannelInput;
    private static final Logger LOG = LoggerFactory.getLogger(ModifyChannelInputCheck.class);

    public ModifyChannelInputCheck(ModifyChannelInput input) {
        this.modifyChannelInput = input;
    }

    @Override
    public CheckResult check() {
        CheckResult result = this.checkParam();
        if (result.isInputIllegal()) {
            return result;
        }
        if (!this.checkChannelExist(this.modifyChannelInput.getName(), this.modifyChannelInput.getTopologyId())) {
            return new CheckResult(true, "The Channel does not exists!");
        }
        if (this.hasChannelDeployed(this.modifyChannelInput.getName(), this.modifyChannelInput.getTopologyId())) {
            return new CheckResult(true, "The Channel has deployed,can not modify");
        }
        return new CheckResult(false, "");
    }

    private CheckResult checkParam() {
        CheckResult result = this.checkInputNull(this.modifyChannelInput);
        if (result.isInputIllegal()) {
            return result;
        }
        return this.paramValidity(this.modifyChannelInput);
    }

    private CheckResult paramValidity(ModifyChannelInput input) {
        CheckResult result = this.checkIpRange("src-ip", input.getSrcIp(), false);
        if (result.isInputIllegal()) {
            return result;
        }
        result = this.checkIpRange("dest-group", input.getDstGroup(), true);
        if (result.isInputIllegal()) {
            return result;
        }
        return this.checkWildCard(input.getGroupWildcard(), input.getSourceWildcard());
    }

    private CheckResult checkInputNull(ModifyChannelInput input) {
        try {
            Preconditions.checkNotNull((Object)input, (Object)"Input is null!");
            Preconditions.checkNotNull((Object)input.getName(), (Object)"channel-name is null!");
        }
        catch (NullPointerException e) {
            LOG.warn("NullPointerException: {}", (Throwable)e);
            return new CheckResult(true, e.getMessage());
        }
        return new CheckResult(false, "");
    }
}

