/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.channel.check;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opendaylight.channel.check.ChannelInputCheck;
import org.opendaylight.channel.check.CheckResult;
import org.opendaylight.channel.util.ChannelDBUtil;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.DeployChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.deploy.channel.input.EgressNode;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.deploy.channel.input.egress.node.RcvTp;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.BierForwardingType;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.BpAssignmentStrategy;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel;
import org.opendaylight.yang.gen.v1.urn.bier.common.rev161102.DomainId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.SubDomainId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployChannelInputCheck
extends ChannelInputCheck {
    private DeployChannelInput deployChannelInput;
    private Channel channel;
    private static final Logger LOG = LoggerFactory.getLogger(DeployChannelInputCheck.class);

    public DeployChannelInputCheck(DeployChannelInput input) {
        this.deployChannelInput = input;
    }

    @Override
    public CheckResult check() {
        CheckResult result = this.checkParam();
        if (result.isInputIllegal()) {
            return result;
        }
        this.channel = ChannelDBUtil.getInstance().getChannelInfo(this.deployChannelInput.getTopologyId(), this.deployChannelInput.getChannelName());
        if (!this.checkChannelExist(this.channel)) {
            return new CheckResult(true, "The Channel does not exists!");
        }
        if (this.bierForwardingTypeConflict(this.channel, this.deployChannelInput)) {
            return new CheckResult(true, "forwarding-type conflict! can not change forwarding-type, when update deploy-channel info.");
        }
        if (this.bierBpStrategyConflict(this.channel, this.deployChannelInput)) {
            return new CheckResult(true, "assignment-strategy conflict! can not change strategy, when update deploy-channel info.");
        }
        BpAssignmentStrategy bpAssignmentStrategy = this.getBpStrategy(this.channel.getBpAssignmentStrategy(), this.deployChannelInput.getBpAssignmentStrategy());
        result = this.checkNodesInSubdomain(bpAssignmentStrategy);
        if (result.isInputIllegal()) {
            return result;
        }
        result = this.checkIngressAndEgressNodes();
        if (result.isInputIllegal()) {
            return result;
        }
        return new CheckResult(false, "");
    }

    private BpAssignmentStrategy getBpStrategy(BpAssignmentStrategy oldBpStrategy, BpAssignmentStrategy newBpStrategy) {
        return oldBpStrategy == null ? newBpStrategy : oldBpStrategy;
    }

    private boolean bierBpStrategyConflict(Channel channel, DeployChannelInput deployChannelInput) {
        if (channel.getBpAssignmentStrategy() != null && deployChannelInput.getBpAssignmentStrategy() != null) {
            return !channel.getBpAssignmentStrategy().equals((Object)deployChannelInput.getBpAssignmentStrategy());
        }
        return false;
    }

    private boolean bierForwardingTypeConflict(Channel channel, DeployChannelInput deployChannelInput) {
        if (channel.getBierForwardingType() != null) {
            return !channel.getBierForwardingType().equals((Object)deployChannelInput.getBierForwardingType());
        }
        return false;
    }

    private CheckResult checkIngressAndEgressNodes() {
        String ingressNode = this.deployChannelInput.getIngressNode();
        List egressNodeList = this.deployChannelInput.getEgressNode();
        for (EgressNode egressNode : egressNodeList) {
            if (!egressNode.getNodeId().equals(ingressNode)) continue;
            return new CheckResult(true, "ingress-node and egress-nodes conflict!the node must not be both ingress and egress.");
        }
        return new CheckResult(false, "");
    }

    private CheckResult checkNodesInSubdomain(BpAssignmentStrategy bpAssignmentStrategy) {
        if (!this.nodeInSubdomain(this.deployChannelInput.getTopologyId(), this.deployChannelInput.getIngressNode(), this.channel.getDomainId(), this.channel.getSubDomainId(), this.deployChannelInput.getBierForwardingType())) {
            return new CheckResult(true, "ingress-node is not in this sub-domain!");
        }
        if (!this.egressNodesInSubdomain(this.deployChannelInput.getTopologyId(), this.deployChannelInput.getEgressNode(), this.channel.getDomainId(), this.channel.getSubDomainId(), this.deployChannelInput.getBierForwardingType())) {
            return new CheckResult(true, "egress-node is not in this sub-domain!");
        }
        if (this.deployChannelInput.getBierForwardingType().equals((Object)BierForwardingType.BierTe) && bpAssignmentStrategy == BpAssignmentStrategy.Manual) {
            if (!this.srcTpInSubdomain(this.deployChannelInput.getTopologyId(), this.deployChannelInput.getIngressNode(), this.channel.getDomainId(), this.channel.getSubDomainId(), this.deployChannelInput.getSrcTp())) {
                return new CheckResult(true, "src-tp is not in this sub-domain!");
            }
            if (!this.rcvTpsInSubdomain(this.deployChannelInput.getTopologyId(), this.deployChannelInput.getEgressNode(), this.channel.getDomainId(), this.channel.getSubDomainId())) {
                return new CheckResult(true, "rcv-tp is not in this sub-domain!");
            }
        }
        return new CheckResult(false, "");
    }

    private boolean srcTpInSubdomain(String topologyId, String ingressNode, DomainId domainId, SubDomainId subDomainId, String tp) {
        return this.tpInTeSubdomain(topologyId, ingressNode, domainId, subDomainId, tp);
    }

    private boolean rcvTpsInSubdomain(String topologyId, List<EgressNode> egressNodeList, DomainId domainId, SubDomainId subDomainId) {
        for (EgressNode egressNode : egressNodeList) {
            for (RcvTp rcvTp : egressNode.getRcvTp()) {
                if (this.tpInTeSubdomain(topologyId, egressNode.getNodeId(), domainId, subDomainId, rcvTp.getTp())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean egressNodesInSubdomain(String topologyId, List<EgressNode> egressNodeList, DomainId domainId, SubDomainId subDomainId, BierForwardingType type) {
        for (EgressNode egressNode : egressNodeList) {
            if (this.nodeInSubdomain(topologyId, egressNode.getNodeId(), domainId, subDomainId, type)) continue;
            return false;
        }
        return true;
    }

    private CheckResult checkParam() {
        return this.checkInputNull(this.deployChannelInput);
    }

    private CheckResult checkInputNull(DeployChannelInput input) {
        try {
            Preconditions.checkNotNull((Object)input, (Object)"Input is null!");
            Preconditions.checkNotNull((Object)input.getChannelName(), (Object)"channel-name is null!");
            Preconditions.checkNotNull((Object)input.getBierForwardingType(), (Object)"bier forwarding type is null!");
            Preconditions.checkNotNull((Object)input.getIngressNode(), (Object)"ingress-node is null!");
            if (input.getBierForwardingType().equals((Object)BierForwardingType.BierTe)) {
                Preconditions.checkNotNull((Object)input.getSrcTp(), (Object)"src-tp is null!");
            }
            Preconditions.checkNotNull((Object)input.getEgressNode(), (Object)"egress-node is null!");
            if (input.getEgressNode().isEmpty()) {
                return new CheckResult(true, "egress-node is null!");
            }
            for (EgressNode egressNode : input.getEgressNode()) {
                Preconditions.checkNotNull((Object)egressNode.getNodeId(), (Object)"egress-node id is null!");
                if (!input.getBierForwardingType().equals((Object)BierForwardingType.BierTe)) continue;
                Preconditions.checkNotNull((Object)egressNode.getRcvTp(), (Object)"rcv-tp is null!");
            }
        }
        catch (NullPointerException e) {
            LOG.warn("NullPointerException: {}", (Throwable)e);
            return new CheckResult(true, e.getMessage());
        }
        return new CheckResult(false, "");
    }
}

