/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class MplsLabel
implements Serializable {
    private static final long serialVersionUID = -800754711005769629L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= 0L && value <= 1048575L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..1048575]]", (Object)value);
    }

    @ConstructorProperties(value={"value"})
    public MplsLabel(Long _value) {
        if (_value != null) {
            MplsLabel.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public MplsLabel(MplsLabel source) {
        this._value = source._value;
    }

    public static MplsLabel getDefaultInstance(String defaultValue) {
        return new MplsLabel(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MplsLabel other = (MplsLabel)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MplsLabel.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

