/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.peer;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpAddPathTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.SendReceive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.peer.SupportedTables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.peer.SupportedTablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SupportedTablesBuilder
implements Builder<SupportedTables> {
    private Class<? extends AddressFamily> _afi;
    private Class<? extends SubsequentAddressFamily> _safi;
    private SendReceive _sendReceive;
    private SupportedTablesKey key;
    Map<Class<? extends Augmentation<SupportedTables>>, Augmentation<SupportedTables>> augmentation = Collections.emptyMap();

    public SupportedTablesBuilder() {
    }

    public SupportedTablesBuilder(BgpAddPathTableType arg) {
        this._sendReceive = arg.getSendReceive();
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public SupportedTablesBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public SupportedTablesBuilder(SupportedTables base) {
        Map aug;
        this.key = base.key();
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._sendReceive = base.getSendReceive();
        if (base instanceof SupportedTablesImpl) {
            SupportedTablesImpl impl = (SupportedTablesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SupportedTables>>, Augmentation<SupportedTables>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportedTables>>, Augmentation<SupportedTables>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        if (arg instanceof BgpAddPathTableType) {
            this._sendReceive = ((BgpAddPathTableType)arg).getSendReceive();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpAddPathTableType]");
    }

    public SupportedTablesKey key() {
        return this.key;
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public SendReceive getSendReceive() {
        return this._sendReceive;
    }

    public <E$$ extends Augmentation<SupportedTables>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SupportedTablesBuilder withKey(SupportedTablesKey key) {
        this.key = key;
        return this;
    }

    public SupportedTablesBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public SupportedTablesBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public SupportedTablesBuilder setSendReceive(SendReceive value) {
        this._sendReceive = value;
        return this;
    }

    public SupportedTablesBuilder addAugmentation(Class<? extends Augmentation<SupportedTables>> augmentationType, Augmentation<SupportedTables> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportedTables>>, Augmentation<SupportedTables>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SupportedTablesBuilder removeAugmentation(Class<? extends Augmentation<SupportedTables>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SupportedTables build() {
        return new SupportedTablesImpl(this);
    }

    private static final class SupportedTablesImpl
    implements SupportedTables {
        private final Class<? extends AddressFamily> _afi;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private final SendReceive _sendReceive;
        private final SupportedTablesKey key;
        private Map<Class<? extends Augmentation<SupportedTables>>, Augmentation<SupportedTables>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SupportedTablesImpl(SupportedTablesBuilder base) {
            this.key = base.key() != null ? base.key() : new SupportedTablesKey(base.getAfi(), base.getSafi());
            this._afi = this.key.getAfi();
            this._safi = this.key.getSafi();
            this._sendReceive = base.getSendReceive();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<SupportedTables> getImplementedInterface() {
            return SupportedTables.class;
        }

        @Override
        public SupportedTablesKey key() {
            return this.key;
        }

        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public SendReceive getSendReceive() {
            return this._sendReceive;
        }

        public <E$$ extends Augmentation<SupportedTables>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._afi);
            result = 31 * result + Objects.hashCode(this._safi);
            result = 31 * result + Objects.hashCode(this._sendReceive);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SupportedTables.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SupportedTables other = (SupportedTables)obj;
            if (!Objects.equals(this._afi, other.getAfi())) {
                return false;
            }
            if (!Objects.equals(this._safi, other.getSafi())) {
                return false;
            }
            if (!Objects.equals(this._sendReceive, other.getSendReceive())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SupportedTablesImpl otherImpl = (SupportedTablesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SupportedTables>>, Augmentation<SupportedTables>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"SupportedTables");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_afi", this._afi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_safi", this._safi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sendReceive", (Object)this._sendReceive);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

