/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.PeerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.peer.AdjRibIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.peer.AdjRibOut;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.peer.EffectiveRibIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.peer.SupportedTables;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PeerBuilder
implements Builder<Peer> {
    private AdjRibIn _adjRibIn;
    private AdjRibOut _adjRibOut;
    private EffectiveRibIn _effectiveRibIn;
    private PeerId _peerId;
    private PeerRole _peerRole;
    private List<SupportedTables> _supportedTables;
    private PeerKey key;
    Map<Class<? extends Augmentation<Peer>>, Augmentation<Peer>> augmentation = Collections.emptyMap();

    public PeerBuilder() {
    }

    public PeerBuilder(Peer base) {
        Map aug;
        this.key = base.key();
        this._peerId = base.getPeerId();
        this._adjRibIn = base.getAdjRibIn();
        this._adjRibOut = base.getAdjRibOut();
        this._effectiveRibIn = base.getEffectiveRibIn();
        this._peerRole = base.getPeerRole();
        this._supportedTables = base.getSupportedTables();
        if (base instanceof PeerImpl) {
            PeerImpl impl = (PeerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Peer>>, Augmentation<Peer>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Peer>>, Augmentation<Peer>>(aug);
        }
    }

    public PeerKey key() {
        return this.key;
    }

    public AdjRibIn getAdjRibIn() {
        return this._adjRibIn;
    }

    public AdjRibOut getAdjRibOut() {
        return this._adjRibOut;
    }

    public EffectiveRibIn getEffectiveRibIn() {
        return this._effectiveRibIn;
    }

    public PeerId getPeerId() {
        return this._peerId;
    }

    public PeerRole getPeerRole() {
        return this._peerRole;
    }

    public List<SupportedTables> getSupportedTables() {
        return this._supportedTables;
    }

    public <E$$ extends Augmentation<Peer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public PeerBuilder withKey(PeerKey key) {
        this.key = key;
        return this;
    }

    public PeerBuilder setAdjRibIn(AdjRibIn value) {
        this._adjRibIn = value;
        return this;
    }

    public PeerBuilder setAdjRibOut(AdjRibOut value) {
        this._adjRibOut = value;
        return this;
    }

    public PeerBuilder setEffectiveRibIn(EffectiveRibIn value) {
        this._effectiveRibIn = value;
        return this;
    }

    public PeerBuilder setPeerId(PeerId value) {
        this._peerId = value;
        return this;
    }

    public PeerBuilder setPeerRole(PeerRole value) {
        this._peerRole = value;
        return this;
    }

    public PeerBuilder setSupportedTables(List<SupportedTables> values) {
        this._supportedTables = values;
        return this;
    }

    public PeerBuilder addAugmentation(Class<? extends Augmentation<Peer>> augmentationType, Augmentation<Peer> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Peer>>, Augmentation<Peer>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PeerBuilder removeAugmentation(Class<? extends Augmentation<Peer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Peer build() {
        return new PeerImpl(this);
    }

    private static final class PeerImpl
    implements Peer {
        private final AdjRibIn _adjRibIn;
        private final AdjRibOut _adjRibOut;
        private final EffectiveRibIn _effectiveRibIn;
        private final PeerId _peerId;
        private final PeerRole _peerRole;
        private final List<SupportedTables> _supportedTables;
        private final PeerKey key;
        private Map<Class<? extends Augmentation<Peer>>, Augmentation<Peer>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        PeerImpl(PeerBuilder base) {
            this.key = base.key() != null ? base.key() : new PeerKey(base.getPeerId());
            this._peerId = this.key.getPeerId();
            this._adjRibIn = base.getAdjRibIn();
            this._adjRibOut = base.getAdjRibOut();
            this._effectiveRibIn = base.getEffectiveRibIn();
            this._peerRole = base.getPeerRole();
            this._supportedTables = base.getSupportedTables();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Peer> getImplementedInterface() {
            return Peer.class;
        }

        @Override
        public PeerKey key() {
            return this.key;
        }

        @Override
        public AdjRibIn getAdjRibIn() {
            return this._adjRibIn;
        }

        @Override
        public AdjRibOut getAdjRibOut() {
            return this._adjRibOut;
        }

        @Override
        public EffectiveRibIn getEffectiveRibIn() {
            return this._effectiveRibIn;
        }

        @Override
        public PeerId getPeerId() {
            return this._peerId;
        }

        @Override
        public PeerRole getPeerRole() {
            return this._peerRole;
        }

        @Override
        public List<SupportedTables> getSupportedTables() {
            return this._supportedTables;
        }

        public <E$$ extends Augmentation<Peer>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._adjRibIn);
            result = 31 * result + Objects.hashCode(this._adjRibOut);
            result = 31 * result + Objects.hashCode(this._effectiveRibIn);
            result = 31 * result + Objects.hashCode(this._peerId);
            result = 31 * result + Objects.hashCode((Object)this._peerRole);
            result = 31 * result + Objects.hashCode(this._supportedTables);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Peer.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Peer other = (Peer)obj;
            if (!Objects.equals(this._adjRibIn, other.getAdjRibIn())) {
                return false;
            }
            if (!Objects.equals(this._adjRibOut, other.getAdjRibOut())) {
                return false;
            }
            if (!Objects.equals(this._effectiveRibIn, other.getEffectiveRibIn())) {
                return false;
            }
            if (!Objects.equals(this._peerId, other.getPeerId())) {
                return false;
            }
            if (!Objects.equals((Object)this._peerRole, (Object)other.getPeerRole())) {
                return false;
            }
            if (!Objects.equals(this._supportedTables, other.getSupportedTables())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PeerImpl otherImpl = (PeerImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Peer>>, Augmentation<Peer>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Peer");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_adjRibIn", (Object)this._adjRibIn);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_adjRibOut", (Object)this._adjRibOut);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_effectiveRibIn", (Object)this._effectiveRibIn);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peerId", (Object)this._peerId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peerRole", (Object)((Object)this._peerRole));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_supportedTables", this._supportedTables);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

