/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.ApplicationRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.ApplicationRibId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.ApplicationRibKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Rib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.Tables;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ApplicationRibBuilder
implements Builder<ApplicationRib> {
    private ApplicationRibId _id;
    private List<Tables> _tables;
    private ApplicationRibKey key;
    Map<Class<? extends Augmentation<ApplicationRib>>, Augmentation<ApplicationRib>> augmentation = Collections.emptyMap();

    public ApplicationRibBuilder() {
    }

    public ApplicationRibBuilder(Rib arg) {
        this._tables = arg.getTables();
    }

    public ApplicationRibBuilder(ApplicationRib base) {
        Map aug;
        this.key = base.key();
        this._id = base.getId();
        this._tables = base.getTables();
        if (base instanceof ApplicationRibImpl) {
            ApplicationRibImpl impl = (ApplicationRibImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationRib>>, Augmentation<ApplicationRib>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationRib>>, Augmentation<ApplicationRib>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Rib) {
            this._tables = ((Rib)arg).getTables();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.Rib]");
    }

    public ApplicationRibKey key() {
        return this.key;
    }

    public ApplicationRibId getId() {
        return this._id;
    }

    public List<Tables> getTables() {
        return this._tables;
    }

    public <E$$ extends Augmentation<ApplicationRib>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ApplicationRibBuilder withKey(ApplicationRibKey key) {
        this.key = key;
        return this;
    }

    public ApplicationRibBuilder setId(ApplicationRibId value) {
        this._id = value;
        return this;
    }

    public ApplicationRibBuilder setTables(List<Tables> values) {
        this._tables = values;
        return this;
    }

    public ApplicationRibBuilder addAugmentation(Class<? extends Augmentation<ApplicationRib>> augmentationType, Augmentation<ApplicationRib> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationRib>>, Augmentation<ApplicationRib>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ApplicationRibBuilder removeAugmentation(Class<? extends Augmentation<ApplicationRib>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ApplicationRib build() {
        return new ApplicationRibImpl(this);
    }

    private static final class ApplicationRibImpl
    implements ApplicationRib {
        private final ApplicationRibId _id;
        private final List<Tables> _tables;
        private final ApplicationRibKey key;
        private Map<Class<? extends Augmentation<ApplicationRib>>, Augmentation<ApplicationRib>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ApplicationRibImpl(ApplicationRibBuilder base) {
            this.key = base.key() != null ? base.key() : new ApplicationRibKey(base.getId());
            this._id = this.key.getId();
            this._tables = base.getTables();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ApplicationRib> getImplementedInterface() {
            return ApplicationRib.class;
        }

        @Override
        public ApplicationRibKey key() {
            return this.key;
        }

        @Override
        public ApplicationRibId getId() {
            return this._id;
        }

        @Override
        public List<Tables> getTables() {
            return this._tables;
        }

        public <E$$ extends Augmentation<ApplicationRib>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._tables);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ApplicationRib.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ApplicationRib other = (ApplicationRib)obj;
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._tables, other.getTables())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ApplicationRibImpl otherImpl = (ApplicationRibImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ApplicationRib>>, Augmentation<ApplicationRib>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ApplicationRib");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_tables", this._tables);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

