/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.graceful.restart._case.graceful.restart.capability;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.graceful.restart._case.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.graceful.restart._case.graceful.restart.capability.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TablesBuilder {
    private Tables.AfiFlags _afiFlags;
    private TablesKey _key;
    private Class<? extends AddressFamily> _afi;
    private Class<? extends SubsequentAddressFamily> _safi;
    private Map<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>();

    public TablesBuilder() {
    }

    public TablesBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType] \nbut was: " + arg);
        }
    }

    public Tables.AfiFlags getAfiFlags() {
        return this._afiFlags;
    }

    public TablesKey getKey() {
        return this._key;
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public <E extends Augmentation<Tables>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TablesBuilder setAfiFlags(Tables.AfiFlags value) {
        this._afiFlags = value;
        return this;
    }

    public TablesBuilder setKey(TablesKey value) {
        this._key = value;
        return this;
    }

    public TablesBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public TablesBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public TablesBuilder addAugmentation(Class<? extends Augmentation<Tables>> augmentationType, Augmentation<Tables> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Tables build() {
        return new TablesImpl(this);
    }

    private static final class TablesImpl
    implements Tables {
        private final Tables.AfiFlags _afiFlags;
        private final TablesKey _key;
        private final Class<? extends AddressFamily> _afi;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private Map<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>();

        public Class<Tables> getImplementedInterface() {
            return Tables.class;
        }

        private TablesImpl(TablesBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new TablesKey(builder.getAfi(), builder.getSafi());
                this._afi = builder.getAfi();
                this._safi = builder.getSafi();
            } else {
                this._key = builder.getKey();
                this._afi = this._key.getAfi();
                this._safi = this._key.getSafi();
            }
            this._afiFlags = builder.getAfiFlags();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Tables.AfiFlags getAfiFlags() {
            return this._afiFlags;
        }

        @Override
        public TablesKey getKey() {
            return this._key;
        }

        @Override
        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public <E extends Augmentation<Tables>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._afiFlags == null ? 0 : this._afiFlags.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            result = 31 * result + (this._safi == null ? 0 : this._safi.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TablesImpl other = (TablesImpl)obj;
            if (this._afiFlags == null ? other._afiFlags != null : !this._afiFlags.equals(other._afiFlags)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._afi == null ? other._afi != null : !this._afi.equals(other._afi)) {
                return false;
            }
            if (this._safi == null ? other._safi != null : !this._safi.equals(other._safi)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Tables [_afiFlags=");
            builder.append(this._afiFlags);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _afi=");
            builder.append(this._afi);
            builder.append(", _safi=");
            builder.append(this._safi);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

