/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Notify;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NotifyBuilder {
    private byte[] _data;
    private Short _errorCode;
    private Short _errorSubcode;
    private Map<Class<? extends Augmentation<Notify>>, Augmentation<Notify>> augmentation = new HashMap<Class<? extends Augmentation<Notify>>, Augmentation<Notify>>();

    public byte[] getData() {
        return this._data;
    }

    public Short getErrorCode() {
        return this._errorCode;
    }

    public Short getErrorSubcode() {
        return this._errorSubcode;
    }

    public <E extends Augmentation<Notify>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NotifyBuilder setData(byte[] value) {
        this._data = value;
        return this;
    }

    public NotifyBuilder setErrorCode(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._errorCode = value;
        return this;
    }

    public NotifyBuilder setErrorSubcode(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._errorSubcode = value;
        return this;
    }

    public NotifyBuilder addAugmentation(Class<? extends Augmentation<Notify>> augmentationType, Augmentation<Notify> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Notify build() {
        return new NotifyImpl(this);
    }

    private static final class NotifyImpl
    implements Notify {
        private final byte[] _data;
        private final Short _errorCode;
        private final Short _errorSubcode;
        private Map<Class<? extends Augmentation<Notify>>, Augmentation<Notify>> augmentation = new HashMap<Class<? extends Augmentation<Notify>>, Augmentation<Notify>>();

        public Class<Notify> getImplementedInterface() {
            return Notify.class;
        }

        private NotifyImpl(NotifyBuilder builder) {
            this._data = builder.getData();
            this._errorCode = builder.getErrorCode();
            this._errorSubcode = builder.getErrorSubcode();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public byte[] getData() {
            return this._data;
        }

        @Override
        public Short getErrorCode() {
            return this._errorCode;
        }

        @Override
        public Short getErrorSubcode() {
            return this._errorSubcode;
        }

        public <E extends Augmentation<Notify>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._data == null ? 0 : Arrays.hashCode(this._data));
            result = 31 * result + (this._errorCode == null ? 0 : this._errorCode.hashCode());
            result = 31 * result + (this._errorSubcode == null ? 0 : this._errorSubcode.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotifyImpl other = (NotifyImpl)obj;
            if (this._data == null ? other._data != null : !Arrays.equals(this._data, other._data)) {
                return false;
            }
            if (this._errorCode == null ? other._errorCode != null : !this._errorCode.equals(other._errorCode)) {
                return false;
            }
            if (this._errorSubcode == null ? other._errorSubcode != null : !this._errorSubcode.equals(other._errorSubcode)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Notify [_data=");
            builder.append(Arrays.toString(this._data));
            builder.append(", _errorCode=");
            builder.append(this._errorCode);
            builder.append(", _errorSubcode=");
            builder.append(this._errorSubcode);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

