/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.DatastoreConfig;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint64;

public class DatastoreConfigBuilder {
    private DatastoreConfig.Store _store;
    private Uint64 _timeToLive;
    private Uint64 _timeToWait;
    Map<Class<? extends Augmentation<DatastoreConfig>>, Augmentation<DatastoreConfig>> augmentation = Map.of();

    public DatastoreConfigBuilder() {
    }

    public DatastoreConfigBuilder(DatastoreConfig base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DatastoreConfig>>, Augmentation<DatastoreConfig>>(aug);
        }
        this._store = base.getStore();
        this._timeToLive = base.getTimeToLive();
        this._timeToWait = base.getTimeToWait();
    }

    public static @NonNull DatastoreConfig empty() {
        return LazyEmpty.INSTANCE;
    }

    public DatastoreConfig.Store getStore() {
        return this._store;
    }

    public Uint64 getTimeToLive() {
        return this._timeToLive;
    }

    public Uint64 getTimeToWait() {
        return this._timeToWait;
    }

    public <E$$ extends Augmentation<DatastoreConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public DatastoreConfigBuilder setStore(DatastoreConfig.Store value) {
        this._store = value;
        return this;
    }

    public DatastoreConfigBuilder setTimeToLive(Uint64 value) {
        this._timeToLive = value;
        return this;
    }

    public DatastoreConfigBuilder setTimeToWait(Uint64 value) {
        this._timeToWait = value;
        return this;
    }

    public DatastoreConfigBuilder addAugmentation(Augmentation<DatastoreConfig> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DatastoreConfig>>, Augmentation<DatastoreConfig>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public DatastoreConfigBuilder removeAugmentation(Class<? extends Augmentation<DatastoreConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull DatastoreConfig build() {
        return new DatastoreConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull DatastoreConfig INSTANCE = new DatastoreConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class DatastoreConfigImpl
    extends AbstractAugmentable<DatastoreConfig>
    implements DatastoreConfig {
        private final DatastoreConfig.Store _store;
        private final Uint64 _timeToLive;
        private final Uint64 _timeToWait;
        private int hash = 0;
        private volatile boolean hashValid = false;

        DatastoreConfigImpl(DatastoreConfigBuilder base) {
            super(base.augmentation);
            this._store = base.getStore();
            this._timeToLive = base.getTimeToLive();
            this._timeToWait = base.getTimeToWait();
        }

        @Override
        public DatastoreConfig.Store getStore() {
            return this._store;
        }

        @Override
        public Uint64 getTimeToLive() {
            return this._timeToLive;
        }

        @Override
        public Uint64 getTimeToWait() {
            return this._timeToWait;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = DatastoreConfig.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return DatastoreConfig.bindingEquals(this, obj);
        }

        public String toString() {
            return DatastoreConfig.bindingToString(this);
        }
    }
}

