/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.AaaAppConfigData;
import org.opendaylight.yang.svc.v1.urn.opendaylight.aaa.app.config.rev170619.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;

public interface DatastoreConfig
extends ChildOf<AaaAppConfigData>,
Augmentable<DatastoreConfig> {
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("datastore-config");

    default public Class<DatastoreConfig> implementedInterface() {
        return DatastoreConfig.class;
    }

    public static int bindingHashCode(@NonNull DatastoreConfig obj) {
        int result = 1;
        int prime = 31;
        result = 31 * result + Objects.hashCode((Object)obj.getStore());
        result = 31 * result + Objects.hashCode(obj.getTimeToLive());
        result = 31 * result + Objects.hashCode(obj.getTimeToWait());
        for (Augmentation augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }

    public static boolean bindingEquals(@NonNull DatastoreConfig thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        DatastoreConfig other = (DatastoreConfig)CodeHelpers.checkCast(DatastoreConfig.class, (Object)obj);
        return other != null && Objects.equals(thisObj.getTimeToLive(), other.getTimeToLive()) && Objects.equals(thisObj.getTimeToWait(), other.getTimeToWait()) && Objects.equals((Object)thisObj.getStore(), (Object)other.getStore()) && thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull DatastoreConfig obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"DatastoreConfig");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"store", (Object)((Object)obj.getStore()));
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"timeToLive", (Object)obj.getTimeToLive());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"timeToWait", (Object)obj.getTimeToWait());
        CodeHelpers.appendAugmentations((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Augmentable)obj);
        return helper.toString();
    }

    public Store getStore();

    default public @NonNull Store requireStore() {
        return (Store)((Object)CodeHelpers.require((Object)((Object)this.getStore()), (String)"store"));
    }

    public Uint64 getTimeToLive();

    default public @NonNull Uint64 requireTimeToLive() {
        return (Uint64)CodeHelpers.require((Object)this.getTimeToLive(), (String)"timetolive");
    }

    public Uint64 getTimeToWait();

    default public @NonNull Uint64 requireTimeToWait() {
        return (Uint64)CodeHelpers.require((Object)this.getTimeToWait(), (String)"timetowait");
    }

    public static enum Store implements EnumTypeObject
    {
        H2DataStore(0, "h2-data-store");

        private final @NonNull String name;
        private final int value;

        private Store(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static @Nullable Store forName(String name) {
            return switch (name) {
                case "h2-data-store" -> H2DataStore;
                default -> null;
            };
        }

        public static @Nullable Store forValue(int intValue) {
            return switch (intValue) {
                case 0 -> H2DataStore;
                default -> null;
            };
        }

        public static @NonNull Store ofName(String name) {
            return (Store)CodeHelpers.checkEnum((EnumTypeObject)Store.forName(name), (String)name);
        }

        public static @NonNull Store ofValue(int intValue) {
            return (Store)CodeHelpers.checkEnum((EnumTypeObject)Store.forValue(intValue), (int)intValue);
        }
    }
}

