/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.web.env;

import org.apache.shiro.config.Ini;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.shiro.realm.KeystoneAuthRealm;
import org.opendaylight.aaa.shiro.realm.MDSALDynamicAuthorizationFilter;
import org.opendaylight.aaa.shiro.realm.MdsalRealm;
import org.opendaylight.aaa.shiro.realm.MoonRealm;
import org.opendaylight.aaa.shiro.realm.TokenAuthRealm;
import org.opendaylight.aaa.shiro.web.env.AAAShiroWebEnvironment;
import org.opendaylight.aaa.tokenauthrealm.auth.TokenAuthenticators;
import org.opendaylight.aaa.web.servlet.ServletSupport;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroIni;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.shiro.ini.Main;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.shiro.ini.Urls;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AAAWebEnvironment
extends IniWebEnvironment
implements AAAShiroWebEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(AAAWebEnvironment.class);

    public AAAWebEnvironment(ShiroIni shiroConfiguration, DataBroker dataBroker, ICertificateManager certificateManager, AuthenticationService authenticationService, TokenAuthenticators tokenAuthenticators, TokenStore tokenStore, PasswordHashService passwordHashService, ServletSupport servletSupport) {
        Ini ini = new Ini();
        Ini.Section mainSection = ini.addSection("main");
        for (Main main : shiroConfiguration.nonnullMain()) {
            mainSection.put(main.getPairKey(), main.getPairValue());
        }
        Ini.Section urlsSection = ini.addSection("urls");
        for (Urls url : shiroConfiguration.nonnullUrls()) {
            urlsSection.put(url.getPairKey(), url.getPairValue());
        }
        this.setIni(ini);
        ClassLoaderUtils.runWithClassLoader((ClassLoader)AAAWebEnvironment.class.getClassLoader(), () -> {
            try (Registration filterLoad = MDSALDynamicAuthorizationFilter.prepareForLoad(dataBroker);
                 Registration keyStoneLoad = KeystoneAuthRealm.prepareForLoad(certificateManager, servletSupport);
                 Registration mdsalLoad = MdsalRealm.prepareForLoad(passwordHashService, dataBroker);
                 Registration moonLoad = MoonRealm.prepareForLoad(servletSupport);
                 Registration tokenAuthLoad = TokenAuthRealm.prepareForLoad(authenticationService, tokenAuthenticators, tokenStore);){
                this.configure();
            }
        });
        LOG.debug("AAAWebEnvironment created");
    }
}

