/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm.util.http;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class SimpleHttpRequest<T> {
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private final Client client;
    private final Class<T> outputType;
    private URI uri;
    private String path;
    private String method;
    private MediaType mediaType;
    private Object entity;

    SimpleHttpRequest(Client client, Class<T> outputType) {
        this.client = client;
        this.outputType = outputType;
    }

    public T execute() {
        WebTarget webTarget = this.client.target(this.uri).path(this.path);
        this.queryParams.forEach((x$0, xva$1) -> webTarget.queryParam(x$0, new Object[]{xva$1}));
        try {
            if (this.outputType == Response.class) {
                return (T)webTarget.request(new MediaType[]{this.mediaType}).method(this.method, Entity.entity((Object)this.entity, (MediaType)this.mediaType), Response.class);
            }
            return (T)webTarget.request(new MediaType[]{this.mediaType}).method(this.method, Entity.entity((Object)this.entity, (MediaType)this.mediaType), this.outputType);
        }
        catch (ProcessingException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    static <T> Builder<T> builder(Client client, Class<T> outputType) {
        return new Builder<T>(client, outputType);
    }

    public static class Builder<T> {
        private final SimpleHttpRequest<T> request;

        Builder(Client client, Class<T> outputType) {
            this.request = new SimpleHttpRequest<T>(client, outputType);
        }

        public Builder<T> uri(URI uri) {
            this.request.uri = uri;
            return this;
        }

        public Builder<T> path(String path) {
            this.request.path = path;
            return this;
        }

        public Builder<T> method(String method) {
            this.request.method = method;
            return this;
        }

        public Builder<T> mediaType(MediaType mediaType) {
            this.request.mediaType = mediaType;
            return this;
        }

        public Builder<T> entity(Object input) {
            this.request.entity = input;
            return this;
        }

        public Builder<T> queryParam(String theQueryParam, String theParamValue) {
            this.request.queryParams.put(theQueryParam, theParamValue);
            return this;
        }

        public SimpleHttpRequest<T> build() {
            return this.request;
        }
    }
}

