/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.opendaylight.aaa.shiro.moon.MoonPrincipal;
import org.opendaylight.aaa.web.servlet.ServletSupport;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoonRealm
extends AuthorizingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(MoonRealm.class);
    private static final ThreadLocal<ServletSupport> SERVLET_SUPPORT_TL = new ThreadLocal();
    private static final String MOON_DEFAULT_DOMAIN = "sdn";
    private final ServletSupport servletSupport;
    private volatile WebTarget moonServer;

    public MoonRealm() {
        this((ServletSupport)Verify.verifyNotNull((Object)SERVLET_SUPPORT_TL.get(), (String)"MoonRealm loading not prepared", (Object[])new Object[0]));
    }

    public MoonRealm(ServletSupport servletSupport) {
        this.servletSupport = Objects.requireNonNull(servletSupport);
    }

    public static Registration prepareForLoad(ServletSupport jaxrsSupport) {
        SERVLET_SUPPORT_TL.set(Objects.requireNonNull(jaxrsSupport));
        return SERVLET_SUPPORT_TL::remove;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        Object principal = authenticationToken.getPrincipal();
        if (!(principal instanceof String)) {
            throw new AuthenticationException("Non-string principal " + principal);
        }
        String stringPrincipal = (String)principal;
        if (!(authenticationToken instanceof UsernamePasswordToken)) {
            throw new AuthenticationException("Token is not UsernamePasswordToken: " + authenticationToken);
        }
        UsernamePasswordToken userPassToken = (UsernamePasswordToken)authenticationToken;
        String password = new String(userPassToken.getPassword());
        MoonPrincipal moonPrincipal = this.moonAuthenticate(stringPrincipal, password, MOON_DEFAULT_DOMAIN);
        return moonPrincipal == null ? null : new SimpleAuthenticationInfo((Object)moonPrincipal, (Object)password.toCharArray(), this.getName());
    }

    public MoonPrincipal moonAuthenticate(String username, String password, String domain) {
        WebTarget moon = this.moonServer;
        if (moon == null) {
            LOG.debug("moon server not specified, cannot authenticate");
            return null;
        }
        JsonElement element = JsonParser.parseString((String)((String)moon.request(new String[]{"application/json"}).post(Entity.entity((Object)("{\"username\": \"" + username + "\",\n  \"password\": \"" + password + "\",\n  \"project\": \"" + domain + "\"\n}"), (String)"application/json"), String.class)));
        if (!element.isJsonObject()) {
            throw new IllegalStateException("Authentication error: returned output is not a JSON object");
        }
        JsonObject object = element.getAsJsonObject();
        JsonObject error = object.get("error").getAsJsonObject();
        if (error != null) {
            throw new IllegalStateException("Authentication Error : " + error.get("title").getAsString());
        }
        JsonElement token = object.get("token");
        if (token == null) {
            return null;
        }
        ImmutableSet.Builder userRoles = ImmutableSet.builder();
        JsonElement roles = object.get("roles");
        if (roles != null) {
            for (JsonElement role : roles.getAsJsonArray()) {
                try {
                    userRoles.add((Object)role.getAsString());
                }
                catch (ClassCastException e) {
                    LOG.debug("Unable to cast role as String, skipping {}", (Object)role, (Object)e);
                }
            }
        }
        return new MoonPrincipal(username, domain, username + "@" + domain, (Set<String>)userRoles.build(), token.getAsString());
    }

    public void setMoonServerURL(String moonServerURL) {
        URL url;
        try {
            url = new URL(moonServerURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        String uriHost = url.getHost();
        Preconditions.checkArgument((uriHost != null ? 1 : 0) != 0, (String)"moon host not specified in %s", (Object)url);
        int uriPort = url.getPort();
        Preconditions.checkArgument((uriPort >= 0 ? 1 : 0) != 0, (String)"moon port not specified in %s", (Object)url);
        String port = Integer.toString(uriPort);
        String server = String.format("http://%s:%s/moon/auth/tokens", uriHost, port);
        LOG.debug("Moon server is at: {}:{} and will be accessed through {}", new Object[]{uriHost, port, server});
        this.moonServer = this.servletSupport.newClientBuilder().build().target(server);
    }
}

