/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.servlet.Filter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.HttpAuthorization;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.HttpPermission;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.Policies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.Permissions;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDSALDynamicAuthorizationFilter
extends AuthorizationFilter
implements DataListener<HttpAuthorization> {
    private static final Logger LOG = LoggerFactory.getLogger(MDSALDynamicAuthorizationFilter.class);
    private static final DataTreeIdentifier<HttpAuthorization> AUTHZ_CONTAINER = DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)InstanceIdentifier.create(HttpAuthorization.class));
    private static final ThreadLocal<DataBroker> DATABROKER_TL = new ThreadLocal();
    private final DataBroker dataBroker;
    private Registration reg;
    private volatile ListenableFuture<Optional<HttpAuthorization>> authContainer;

    public MDSALDynamicAuthorizationFilter() {
        this((DataBroker)Verify.verifyNotNull((Object)DATABROKER_TL.get(), (String)"MDSALDynamicAuthorizationFilter loading not prepared", (Object[])new Object[0]));
    }

    public MDSALDynamicAuthorizationFilter(DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    public static Registration prepareForLoad(DataBroker dataBroker) {
        DATABROKER_TL.set(Objects.requireNonNull(dataBroker));
        return DATABROKER_TL::remove;
    }

    public Filter processPathConfig(String path, String config) {
        try (ReadTransaction tx = this.dataBroker.newReadOnlyTransaction();){
            this.authContainer = tx.read(AUTHZ_CONTAINER.datastore(), AUTHZ_CONTAINER.path());
        }
        this.reg = this.dataBroker.registerDataListener(AUTHZ_CONTAINER, (DataListener)this);
        return super.processPathConfig(path, config);
    }

    public void destroy() {
        if (this.reg != null) {
            this.reg.close();
            this.reg = null;
        }
        super.destroy();
    }

    public void dataChangedTo(HttpAuthorization data) {
        LOG.debug("Updating authorization information to {}", (Object)data);
        this.authContainer = Futures.immediateFuture(Optional.ofNullable(data));
    }

    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies.Policies> policiesList;
        Optional authorizationOptional;
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Expected HttpServletRequest, received " + request);
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        Subject subject = this.getSubject(request, response);
        String requestURI = httpServletRequest.getRequestURI();
        LOG.debug("isAccessAllowed for user={} to requestURI={}", (Object)subject, (Object)requestURI);
        try {
            authorizationOptional = (Optional)this.authContainer.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("MDSAL attempt to read Http Authz Container failed, disallowing access", (Throwable)e);
            return false;
        }
        if (!authorizationOptional.isPresent()) {
            LOG.debug("Authorization Container does not exist");
            return true;
        }
        HttpAuthorization httpAuthorization = (HttpAuthorization)authorizationOptional.orElseThrow();
        Policies policies = httpAuthorization.getPolicies();
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies.Policies> arrayList = policiesList = policies != null ? policies.getPolicies() : null;
        if (policiesList == null || policiesList.isEmpty()) {
            LOG.debug("Exiting successfully early since no authorization rules exist");
            return true;
        }
        policiesList = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies.Policies>(policiesList);
        policiesList.sort(Comparator.comparing(HttpPermission::getIndex));
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies.Policies policy : policiesList) {
            String resource = policy.getResource();
            boolean pathsMatch = this.pathsMatch(resource, requestURI);
            if (!pathsMatch) continue;
            LOG.debug("paths match for pattern={} and requestURI={}", (Object)resource, (Object)requestURI);
            String method = httpServletRequest.getMethod();
            LOG.trace("method={}", (Object)method);
            for (Permissions permission : policy.nonnullPermissions()) {
                String role = permission.getRole();
                LOG.trace("role={}", (Object)role);
                for (Permissions.Actions action : permission.getActions()) {
                    LOG.trace("action={}", (Object)action.getName());
                    if (!action.getName().equalsIgnoreCase(method)) continue;
                    boolean hasRole = subject.hasRole(role);
                    LOG.trace("hasRole({})={}", (Object)role, (Object)hasRole);
                    if (!hasRole) continue;
                    return true;
                }
            }
            LOG.debug("couldn't authorize the user for access");
            return false;
        }
        LOG.debug("successfully authorized the user for access");
        return true;
    }
}

