/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.idm;

import com.google.common.annotations.Beta;
import com.google.common.collect.ForwardingObject;
import java.util.List;
import org.opendaylight.aaa.api.AuthenticationException;
import org.opendaylight.aaa.api.Claim;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.IdMService;
import org.opendaylight.aaa.api.PasswordCredentialAuth;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.shiro.idm.IdmLightProxy;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Beta
@Component(immediate=true, property={"type=default"}, service={CredentialAuth.class, PasswordCredentialAuth.class, IdMService.class, ClaimCache.class})
public class OSGIIdmLightProxy
extends ForwardingObject
implements PasswordCredentialAuth,
IdMService,
ClaimCache {
    @Reference
    IIDMStore iidmStore;
    @Reference
    PasswordHashService passwordHashService;
    private IdmLightProxy delegate;

    @Activate
    void activate() {
        this.delegate = new IdmLightProxy(this.iidmStore, this.passwordHashService);
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
    }

    protected IdmLightProxy delegate() {
        return this.delegate;
    }

    public void clear() {
        this.delegate().clear();
    }

    public List<String> listDomains(String userId) {
        return this.delegate().listDomains(userId);
    }

    public List<String> listRoles(String userId, String domainName) {
        return this.delegate().listRoles(userId, domainName);
    }

    public List<String> listUserIDs() throws IDMStoreException {
        return this.delegate().listUserIDs();
    }

    public Claim authenticate(PasswordCredentials cred) throws AuthenticationException {
        return this.delegate().authenticate(cred);
    }
}

