/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.idm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.aaa.api.AuthenticationException;
import org.opendaylight.aaa.api.Claim;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.IdMService;
import org.opendaylight.aaa.api.IdMServiceImpl;
import org.opendaylight.aaa.api.PasswordCredentialAuth;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.aaa.api.model.Domain;
import org.opendaylight.aaa.api.model.Grant;
import org.opendaylight.aaa.api.model.Grants;
import org.opendaylight.aaa.api.model.Role;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.api.model.Users;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.tokenauthrealm.auth.ClaimBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IdmLightProxy
implements PasswordCredentialAuth,
IdMService,
ClaimCache {
    private static final Logger LOG = LoggerFactory.getLogger(IdmLightProxy.class);
    private final Map<String, Map<PasswordCredentials, Claim>> claimCache = new ConcurrentHashMap<String, Map<PasswordCredentials, Claim>>();
    private final IIDMStore idmStore;
    private final PasswordHashService passwordService;

    @Inject
    public IdmLightProxy(IIDMStore idmStore, PasswordHashService passwordService) {
        this.idmStore = idmStore;
        this.passwordService = Objects.requireNonNull(passwordService);
    }

    public Claim authenticate(PasswordCredentials creds) {
        Objects.requireNonNull(creds);
        Objects.requireNonNull(creds.username());
        Objects.requireNonNull(creds.password());
        String domain = creds.domain() == null ? "sdn" : creds.domain();
        return this.claimCache.computeIfAbsent(domain, k -> new ConcurrentHashMap()).computeIfAbsent(creds, this::dbAuthenticate);
    }

    public void clear() {
        LOG.info("Clearing the claim cache");
        this.claimCache.clear();
    }

    private Claim dbAuthenticate(PasswordCredentials creds) {
        Domain domain = null;
        User user = null;
        String credsDomain = creds.domain() == null ? "sdn" : creds.domain();
        LOG.debug("get domain");
        try {
            domain = this.idmStore.readDomain(credsDomain);
            if (domain == null) {
                throw new AuthenticationException("Domain :" + credsDomain + " does not exist");
            }
        }
        catch (IDMStoreException e) {
            throw new AuthenticationException("Error while fetching domain", (Throwable)e);
        }
        try {
            LOG.debug("check user / pwd");
            Users users = this.idmStore.getUsers(creds.username(), credsDomain);
            List userList = users.getUsers();
            if (userList.size() == 0) {
                throw new AuthenticationException("User :" + creds.username() + " does not exist in domain " + credsDomain);
            }
            user = (User)userList.get(0);
            if (!this.passwordService.passwordsMatch(creds.password(), user.getPassword(), user.getSalt())) {
                throw new AuthenticationException("UserName / Password not found");
            }
            if (!user.isEnabled().booleanValue()) {
                throw new AuthenticationException("Account is disabled");
            }
            LOG.debug("get grants");
            ArrayList<String> roles = new ArrayList<String>();
            Grants grants = this.idmStore.getGrants(domain.getDomainid(), user.getUserid());
            for (Grant grant : grants.getGrants()) {
                Role role = this.idmStore.readRole(grant.getRoleid());
                if (role == null) continue;
                roles.add(role.getName());
            }
            LOG.debug("build a claim");
            ClaimBuilder claim = new ClaimBuilder();
            claim.setUserId(user.getUserid());
            claim.setUser(creds.username());
            claim.setDomain(credsDomain);
            for (String string : roles) {
                claim.addRole(string);
            }
            return claim.build();
        }
        catch (IDMStoreException se) {
            throw new AuthenticationException("idm data store exception :" + se.toString() + se);
        }
    }

    public List<String> listDomains(String userId) {
        return new IdMServiceImpl(this.idmStore).listDomains(userId);
    }

    public List<String> listRoles(String userId, String domainName) {
        return new IdMServiceImpl(this.idmStore).listRoles(userId, domainName);
    }

    public List<String> listUserIDs() throws IDMStoreException {
        return new IdMServiceImpl(this.idmStore).listUserIDs();
    }
}

