/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.filters;

import java.util.Objects;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;

public final class AuthenticationTokenUtils {
    static final String DEFAULT_USERNAME = "an unknown user";
    static final String DEFAULT_TOKEN = "an un-parsable token type";
    static final String DEFAULT_HOSTNAME = "an unknown host";

    private AuthenticationTokenUtils() {
    }

    public static boolean isUsernamePasswordToken(AuthenticationToken token) {
        return token instanceof UsernamePasswordToken;
    }

    public static String extractUsername(AuthenticationToken token) {
        if (token instanceof UsernamePasswordToken) {
            UsernamePasswordToken upt = (UsernamePasswordToken)token;
            return AuthenticationTokenUtils.extractField(upt.getUsername(), DEFAULT_USERNAME);
        }
        return DEFAULT_TOKEN;
    }

    public static String extractHostname(AuthenticationToken token) {
        if (token instanceof UsernamePasswordToken) {
            UsernamePasswordToken upt = (UsernamePasswordToken)token;
            return AuthenticationTokenUtils.extractField(upt.getHost(), DEFAULT_HOSTNAME);
        }
        return DEFAULT_HOSTNAME;
    }

    public static String generateUnsuccessfulAuthenticationMessage(AuthenticationToken token) {
        String username = AuthenticationTokenUtils.extractUsername(token);
        String remoteHostname = AuthenticationTokenUtils.extractHostname(token);
        return String.format("Unsuccessful authentication attempt by %s from %s", username, remoteHostname);
    }

    public static String generateSuccessfulAuthenticationMessage(AuthenticationToken token) {
        String username = AuthenticationTokenUtils.extractUsername(token);
        String remoteHostname = AuthenticationTokenUtils.extractHostname(token);
        return String.format("Successful authentication attempt by %s from %s", username, remoteHostname);
    }

    private static String extractField(String field, String defaultValue) {
        String def = Objects.requireNonNull(defaultValue, "defaultValue can't be null");
        return field != null ? field : def;
    }
}

