/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.v9_1.ast.semantics;

import org.opencypher.v9_1.ast.semantics.SemanticCheckResult;
import org.opencypher.v9_1.ast.semantics.SemanticError;
import org.opencypher.v9_1.ast.semantics.SemanticExpressionCheck$;
import org.opencypher.v9_1.ast.semantics.SemanticFunSuite;
import org.opencypher.v9_1.ast.semantics.SemanticState$;
import org.opencypher.v9_1.expressions.Expression;
import org.opencypher.v9_1.expressions.SignedHexIntegerLiteral;
import org.opencypher.v9_1.util.DummyPosition$;
import org.opencypher.v9_1.util.InputPosition;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001\u001b\t)\u0002*\u001a=J]R,w-\u001a:MSR,'/\u00197UKN$(BA\u0002\u0005\u0003%\u0019X-\\1oi&\u001c7O\u0003\u0002\u0006\r\u0005\u0019\u0011m\u001d;\u000b\u0005\u001dA\u0011\u0001\u0002<:?FR!!\u0003\u0006\u0002\u0015=\u0004XM\\2za\",'OC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t\u00012+Z7b]RL7MR;o'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"a\u0004\u0001\t\u000b]\u0001A\u0011\u0002\r\u0002'\u0005\u001c8/\u001a:u'\u0016l\u0017M\u001c;jG\u0016\u0013(o\u001c:\u0015\u0007ey\u0002\u0006\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0003V]&$\b\"\u0002\u0011\u0017\u0001\u0004\t\u0013aC:ue&twMV1mk\u0016\u0004\"AI\u0013\u000f\u0005i\u0019\u0013B\u0001\u0013\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011ae\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011Z\u0002\"B\u0015\u0017\u0001\u0004\t\u0013\u0001D3se>\u0014X*Z:tC\u001e,\u0007")
public class HexIntegerLiteralTest
extends SemanticFunSuite {
    public void org$opencypher$v9_1$ast$semantics$HexIntegerLiteralTest$$assertSemanticError(String stringValue, String errorMessage) {
        SignedHexIntegerLiteral literal = new SignedHexIntegerLiteral(stringValue, DummyPosition$.MODULE$.apply(4));
        SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.check((Expression.SemanticContext)Expression.SemanticContext$.Simple$.MODULE$, (Expression)literal).apply((Object)SemanticState$.MODULE$.clean());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result.errors());
        Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError(errorMessage, DummyPosition$.MODULE$.apply(4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public HexIntegerLiteralTest() {
        this.test("correctly parses hexadecimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HexIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("0x22", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right = 34;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("0x0", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("0xffFF", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right3 = 65535;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("-0x9abc", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right4 = -39612;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid hexadecimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HexIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$opencypher$v9_1$ast$semantics$HexIntegerLiteralTest$$assertSemanticError("0x12g3", "invalid literal number");
                this.$outer.org$opencypher$v9_1$ast$semantics$HexIntegerLiteralTest$$assertSemanticError("0x", "invalid literal number");
                this.$outer.org$opencypher$v9_1$ast$semantics$HexIntegerLiteralTest$$assertSemanticError("0x33Y23", "invalid literal number");
                this.$outer.org$opencypher$v9_1$ast$semantics$HexIntegerLiteralTest$$assertSemanticError("-0x12g3", "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large hexadecimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HexIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$opencypher$v9_1$ast$semantics$HexIntegerLiteralTest$$assertSemanticError("0xfffffffffffffffff", "integer is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

