/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlValueTextBase;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlDateTimeValue
extends A_CmsXmlValueTextBase {
    public static final String TYPE_NAME = "OpenCmsDateTime";
    public static final String TYPE_RULE = "-?\\p{Digit}+|" + CmsStringUtil.escapePattern(CmsMacroResolver.formatMacro("currenttime"));
    private static final Pattern TYPE_PATTERN = Pattern.compile(TYPE_RULE);
    private long m_dateTime;

    public CmsXmlDateTimeValue() {
    }

    public CmsXmlDateTimeValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
        try {
            this.m_dateTime = Long.valueOf(this.m_stringValue);
        }
        catch (NumberFormatException e) {
            this.m_dateTime = 0L;
        }
    }

    public CmsXmlDateTimeValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlDateTimeValue(document, element, locale, this);
    }

    public long getDateTimeValue() {
        return this.m_dateTime;
    }

    @Override
    public String getDefault(Locale locale) {
        if (this.m_defaultValue != null) {
            return this.m_defaultValue;
        }
        return "0";
    }

    @Override
    public String getSchemaDefinition() {
        StringBuffer result = new StringBuffer(256);
        result.append("<xsd:simpleType name=\"ocmsdatedec\"><xsd:restriction base=\"xsd:decimal\">");
        result.append("</xsd:restriction></xsd:simpleType>");
        result.append("<xsd:simpleType name=\"ocmsdatemacro\">");
        result.append("<xsd:restriction base=\"xsd:string\">");
        result.append("<xsd:enumeration value=\"");
        result.append(CmsMacroResolver.formatMacro("currenttime"));
        result.append("\"/>");
        result.append("</xsd:restriction></xsd:simpleType>");
        result.append("<xsd:simpleType name=\"");
        result.append(TYPE_NAME);
        result.append("\"><xsd:union memberTypes=\"ocmsdatedec ocmsdatemacro\"/></xsd:simpleType>");
        return result.toString();
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlDateTimeValue(name, minOccurs, maxOccurs);
    }

    @Override
    public boolean validateValue(String value) {
        return TYPE_PATTERN.matcher(value).matches();
    }
}

