/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.relations.CmsLink;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsXmlContentValueLocation
implements I_CmsXmlContentValueLocation {
    private I_CmsXmlContentValue m_value;

    public CmsXmlContentValueLocation(I_CmsXmlContentValue value) {
        if (value == null) {
            throw new UnsupportedOperationException("Can't create content value location with a null value.");
        }
        this.m_value = value;
    }

    @Override
    public CmsUUID asId(CmsObject cms) {
        CmsLink link = ((CmsXmlVfsFileValue)this.m_value).getLink(cms);
        if (link == null) {
            return null;
        }
        return link.getStructureId();
    }

    @Override
    public String asString(CmsObject cms) {
        return this.m_value.getStringValue(cms);
    }

    @Override
    public I_CmsXmlDocument getDocument() {
        return this.m_value.getDocument();
    }

    @Override
    public Locale getLocale() {
        return this.m_value.getLocale();
    }

    @Override
    public CmsXmlContentValueLocation getSubValue(String subPath) {
        Locale locale = this.m_value.getLocale();
        I_CmsXmlContentValue subValue = this.m_value.getDocument().getValue(CmsXmlUtils.concatXpath(this.m_value.getPath(), subPath), locale);
        if (subValue != null) {
            return new CmsXmlContentValueLocation(subValue);
        }
        return null;
    }

    @Override
    public List<I_CmsXmlContentValueLocation> getSubValues(String subPath) {
        ArrayList<I_CmsXmlContentValueLocation> result = new ArrayList<I_CmsXmlContentValueLocation>();
        Locale locale = this.m_value.getLocale();
        List<I_CmsXmlContentValue> subValues = this.m_value.getDocument().getValues(CmsXmlUtils.concatXpath(this.m_value.getPath(), subPath), locale);
        for (I_CmsXmlContentValue subValue : subValues) {
            if (subValue == null) continue;
            result.add(new CmsXmlContentValueLocation(subValue));
        }
        return result;
    }

    @Override
    public I_CmsXmlContentValue getValue() {
        return this.m_value;
    }
}

