/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReference;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReferenceParser;
import org.opencms.ade.containerpage.inherited.CmsInheritedContainerState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.Messages;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;

public class CmsXmlInheritGroupContainerHandler
extends CmsDefaultXmlContentHandler {
    private static final Log LOG = CmsLog.getLog(CmsXmlInheritGroupContainerHandler.class);

    public static List<CmsContainerElementBean> loadInheritContainerElements(CmsObject cms, CmsResource resource) {
        CmsInheritanceReferenceParser parser = new CmsInheritanceReferenceParser(cms);
        try {
            parser.parse(resource);
            CmsInheritanceReference ref = parser.getReference(cms.getRequestContext().getLocale());
            if (ref != null) {
                String name = ref.getName();
                CmsADEManager adeManager = OpenCms.getADEManager();
                CmsInheritedContainerState result = adeManager.getInheritedContainerState(cms, cms.getRequestContext().getRootUri(), name);
                return result.getElements(false);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public Set<String> getCSSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        List<CmsContainerElementBean> containerElements = CmsXmlInheritGroupContainerHandler.loadInheritContainerElements(cms, resource);
        for (CmsContainerElementBean elementBean : containerElements) {
            if (elementBean.isGroupContainer(cms) || elementBean.isInheritedContainer(cms)) {
                throw new CmsException(Messages.get().container("ERR_ELEMENT_GROUP_REFERENCES_ANOTHER_GROUP_2", resource.getRootPath(), elementBean.getResource().getRootPath()));
            }
            CmsResource elementResource = elementBean.getResource();
            Set<String> elementIncludes = CmsXmlContentDefinition.getContentHandlerForResource(cms, elementResource).getCSSHeadIncludes(cms, elementResource);
            result.addAll(elementIncludes);
        }
        return result;
    }

    @Override
    public Set<String> getJSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        List<CmsContainerElementBean> containerElements = CmsXmlInheritGroupContainerHandler.loadInheritContainerElements(cms, resource);
        for (CmsContainerElementBean elementBean : containerElements) {
            if (elementBean.isGroupContainer(cms) || elementBean.isInheritedContainer(cms)) {
                throw new CmsException(Messages.get().container("ERR_ELEMENT_GROUP_REFERENCES_ANOTHER_GROUP_2", resource.getRootPath(), elementBean.getResource().getRootPath()));
            }
            CmsResource elementResource = elementBean.getResource();
            Set<String> elementIncludes = CmsXmlContentDefinition.getContentHandlerForResource(cms, elementResource).getJSHeadIncludes(cms, elementResource);
            result.addAll(elementIncludes);
        }
        return result;
    }
}

