/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletRequest;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsADECache;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.content.Messages;
import org.xml.sax.EntityResolver;

public final class CmsXmlGroupContainerFactory {
    private CmsXmlGroupContainerFactory() {
    }

    public static CmsXmlGroupContainer createDocument(CmsObject cms, Locale locale, String modelUri) throws CmsException {
        CmsXmlGroupContainer content = new CmsXmlGroupContainer(cms, locale, modelUri);
        return (CmsXmlGroupContainer)content.getHandler().prepareForUse(cms, content);
    }

    public static CmsXmlGroupContainer createDocument(CmsObject cms, Locale locale, String encoding, CmsXmlContentDefinition contentDefinition) {
        CmsXmlGroupContainer content = new CmsXmlGroupContainer(cms, locale, encoding, contentDefinition);
        return (CmsXmlGroupContainer)content.getHandler().prepareForUse(cms, content);
    }

    public static CmsXmlGroupContainer unmarshal(CmsObject cms, byte[] xmlData, String encoding, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlGroupContainerFactory.unmarshal(cms, CmsXmlUtils.unmarshalHelper(xmlData, resolver), encoding, resolver);
    }

    public static CmsXmlGroupContainer unmarshal(CmsObject cms, CmsFile file) throws CmsXmlException {
        return CmsXmlGroupContainerFactory.unmarshal(cms, file, true);
    }

    public static CmsXmlGroupContainer unmarshal(CmsObject cms, CmsFile file, boolean keepEncoding) throws CmsXmlException {
        CmsXmlGroupContainer content = CmsXmlGroupContainerFactory.getCache(cms, file, keepEncoding);
        if (content != null) {
            return content;
        }
        byte[] contentBytes = file.getContents();
        String filename = cms.getSitePath(file);
        String encoding = null;
        try {
            encoding = cms.readPropertyObject(filename, "content-encoding", true).getValue();
        }
        catch (CmsException e) {
            // empty catch block
        }
        if (encoding == null) {
            encoding = OpenCms.getSystemInfo().getDefaultEncoding();
        } else if ((encoding = CmsEncoder.lookupEncoding(encoding, null)) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ENC_1", filename));
        }
        if (contentBytes.length > 0) {
            if (keepEncoding) {
                content = CmsXmlGroupContainerFactory.unmarshal(cms, contentBytes, encoding, (EntityResolver)new CmsXmlEntityResolver(cms));
            } else {
                try {
                    String contentStr = new String(contentBytes, encoding);
                    content = CmsXmlGroupContainerFactory.unmarshal(cms, contentStr, encoding, (EntityResolver)new CmsXmlEntityResolver(cms));
                }
                catch (UnsupportedEncodingException e) {
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ENC_1", filename));
                }
            }
        } else {
            content = new CmsXmlGroupContainer(cms, DocumentHelper.createDocument(), encoding, new CmsXmlEntityResolver(cms));
        }
        content.setFile(file);
        CmsXmlGroupContainer xmlGroupContainer = (CmsXmlGroupContainer)content.getHandler().prepareForUse(cms, content);
        CmsXmlGroupContainerFactory.setCache(cms, xmlGroupContainer, keepEncoding);
        return xmlGroupContainer;
    }

    public static CmsXmlGroupContainer unmarshal(CmsObject cms, CmsResource resource) throws CmsException {
        CmsXmlGroupContainer content = CmsXmlGroupContainerFactory.getCache(cms, resource, true);
        if (content != null) {
            return content;
        }
        content = CmsXmlGroupContainerFactory.unmarshal(cms, cms.readFile(resource), true);
        CmsXmlGroupContainerFactory.setCache(cms, content, true);
        return content;
    }

    public static CmsXmlGroupContainer unmarshal(CmsObject cms, CmsResource resource, ServletRequest req) throws CmsXmlException, CmsLoaderException, CmsException {
        String rootPath = resource.getRootPath();
        CmsXmlGroupContainer content = (CmsXmlGroupContainer)req.getAttribute(rootPath);
        if (content == null) {
            content = CmsXmlGroupContainerFactory.unmarshal(cms, resource);
            req.setAttribute(rootPath, (Object)content);
        }
        return content;
    }

    public static CmsXmlGroupContainer unmarshal(CmsObject cms, Document document, String encoding, EntityResolver resolver) {
        CmsXmlGroupContainer content = new CmsXmlGroupContainer(cms, document, encoding, resolver);
        return (CmsXmlGroupContainer)content.getHandler().prepareForUse(cms, content);
    }

    public static CmsXmlGroupContainer unmarshal(CmsObject cms, String xmlData, String encoding, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlGroupContainerFactory.unmarshal(cms, CmsXmlUtils.unmarshalHelper(xmlData, resolver), encoding, resolver);
    }

    private static CmsADECache getCache() {
        return OpenCms.getADEManager().getCache();
    }

    private static CmsXmlGroupContainer getCache(CmsObject cms, CmsResource resource, boolean keepEncoding) {
        if (resource instanceof I_CmsHistoryResource) {
            return null;
        }
        return CmsXmlGroupContainerFactory.getCache().getCacheGroupContainer(CmsXmlGroupContainerFactory.getCache().getCacheKey(resource.getStructureId(), keepEncoding), cms.getRequestContext().getCurrentProject().isOnlineProject());
    }

    private static void setCache(CmsObject cms, CmsXmlGroupContainer xmlGroupContainer, boolean keepEncoding) {
        if (xmlGroupContainer.getFile() instanceof I_CmsHistoryResource) {
            return;
        }
        boolean online = cms.getRequestContext().getCurrentProject().isOnlineProject();
        CmsXmlGroupContainerFactory.getCache().setCacheGroupContainer(CmsXmlGroupContainerFactory.getCache().getCacheKey(xmlGroupContainer.getFile().getStructureId(), keepEncoding), xmlGroupContainer, online);
    }
}

