/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.relations.CmsLink;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.Messages;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.types.CmsXmlVarLinkValue;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsXmlContainerPageHandler
extends CmsDefaultXmlContentHandler {
    @Override
    public CmsXmlContentErrorHandler resolveValidation(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = new CmsXmlContentErrorHandler();
        }
        if (value != null && CmsXmlUtils.removeXpath(value.getPath()).equals(CmsXmlContainerPage.XmlNode.Containers.name())) {
            CmsXmlContent content = (CmsXmlContent)value.getDocument();
            try {
                this.validateNames(cms, value, content);
            }
            catch (CmsXmlException e) {
                errorHandler.addError(value, e.getLocalizedMessage());
            }
        }
        return errorHandler;
    }

    @Override
    protected boolean validateLink(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        if (value == null || !(value instanceof CmsXmlVfsFileValue) && !(value instanceof CmsXmlVarLinkValue)) {
            return false;
        }
        CmsLink link = null;
        if (value instanceof CmsXmlVfsFileValue) {
            link = ((CmsXmlVfsFileValue)value).getLink(cms);
        } else if (value instanceof CmsXmlVarLinkValue) {
            link = ((CmsXmlVarLinkValue)value).getLink(cms);
        }
        if (link == null || !link.isInternal()) {
            return false;
        }
        try {
            String sitePath = cms.getRequestContext().removeSiteRoot(link.getTarget());
            CmsResource res = cms.readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            if (cms.getRequestContext().getCurrentProject().isOnlineProject() && res != null) {
                long time = System.currentTimeMillis();
                if (!res.isReleased(time)) {
                    if (errorHandler != null) {
                        errorHandler.addWarning(value, org.opencms.xml.content.Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_WARNING_NOT_RELEASED_0"));
                    }
                    return true;
                }
                if (res.isExpired(time)) {
                    if (errorHandler != null) {
                        errorHandler.addWarning(value, org.opencms.xml.content.Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_WARNING_EXPIRED_0"));
                    }
                    return true;
                }
            }
        }
        catch (CmsException e) {
            if (errorHandler != null) {
                errorHandler.addError(value, org.opencms.xml.content.Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_ERROR_0"));
            }
            return true;
        }
        return false;
    }

    protected void validateNames(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContent content) throws CmsXmlException {
        Locale locale = value.getLocale();
        String namePath = CmsXmlUtils.concatXpath(value.getPath(), CmsXmlContainerPage.XmlNode.Name.name());
        String name = content.getValue(namePath, locale).getStringValue(cms);
        for (I_CmsXmlContentValue itValue : content.getValues(CmsXmlContainerPage.XmlNode.Containers.name(), locale)) {
            String itName;
            if (itValue.getPath().equals(value.getPath()) || !name.equals(itName = content.getValue(namePath = CmsXmlUtils.concatXpath(itValue.getPath(), CmsXmlContainerPage.XmlNode.Name.name()), locale).getStringValue(cms))) continue;
            throw new CmsXmlException(Messages.get().container("ERR_DUPLICATE_NAME_1", name));
        }
    }
}

