/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;
import org.opencms.workplace.tools.CmsIdentifiableObjectContainer;
import org.opencms.workplace.tools.CmsTool;
import org.opencms.workplace.tools.CmsToolDialog;
import org.opencms.workplace.tools.CmsToolMacroResolver;
import org.opencms.workplace.tools.CmsToolRootHandler;
import org.opencms.workplace.tools.CmsToolUserData;
import org.opencms.workplace.tools.I_CmsToolHandler;
import org.opencms.workplace.tools.Messages;

public class CmsToolManager {
    public static final String ADMINVIEW_ROOT_LOCATION = "/system/workplace/views/admin";
    public static final String HANDLERCLASS_PROPERTY = "admintoolhandler-class";
    public static final String NAVBAR_SEPARATOR = "\n&nbsp;&gt;&nbsp;\n";
    public static final String ROOT_SEPARATOR = ":";
    public static final String ROOTKEY_DEFAULT = "admin";
    public static final String TOOLPATH_SEPARATOR = "/";
    public static final String VIEW_JSPPAGE_LOCATION = "/system/workplace/views/admin/admin-main.jsp";
    private static final Log LOG = CmsLog.getLog(CmsToolManager.class);
    private final CmsIdentifiableObjectContainer<CmsToolRootHandler> m_roots = new CmsIdentifiableObjectContainer(true, false);
    private final CmsIdentifiableObjectContainer<CmsTool> m_tools = new CmsIdentifiableObjectContainer(true, false);
    private final CmsIdentifiableObjectContainer<String> m_urls = new CmsIdentifiableObjectContainer(false, false);

    public static String linkForToolPath(CmsJspActionElement jsp, String toolPath) {
        StringBuffer result = new StringBuffer();
        result.append(jsp.link(VIEW_JSPPAGE_LOCATION));
        result.append('?');
        result.append("path");
        result.append('=');
        result.append(CmsEncoder.encode(toolPath));
        return result.toString();
    }

    public static String linkForToolPath(CmsJspActionElement jsp, String toolPath, Map<String, String[]> params) {
        if (params == null) {
            return CmsToolManager.linkForToolPath(jsp, toolPath);
        }
        params.put("path", new String[]{toolPath});
        return CmsRequestUtil.appendParameters(jsp.link(VIEW_JSPPAGE_LOCATION), params, true);
    }

    public void addToolRoot(CmsToolRootHandler toolRoot) {
        this.m_roots.addIdentifiableObject(toolRoot.getKey(), toolRoot);
    }

    public void configure(CmsObject cms) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_CREATED_0"));
        }
        if (this.m_roots.getObject(ROOTKEY_DEFAULT) == null) {
            CmsToolRootHandler defToolRoot = new CmsToolRootHandler();
            defToolRoot.setKey(ROOTKEY_DEFAULT);
            defToolRoot.setUri("/system/workplace/admin/");
            defToolRoot.setName("${key.GUI_ADMIN_VIEW_ROOT_NAME_0}");
            defToolRoot.setHelpText("${key.GUI_ADMIN_VIEW_ROOT_HELP_0}");
            this.addToolRoot(defToolRoot);
        }
        this.m_tools.clear();
        this.m_urls.clear();
        for (CmsToolRootHandler toolRoot : this.getToolRoots()) {
            if (!cms.existsResource(toolRoot.getUri())) {
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_ROOT_SKIPPED_2", toolRoot.getKey(), toolRoot.getUri()));
                continue;
            }
            try {
                toolRoot.setup(cms, null, toolRoot.getUri());
                this.configureToolRoot(cms, toolRoot);
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_SETUP_1", toolRoot.getKey()));
            }
            catch (CmsException e) {
                if (!CmsLog.INIT.isWarnEnabled()) continue;
                CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_SETUP_ERROR_1", toolRoot.getKey()), (Throwable)e);
            }
        }
    }

    public String generateNavBar(String toolPath, CmsWorkplace wp) {
        if (toolPath.equals(this.getBaseToolPath(wp))) {
            return "<div class='pathbar'>&nbsp;</div>\n";
        }
        CmsTool adminTool = this.resolveAdminTool(this.getCurrentRoot(wp).getKey(), toolPath);
        String html = A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, "nav" + adminTool.getId(), adminTool.getHandler().getName(), null, false, null, null, null);
        String parent = toolPath;
        while (!parent.equals(this.getBaseToolPath(wp))) {
            parent = this.getParent(wp, parent);
            adminTool = this.resolveAdminTool(this.getCurrentRoot(wp).getKey(), parent);
            String id = "nav" + adminTool.getId();
            String link = CmsToolManager.linkForToolPath(wp.getJsp(), parent, adminTool.getHandler().getParameters(wp));
            String onClic = "openPage('" + link + "');";
            String buttonHtml = A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, id, adminTool.getHandler().getName(), adminTool.getHandler().getHelpText(), true, null, null, onClic);
            html = buttonHtml + NAVBAR_SEPARATOR + html;
        }
        html = CmsToolMacroResolver.resolveMacros(html, wp);
        html = CmsEncoder.decode(html);
        html = CmsToolMacroResolver.resolveMacros(html, wp);
        html = "<div class='pathbar'>\n" + html + "&nbsp;</div>\n";
        return html;
    }

    public String getBaseToolPath(CmsWorkplace wp) {
        CmsToolUserData userData = this.getUserData(wp);
        String path = TOOLPATH_SEPARATOR;
        if (userData != null) {
            path = userData.getBaseTool(this.getCurrentRoot(wp).getKey());
        }
        return path;
    }

    public CmsToolRootHandler getCurrentRoot(CmsWorkplace wp) {
        CmsToolUserData userData = this.getUserData(wp);
        String root = ROOTKEY_DEFAULT;
        if (userData != null) {
            if (this.m_roots.getObject(userData.getRootKey()) != null) {
                root = userData.getRootKey();
            } else if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_NOT_CONFIGURED_ROOT_1", userData.getRootKey()));
            }
        }
        return this.m_roots.getObject(root);
    }

    public CmsTool getCurrentTool(CmsWorkplace wp) {
        return this.resolveAdminTool(this.getCurrentRoot(wp).getKey(), this.getCurrentToolPath(wp));
    }

    public String getCurrentToolPath(CmsWorkplace wp) {
        CmsToolUserData userData = this.getUserData(wp);
        String path = this.getBaseToolPath(wp);
        if (userData != null) {
            path = userData.getCurrentToolPath(this.getCurrentRoot(wp).getKey());
        }
        return path;
    }

    public String getParent(CmsWorkplace wp, String toolPath) {
        if (toolPath.equals(this.getBaseToolPath(wp))) {
            return toolPath;
        }
        int pos = toolPath.lastIndexOf(TOOLPATH_SEPARATOR);
        return pos <= 0 ? TOOLPATH_SEPARATOR : toolPath.substring(0, pos);
    }

    public List<CmsTool> getToolHandlers() {
        return this.m_tools.elementList();
    }

    public List<CmsToolRootHandler> getToolRoots() {
        return this.m_roots.elementList();
    }

    public List<CmsTool> getToolsForPath(CmsWorkplace wp, String baseTool, boolean includeSubtools) {
        ArrayList<CmsTool> toolList = new ArrayList<CmsTool>();
        String rootKey = this.getCurrentRoot(wp).getKey();
        for (CmsTool tool : this.m_tools.elementList()) {
            String path = tool.getHandler().getPath();
            if (this.resolveAdminTool(rootKey, path) != tool || path.equals(TOOLPATH_SEPARATOR) || !path.startsWith(baseTool) || !baseTool.equals(TOOLPATH_SEPARATOR) && !path.startsWith(baseTool + TOOLPATH_SEPARATOR) || !includeSubtools && path.indexOf(TOOLPATH_SEPARATOR, baseTool.length() + 1) >= 0) continue;
            toolList.add(tool);
        }
        return toolList;
    }

    public CmsToolUserData getUserData(CmsWorkplace wp) {
        CmsToolUserData userData = wp.getSettings().getToolUserData();
        if (userData == null) {
            userData = new CmsToolUserData();
            userData.setRootKey(ROOTKEY_DEFAULT);
            for (CmsToolRootHandler root : this.getToolRoots()) {
                userData.setCurrentToolPath(root.getKey(), TOOLPATH_SEPARATOR);
                userData.setBaseTool(root.getKey(), TOOLPATH_SEPARATOR);
            }
            wp.getSettings().setToolUserData(userData);
        }
        return userData;
    }

    public boolean hasToolPathForUrl(String url) {
        List<String> toolPaths = this.m_urls.getObjectList(url);
        return toolPaths != null && !toolPaths.isEmpty();
    }

    public synchronized void initParams(CmsToolDialog wp) {
        this.setCurrentRoot(wp, wp.getParamRoot());
        this.setCurrentToolPath(wp, wp.getParamPath());
        this.setBaseToolPath(wp, wp.getParamBase());
        if (!this.getCurrentToolPath(wp).startsWith(this.getBaseToolPath(wp))) {
            this.setCurrentToolPath(wp, this.getBaseToolPath(wp));
        }
        wp.setParamPath(this.getCurrentToolPath(wp));
        wp.setParamBase(this.getBaseToolPath(wp));
        wp.setParamRoot(this.getCurrentRoot(wp).getKey());
    }

    public void jspForwardPage(CmsWorkplace wp, String pagePath, Map<String, String[]> params) throws IOException, ServletException {
        Map<String, String[]> newParams = this.createToolParams(wp, pagePath, params);
        if (pagePath.indexOf("?") > 0) {
            pagePath = pagePath.substring(0, pagePath.indexOf("?"));
        }
        wp.setForwarded(true);
        CmsRequestUtil.forwardRequest(wp.getJsp().link(pagePath), CmsRequestUtil.createParameterMap(newParams), wp.getJsp().getRequest(), wp.getJsp().getResponse());
    }

    public void jspForwardTool(CmsWorkplace wp, String toolPath, Map<String, String[]> params) throws IOException, ServletException {
        HashMap<Object, Object> newParams = params == null ? new HashMap() : new HashMap<String, String[]>(params);
        newParams.put("path", new String[]{toolPath});
        this.jspForwardPage(wp, VIEW_JSPPAGE_LOCATION, newParams);
    }

    public CmsTool resolveAdminTool(String rootKey, String toolPath) {
        return this.m_tools.getObject(rootKey + ROOT_SEPARATOR + toolPath);
    }

    public void setBaseToolPath(CmsWorkplace wp, String baseToolPath) {
        if (CmsStringUtil.isEmpty(baseToolPath) || baseToolPath.trim().equals("null")) {
            baseToolPath = this.getBaseToolPath(wp);
        }
        baseToolPath = this.repairPath(wp, baseToolPath);
        CmsToolUserData userData = this.getUserData(wp);
        userData.setBaseTool(userData.getRootKey(), baseToolPath);
    }

    public void setCurrentRoot(CmsWorkplace wp, String key) {
        if (CmsStringUtil.isEmpty(key) || key.trim().equals("null")) {
            key = this.getCurrentRoot(wp).getKey();
        }
        CmsToolUserData userData = this.getUserData(wp);
        userData.setRootKey(key);
    }

    public void setCurrentToolPath(CmsWorkplace wp, String currentToolPath) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(currentToolPath) || currentToolPath.trim().equals("null")) {
            currentToolPath = this.getCurrentToolPath(wp);
        }
        currentToolPath = this.repairPath(wp, currentToolPath);
        CmsToolUserData userData = this.getUserData(wp);
        userData.setCurrentToolPath(userData.getRootKey(), currentToolPath);
    }

    private void configureToolRoot(CmsObject cms, CmsToolRootHandler toolRoot) throws CmsException {
        ArrayList<I_CmsToolHandler> handlers = new ArrayList<I_CmsToolHandler>();
        handlers.add(toolRoot);
        List<CmsResource> resources = cms.readResourcesWithProperty(toolRoot.getUri(), HANDLERCLASS_PROPERTY);
        for (CmsResource res : resources) {
            CmsProperty prop = cms.readPropertyObject(res.getRootPath(), HANDLERCLASS_PROPERTY, false);
            if (prop.isNullProperty()) continue;
            try {
                Class<?> handlerClass = Class.forName(prop.getValue());
                I_CmsToolHandler handler = (I_CmsToolHandler)handlerClass.newInstance();
                if (!handler.setup(cms, toolRoot, res.getRootPath()) && CmsLog.INIT.isWarnEnabled()) {
                    CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_TOOL_SETUP_ERROR_1", res.getRootPath()));
                }
                handlers.add(handler);
                if (!CmsLog.INIT.isDebugEnabled()) continue;
                if (!handler.getLink().equals(VIEW_JSPPAGE_LOCATION)) {
                    CmsLog.INIT.debug((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_NEWTOOL_FOUND_2", handler.getPath(), handler.getLink()));
                    continue;
                }
                CmsLog.INIT.debug((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_NEWTOOL_FOUND_2", handler.getPath(), res.getRootPath()));
            }
            catch (Exception e) {
                if (!CmsLog.INIT.isWarnEnabled()) continue;
                CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_TOOL_SETUP_ERROR_1", res.getRootPath()), (Throwable)e);
            }
        }
        this.registerHandlerList(cms, toolRoot, 1, handlers);
    }

    private Map<String, String[]> createToolParams(CmsWorkplace wp, String url, Map<String, String[]> params) {
        HashMap<String, String[]> newParams = new HashMap<String, String[]>();
        if (url.indexOf("?") > 0) {
            String query = url.substring(url.indexOf("?"));
            Map<String, String[]> reqParameters = CmsRequestUtil.createParameterMap(query);
            newParams.putAll(reqParameters);
        }
        if (params != null) {
            newParams.putAll(params);
        }
        if (!newParams.containsKey("closelink")) {
            Map<String, String[]> argMap = this.resolveAdminTool(this.getCurrentRoot(wp).getKey(), this.getCurrentToolPath(wp)).getHandler().getParameters(wp);
            newParams.put("closelink", new String[]{CmsToolManager.linkForToolPath(wp.getJsp(), this.getCurrentToolPath(wp), argMap)});
        }
        return newParams;
    }

    private void registerAdminTool(CmsObject cms, CmsToolRootHandler toolRoot, I_CmsToolHandler handler) {
        String link = handler.getLink();
        if (link.indexOf("?") > 0) {
            link = link.substring(0, link.indexOf("?"));
        }
        if (!cms.existsResource(link)) {
            return;
        }
        if (!this.validatePath(toolRoot.getKey(), handler.getPath(), false)) {
            if (CmsLog.INIT.isWarnEnabled()) {
                CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_INCONSISTENT_PATH_2", handler.getPath(), handler.getLink()));
            }
            return;
        }
        String id = "tool" + this.m_tools.elementList().size();
        CmsTool tool = new CmsTool(id, handler);
        try {
            handler.isEnabled(cms);
            handler.isVisible(cms);
        }
        catch (Throwable ex) {
            String message = Messages.get().getBundle().key("INIT_TOOLMANAGER_INSTALL_ERROR_2", handler.getPath(), handler.getLink());
            if (CmsLog.INIT.isWarnEnabled()) {
                CmsLog.INIT.warn((Object)message);
            } else if (CmsLog.INIT.isDebugEnabled()) {
                CmsLog.INIT.debug((Object)message, ex);
            }
            return;
        }
        try {
            this.m_tools.addIdentifiableObject(toolRoot.getKey() + ROOT_SEPARATOR + handler.getPath(), tool);
            this.m_urls.addIdentifiableObject(link, handler.getPath());
        }
        catch (Throwable ex) {
            CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_TOOLMANAGER_DUPLICATED_ERROR_3", handler.getPath(), handler.getLink(), this.resolveAdminTool(toolRoot.getKey(), handler.getPath()).getHandler().getLink()));
        }
    }

    private void registerHandlerList(CmsObject cms, CmsToolRootHandler toolRoot, int len, List<I_CmsToolHandler> handlers) {
        boolean found = false;
        for (I_CmsToolHandler handler : handlers) {
            int myLen = CmsStringUtil.splitAsArray(handler.getPath(), TOOLPATH_SEPARATOR).length;
            if ((len != myLen || handler.getPath().equals(TOOLPATH_SEPARATOR)) && (len != 1 || !handler.getPath().equals(TOOLPATH_SEPARATOR))) continue;
            found = true;
            this.registerAdminTool(cms, toolRoot, handler);
        }
        if (found) {
            this.registerHandlerList(cms, toolRoot, len + 1, handlers);
        }
    }

    private String repairPath(CmsWorkplace wp, String path) {
        String rootKey = this.getCurrentRoot(wp).getKey();
        while (!this.validatePath(rootKey, path, true)) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_MISSING_ADMIN_TOOL_1", path));
            path = this.getParent(wp, path);
        }
        while (this.resolveAdminTool(rootKey, path) == null) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_MISSING_ADMIN_TOOL_1", path));
            path = this.getParent(wp, path);
        }
        CmsTool aTool = this.resolveAdminTool(rootKey, path);
        while (!aTool.getHandler().isEnabled(wp) && !aTool.getHandler().getLink().equals(VIEW_JSPPAGE_LOCATION)) {
            path = this.getParent(wp, path);
            aTool = this.resolveAdminTool(rootKey, path);
        }
        return path;
    }

    private boolean validatePath(String rootKey, String toolPath, boolean full) {
        if (toolPath.equals(TOOLPATH_SEPARATOR)) {
            return true;
        }
        if (!toolPath.startsWith(TOOLPATH_SEPARATOR)) {
            return false;
        }
        List<String> groups = CmsStringUtil.splitAsList(toolPath, TOOLPATH_SEPARATOR);
        Iterator<String> itGroups = groups.iterator();
        String subpath = "";
        while (itGroups.hasNext()) {
            String group = itGroups.next();
            subpath = subpath.length() != TOOLPATH_SEPARATOR.length() ? subpath + TOOLPATH_SEPARATOR + group : subpath + group;
            if (!itGroups.hasNext() && !full) continue;
            try {
                this.resolveAdminTool(rootKey, subpath).toString();
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

