/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.search;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.search.CmsSearchResult;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsExplorer;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListExplorerColumn;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListResourceCollector;
import org.opencms.workplace.search.CmsSearchDialog;
import org.opencms.workplace.search.CmsSearchResourcesCollector;
import org.opencms.workplace.search.CmsSearchWorkplaceBean;
import org.opencms.workplace.search.Messages;

public class CmsSearchResultsList
extends A_CmsListExplorerDialog {
    public static final String LIST_COLUMN_SCORE = "cs";
    public static final String LIST_DETAIL_EXCERPT = "de";
    public static final String LIST_ID = "lsr";
    public static final String PATH_BUTTONS = "tools/ex_search/buttons/";
    private I_CmsListResourceCollector m_collector;
    private CmsSearchWorkplaceBean m_searchParams;

    public CmsSearchResultsList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_SEARCH_LIST_NAME_0"), "ecn", CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsSearchResultsList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() throws IOException, ServletException {
        if (this.getParamListAction().equals("eae")) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("action", (String[])"initial");
            params.put("closelink", (String[])"/system/workplace/views/workplace.jsp");
            params.put("backlink", (String[])"/system/workplace/views/workplace.jsp");
            params.put("resource", (String[])this.getSelectedItem().get("ecn"));
            this.getToolManager().jspForwardPage(this, "/system/workplace/explorer/search/edit.jsp", params);
        } else {
            this.throwListUnsupportedActionException();
        }
    }

    @Override
    public I_CmsListResourceCollector getCollector() {
        if (this.m_collector == null) {
            this.m_collector = new CmsSearchResourcesCollector(this, this.getSearchParams().getQuery(), this.getSearchParams().getSortOrder(), this.getSearchParams().getFields(), Collections.singletonList(this.getSearchParams().getSearchPath()), this.getSearchParams().getMinDateCreated(), this.getSearchParams().getMaxDateCreated(), this.getSearchParams().getMinDateLastModified(), this.getSearchParams().getMaxDateLastModified(), this.getSearchParams().getIndexName());
            CmsResourceUtil resUtil = this.getResourceUtil();
            resUtil.setAbbrevLength(50);
            resUtil.setSiteMode(CmsResourceUtil.SITE_MODE_MATCHING);
        }
        return this.m_collector;
    }

    @Override
    protected String defaultActionHtmlStart() {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.htmlStart(null));
        result.append(this.getList().listJs());
        result.append(CmsListExplorerColumn.getExplorerStyleDef());
        result.append("<script language='JavaScript'>\n");
        result.append(new CmsExplorer(this.getJsp()).getInitializationHeader());
        result.append("\ntop.updateWindowStore();\n");
        result.append("top.displayHead(top.win.head, 0, 1);\n}\n");
        result.append("</script>");
        result.append(this.bodyStart("dialog", "onload='initialize();'"));
        result.append(this.dialogStart());
        result.append(this.dialogContentStart(this.getParamTitle()));
        return result.toString();
    }

    @Override
    protected void fillDetails(String detailId) {
        if (detailId.equals(LIST_DETAIL_EXCERPT)) {
            CmsSearchResourcesCollector collector = (CmsSearchResourcesCollector)this.getCollector();
            for (CmsListItem item : this.getList().getAllContent()) {
                CmsSearchResult result;
                if (item.getId().equals(CmsUUID.getNullUUID().toString()) || (result = collector.getSearchResult(item.getId())) == null) continue;
                item.set(detailId, result.getExcerpt());
            }
        }
    }

    @Override
    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        CmsListExplorerColumn scoreCol = new CmsListExplorerColumn(LIST_COLUMN_SCORE);
        scoreCol.setName(Messages.get().container("GUI_SEARCH_LIST_COLS_SCORE_0"));
        scoreCol.setHelpText(Messages.get().container("GUI_SEARCH_LIST_COLS_SCORE_HELP_0"));
        scoreCol.setAlign(CmsListColumnAlignEnum.ALIGN_RIGHT);
        metadata.addColumn(scoreCol);
        for (CmsListColumnDefinition column : metadata.getColumnDefinitions()) {
            column.setSorteable(false);
        }
    }

    @Override
    protected void setColumnVisibilities() {
        super.setColumnVisibilities();
        this.setColumnVisibility("ece".hashCode(), "ece".hashCode());
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        super.setIndependentActions(metadata);
        CmsListItemDetails excerptDetails = new CmsListItemDetails(LIST_DETAIL_EXCERPT);
        excerptDetails.setAtColumn("ecn");
        excerptDetails.setVisible(true);
        excerptDetails.setShowActionName(Messages.get().container("GUI_SEARCH_DETAIL_SHOW_EXCERPT_NAME_0"));
        excerptDetails.setShowActionHelpText(Messages.get().container("GUI_SEARCH_DETAIL_SHOW_EXCERPT_HELP_0"));
        excerptDetails.setHideActionName(Messages.get().container("GUI_SEARCH_DETAIL_HIDE_EXCERPT_NAME_0"));
        excerptDetails.setHideActionHelpText(Messages.get().container("GUI_SEARCH_DETAIL_HIDE_EXCERPT_HELP_0"));
        excerptDetails.setName(Messages.get().container("GUI_SEARCH_DETAIL_EXCERPT_NAME_0"));
        excerptDetails.setFormatter(new I_CmsListFormatter(){

            @Override
            public String format(Object data, Locale locale) {
                return (String)data;
            }
        });
        metadata.addItemDetails(excerptDetails);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }

    @Override
    protected void validateParamaters() throws Exception {
        if (this.getSearchParams() == null) {
            throw new Exception();
        }
    }

    private CmsSearchWorkplaceBean getSearchParams() {
        if (this.m_searchParams == null) {
            this.m_searchParams = (CmsSearchWorkplaceBean)((Map)this.getSettings().getDialogObject()).get(CmsSearchDialog.class.getName());
        }
        return this.m_searchParams;
    }
}

