/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.i18n.CmsEncoder;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListSearchAction;

public class CmsListMultiSearchAction
extends CmsListSearchAction {
    public static final String KEY_VAL_DELIM = "#";
    public static final String PARAM_DELIM = "|";
    public static final String SEARCH_COL_INPUT_ID = "listColFilter";

    public CmsListMultiSearchAction(CmsListColumnDefinition column) {
        super(column);
    }

    @Override
    public String barHtml(CmsWorkplace wp) {
        if (wp == null) {
            wp = this.getWp();
        }
        StringBuffer html = new StringBuffer(1024);
        html.append("\t\t<input type='hidden' name='");
        html.append("listSearchFilter");
        html.append("' id='");
        html.append("listSearchFilter");
        html.append("' value='");
        String searchFilter = "";
        if (wp instanceof A_CmsListDialog) {
            searchFilter = ((A_CmsListDialog)wp).getList().getSearchFilter();
        }
        Map<String, String> colVals = CmsStringUtil.splitAsMap(searchFilter, PARAM_DELIM, KEY_VAL_DELIM);
        html.append(CmsStringUtil.escapeJavaScript(CmsEncoder.escapeXml(searchFilter)));
        html.append("' >\n");
        for (CmsListColumnDefinition colDef : this.getColumns()) {
            html.append("\t\t<input type='text' name='");
            html.append(SEARCH_COL_INPUT_ID).append(colDef.getId());
            html.append("' id='");
            html.append(SEARCH_COL_INPUT_ID).append(colDef.getId());
            html.append("' value='");
            String val = colVals.get(colDef.getId());
            if (val == null) {
                val = "";
            }
            html.append(CmsStringUtil.escapeJavaScript(CmsEncoder.escapeXml(val)));
            html.append("' title='");
            html.append(CmsStringUtil.escapeJavaScript(colDef.getName().key(wp.getLocale())));
            html.append("' size='20' maxlength='245' style='vertical-align: bottom;' >\n");
        }
        html.append(this.buttonHtml(wp));
        if (this.getShowAllAction() != null) {
            html.append("&nbsp;&nbsp;");
            html.append(this.getShowAllAction().buttonHtml());
        }
        html.append("<script type=\"text/javascript\">\n");
        html.append("var LIST_SEARCH_DATA = {\n");
        html.append("SEARCH_BAR_INPUT_ID: \"").append("listSearchFilter").append("\",\n");
        html.append("FORM: \"").append(this.getListId() + "-form").append("\",\n");
        html.append("COLUMNS: [");
        Iterator<CmsListColumnDefinition> it = this.getColumns().iterator();
        while (it.hasNext()) {
            CmsListColumnDefinition colDef;
            colDef = it.next();
            html.append("\"").append(colDef.getId()).append("\"");
            if (!it.hasNext()) continue;
            html.append(", ");
        }
        html.append("]\n");
        html.append("};\n");
        html.append("</script>\n");
        return html.toString();
    }

    public List filter(List items, String searchFilter) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(searchFilter)) {
            return items;
        }
        Map<String, String> colVals = CmsStringUtil.splitAsMap(searchFilter, PARAM_DELIM, KEY_VAL_DELIM);
        ArrayList<CmsListItem> res = new ArrayList<CmsListItem>();
        for (CmsListItem item : items) {
            if (res.contains(item)) continue;
            boolean matched = true;
            Iterator<CmsListColumnDefinition> itCols = this.getColumns().iterator();
            while (matched && itCols.hasNext()) {
                CmsListColumnDefinition col = itCols.next();
                if (item.get(col.getId()) == null) {
                    matched = false;
                    continue;
                }
                String colFilter = colVals.get(col.getId());
                if (colFilter == null || item.get(col.getId()).toString().indexOf(colFilter) >= 0) continue;
                matched = false;
            }
            if (!matched) continue;
            res.add(item);
        }
        return res;
    }
}

