/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.Messages;

public class CmsListItem {
    private final String m_id;
    private final CmsListMetadata m_metadata;
    private final Map<String, Object> m_values = new HashMap<String, Object>();

    public CmsListItem(CmsListMetadata metadata, String id) {
        if (id == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_INVALID_NULL_ARG_1", "id"));
        }
        if (metadata == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_INVALID_NULL_ARG_1", "metadata"));
        }
        this.m_metadata = metadata;
        this.m_id = id;
    }

    public Object get(String columnId) throws CmsIllegalArgumentException {
        if (this.getMetadata().getColumnDefinition(columnId) == null && this.getMetadata().getItemDetailDefinition(columnId) == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_INVALID_COLUMN_1", columnId));
        }
        return this.m_values.get(columnId);
    }

    public String getId() {
        return this.m_id;
    }

    public CmsListMetadata getMetadata() {
        return this.m_metadata;
    }

    public Map<String, Object> getValues() {
        return Collections.unmodifiableMap(this.m_values);
    }

    public Object set(String columnId, Object value) throws CmsIllegalArgumentException {
        if (this.getMetadata().getColumnDefinition(columnId) == null && this.getMetadata().getItemDetailDefinition(columnId) == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_INVALID_COLUMN_1", columnId));
        }
        return this.m_values.put(columnId, value);
    }

    public String toString() {
        return this.m_id + ":" + this.m_values.toString();
    }
}

