/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.list.CmsHtmlList;
import org.opencms.workplace.list.I_CmsListResourceCollector;
import org.opencms.workplace.list.Messages;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsExplorerDialog;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;
import org.opencms.workplace.tools.CmsTool;
import org.opencms.workplace.tools.CmsToolMacroResolver;
import org.opencms.workplace.tools.CmsToolManager;

public class CmsListExplorerFrameset
extends CmsExplorerDialog {
    public static final String PARAM_PAGE = "explorer_page";
    public static final String PARAM_TITLE_URI = "title_uri";
    private static final Log LOG = CmsLog.getLog(CmsListExplorerFrameset.class);

    public CmsListExplorerFrameset(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsListExplorerFrameset(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String defaultActionHtml() {
        String params = this.allParamsAsRequest();
        String titleUri = this.getJsp().getRequest().getParameter(PARAM_TITLE_URI);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(titleUri)) {
            titleUri = "/system/workplace/views/admin/list-title.jsp";
        }
        String titleSrc = this.getFrameSource("tool_title", this.getJsp().link(titleUri + "?" + params));
        String contentSrc = this.getFrameSource("tool_content", this.getJsp().link("/system/workplace/views/admin/list-explorer.jsp") + "?" + params);
        StringBuffer html = new StringBuffer(1024);
        html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">\n");
        html.append("<html>\n");
        html.append("\t<head>\n");
        html.append("\t\t<meta HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=\"").append(this.getEncoding()).append("\">\n");
        String uplink = "/opencms_a/opencms/system/workplace/views/admin/admin-main.jsp?path=/projects/files&action=initial&projectid=fa9f561f-be30-11e2-bac3-21ebf444feef&showexplorer=true";
        html.append("<script type='text/javascript'>var uplink = \"" + CmsStringUtil.escapeJavaScript(uplink) + "\";</script>\n");
        html.append("\t\t<title>\n");
        html.append("\t\t\t").append(this.key("GUI_LABEL_WPTITLE_1", new Object[]{this.getSettings().getUser().getFullName()})).append("\n");
        html.append("\t\t</title>\n");
        html.append("\t</head>\n");
        html.append("\t<frameset rows='57,*' border='0' frameborder='0' framespacing='0'>\n");
        html.append("\t\t<frame ").append(titleSrc).append(" frameborder='0' border='0' noresize scrolling='no'>\n");
        html.append("\t\t<frame ").append(contentSrc).append(" frameborder='0' border='0' noresize scrolling='auto' framespacing='0' marginheight='2' marginwidth='2' >\n");
        html.append("\t</frameset>\n");
        html.append("</html>\n");
        return html.toString();
    }

    @Override
    public String dialogTitle() {
        StringBuffer html = new StringBuffer(512);
        String toolPath = this.getCurrentToolPath();
        String parentPath = this.getParentPath();
        String rootKey = this.getToolManager().getCurrentRoot(this).getKey();
        CmsTool parentTool = this.getToolManager().resolveAdminTool(rootKey, parentPath);
        String upLevelLink = CmsToolManager.linkForToolPath(this.getJsp(), parentPath, parentTool.getHandler().getParameters(this));
        String listLevelLink = CmsToolManager.linkForToolPath(this.getJsp(), toolPath, this.getToolManager().resolveAdminTool(rootKey, toolPath).getHandler().getParameters(this));
        listLevelLink = CmsRequestUtil.appendParameter(listLevelLink, "showexplorer", Boolean.FALSE.toString());
        String parentName = this.getToolManager().resolveAdminTool(rootKey, parentPath).getHandler().getName();
        html.append(this.getToolManager().generateNavBar(toolPath, this));
        int items = 0;
        try {
            items = this.getSettings().getCollector().getResults(this.getCms()).size();
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        int size = (int)Math.ceil((double)items / (double)this.getSettings().getUserSettings().getExplorerFileEntries());
        html.append("<div class='screenTitle'>\n");
        html.append("\t<table width='100%' cellspacing='0'>\n");
        html.append("\t\t<tr>\n");
        html.append("\t\t\t<td>\n");
        html.append(this.getAdminTool().getHandler().getName());
        html.append("\n\t\t\t</td>\n");
        html.append("\t\t\t<td class='uplevel'>\n");
        html.append("<form name='title-form' method='post' target='_parent' action='");
        html.append(this.getJsp().link("/system/workplace/commons/list-explorer.jsp")).append("'>\n");
        html.append(this.getFormContent());
        if (size > 1) {
            html.append("<select name='").append(PARAM_PAGE);
            html.append("' class='location' onchange='this.form.submit()'>\n");
            html.append(CmsHtmlList.htmlPageSelector(size, this.getSettings().getUserSettings().getExplorerFileEntries(), items, this.getSettings().getExplorerPage(), this.getLocale()));
            html.append("</select>\n");
        }
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        html.append(A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, "id-list-switch", messages.key("GUI_LIST_ACTION_LIST_SWITCH_NAME_0"), messages.key("GUI_LIST_ACTION_LIST_SWITCH_HELP_0"), true, "list/list.png", null, "openPage('" + listLevelLink + "');"));
        html.append("\n");
        if (!toolPath.equals(this.getParentPath())) {
            html.append(A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, "id-up-level", org.opencms.workplace.tools.Messages.get().getBundle(this.getLocale()).key("GUI_ADMIN_VIEW_UPLEVEL_0"), parentName, true, "admin/images/up.png", null, "openPage('" + upLevelLink + "');"));
        }
        html.append("</form>");
        html.append("\n\t\t\t</td>\n");
        html.append("\t\t</tr>\n");
        html.append("\t</table>\n");
        html.append("</div>\n");
        String code = html.toString().replaceAll("openPage\\('([^']+)'\\)", "openPageIn('$1', parent)");
        return CmsToolMacroResolver.resolveMacros(code, this);
    }

    public void displayDialog() throws IOException, ServletException {
        this.getSettings().setExplorerMode("listview");
        HashMap<String, String[]> addParams = new HashMap<String, String[]>();
        HttpServletRequest req = this.getJsp().getRequest();
        String addParamsVal = req.getParameter("ctxmenuparams");
        if (addParamsVal != null) {
            addParams.put("ctxmenuparams", new String[]{addParamsVal});
        }
        this.getToolManager().jspForwardPage(this, "/system/workplace/views/explorer/explorer_files.jsp", addParams);
    }

    public void displayFrameSet() throws IOException {
        if (this.getJsp().getRequest().getParameter(PARAM_PAGE) != null) {
            int page = Integer.parseInt(this.getJsp().getRequest().getParameter(PARAM_PAGE));
            this.getSettings().setExplorerPage(page);
            if (this.getSettings().getCollector() instanceof I_CmsListResourceCollector) {
                I_CmsListResourceCollector collector = (I_CmsListResourceCollector)this.getSettings().getCollector();
                collector.setPage(page);
            }
        }
        JspWriter out = this.getJsp().getJspContext().getOut();
        out.print(this.defaultActionHtml());
    }

    public String paramsAsHidden(Collection excludes) {
        StringBuffer result = new StringBuffer(512);
        HashMap params = new HashMap(this.getJsp().getRequest().getParameterMap());
        params.remove(PARAM_PAGE);
        for (Map.Entry entry : params.entrySet()) {
            String param = (String)entry.getKey();
            if (excludes != null && excludes.contains(param)) continue;
            String[] value = (String[])entry.getValue();
            for (int i = 0; i < value.length; ++i) {
                result.append("<input type=\"hidden\" name=\"");
                result.append(param);
                result.append("\" value=\"");
                result.append(value[i]);
                result.append("\">\n");
            }
        }
        return result.toString();
    }

    protected String getFormContent() {
        return this.paramsAsHidden(Collections.singleton(PARAM_PAGE));
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamStyle("new");
        super.initWorkplaceRequestValues(settings, request);
    }
}

