/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.Messages;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;

public abstract class A_CmsListAction
extends A_CmsHtmlIconButton
implements I_CmsListAction {
    private CmsMessageContainer m_confirmationMsg;
    private String m_listId;
    private A_CmsListDialog m_wp;

    public A_CmsListAction(String id) {
        super(id);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(id)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_INVALID_NULL_ARG_1", "id"));
        }
        this.setConfirmationMessage(null);
    }

    public static String defaultConfirmationHtml(String confId, String confText) {
        StringBuffer html = new StringBuffer(1024);
        html.append("<div class='hide' id='conf");
        html.append(confId);
        html.append("'>");
        html.append(CmsStringUtil.isEmptyOrWhitespaceOnly(confText) ? "null" : confText);
        html.append("</div>\n");
        return html.toString();
    }

    @Override
    public String buttonHtml() {
        return this.buttonHtml(this.getWp());
    }

    @Override
    public CmsMessageContainer getConfirmationMessage() {
        return this.m_confirmationMsg;
    }

    @Override
    public String getListId() {
        return this.m_listId;
    }

    @Override
    public A_CmsListDialog getWp() {
        return this.m_wp;
    }

    @Override
    public void setConfirmationMessage(CmsMessageContainer confirmationMsg) {
        if (confirmationMsg == null) {
            confirmationMsg = EMPTY_MESSAGE;
        }
        this.m_confirmationMsg = confirmationMsg;
    }

    @Override
    public void setListId(String listId) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(listId)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LIST_INVALID_NULL_ARG_1", "listId"));
        }
        this.m_listId = listId;
    }

    @Override
    public void setWp(A_CmsListDialog wp) {
        this.m_wp = wp;
    }
}

