/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.galleries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeFolderExtended;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.galleries.Messages;

public abstract class A_CmsAjaxGallery
extends CmsDialog {
    public static final String DIALOG_CHANGEITEMLINKURL = "changeitemlinkurl";
    public static final String DIALOG_CHANGEITEMTITLE = "changeitemtitle";
    public static final String DIALOG_GETACTIVEITEM = "getactiveitem";
    public static final String DIALOG_GETCATEGORIES = "getcategories";
    public static final String DIALOG_GETGALLERIES = "getgalleries";
    public static final String DIALOG_GETGALLERY = "getgallery";
    public static final String DIALOG_GETITEMS = "getitems";
    public static final String DIALOG_LIST = "list";
    public static final String LISTMODE_CATEGORY = "category";
    public static final String LISTMODE_GALLERY = "gallery";
    public static final String MODE_EDITOR = "editor";
    public static final String MODE_VIEW = "view";
    public static final String MODE_WIDGET = "widget";
    public static final String PARAM_DIALOGMODE = "dialogmode";
    public static final String PARAM_EDITEDRESOURCE = "editedresource";
    public static final String PARAM_FIELDID = "fieldid";
    public static final String PARAM_GALLERYPATH = "gallerypath";
    public static final String PARAM_ITEMPATH = "itempath";
    public static final String PARAM_PARAMS = "params";
    public static final String PARAM_STARTUPFOLDER = "startupfolder";
    public static final String PARAM_STARTUPTYPE = "startuptype";
    public static final String PATH_GALLERIES = "/system/workplace/galleries/";
    public static final String RETURNVALUE_NONE = "none";
    private static final Log LOG = CmsLog.getLog(A_CmsAjaxGallery.class);
    protected String m_galleryTypeParams;
    private List<CmsResource> m_galleryItems;
    private String m_paramDialogMode;
    private String m_paramFieldId;
    private String m_paramGalleryPath;
    private String m_paramListMode;
    private String m_paramPropertyValue;
    private CmsResourceTypeFolderExtended m_resourceType;

    public A_CmsAjaxGallery() {
        this(null);
    }

    public A_CmsAjaxGallery(CmsJspActionElement jsp) {
        super(jsp);
        this.init();
    }

    public A_CmsAjaxGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static A_CmsAjaxGallery createInstance(String galleryTypeName, CmsJspActionElement jsp) {
        A_CmsAjaxGallery template;
        HttpSession session;
        CmsWorkplaceSettings settings;
        if (jsp != null && (settings = (CmsWorkplaceSettings)(session = jsp.getRequest().getSession()).getAttribute("__CmsWorkplace.WORKPLACE_SETTINGS")) != null) {
            if (CmsStringUtil.isEmpty(galleryTypeName)) {
                galleryTypeName = settings.getGalleryType();
            } else {
                settings.setGalleryType(galleryTypeName);
            }
        }
        if ((template = OpenCms.getWorkplaceManager().getGalleries().get(galleryTypeName)) == null) {
            CmsMessageContainer message = jsp == null ? Messages.get().container("LOG_UNKNOWN_GALLERY_TYPE_REQ_1", galleryTypeName) : Messages.get().container("LOG_UNKNOWN_GALLERY_TYPE_REQ_JSP_2", galleryTypeName, jsp.info("opencms.request.element.uri"));
            LOG.error((Object)message.key());
            throw new CmsRuntimeException(message);
        }
        try {
            Class<?> galleryClass = Class.forName(template.getResourceType().getFolderClassName());
            A_CmsAjaxGallery galleryInstance = (A_CmsAjaxGallery)galleryClass.newInstance();
            galleryInstance.m_resourceType = template.getResourceType();
            galleryInstance.m_galleryTypeParams = template.getResourceType().getFolderClassParams();
            galleryInstance.initWorkplaceMembers(jsp);
            galleryInstance.init();
            return galleryInstance;
        }
        catch (Exception e) {
            CmsMessageContainer message = jsp == null ? Messages.get().container("LOG_CREATE_GALLERY_INSTANCE_FAILED_2", template.getResourceType().getFolderClassName(), galleryTypeName) : Messages.get().container("LOG_CREATE_GALLERY_INSTANCE_FAILED_JSP_3", template.getResourceType().getFolderClassName(), galleryTypeName, jsp.info("opencms.request.element.uri"));
            LOG.error((Object)message.key());
            throw new CmsRuntimeException(message);
        }
    }

    public static List<CmsResource> getGalleries(int galleryTypeId, CmsObject cms) {
        ArrayList<CmsResource> galleries = new ArrayList();
        try {
            galleries = cms.readResources("/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (!cms.getRequestContext().getSiteRoot().equals("")) {
            List<CmsResource> systemGalleries = null;
            try {
                systemGalleries = cms.readResources("/system/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (systemGalleries != null && systemGalleries.size() > 0) {
                galleries.addAll(systemGalleries);
            }
        }
        return galleries;
    }

    public static void initGallery(CmsDialog wp) {
        String galleryTypeName = null;
        galleryTypeName = wp.useNewStyle() ? CmsResource.getName(CmsResource.getFolderPath(wp.getAdminTool().getHandler().getLink())) : CmsResource.getName(CmsResource.getFolderPath(wp.getJsp().getRequestContext().getUri()));
        if (galleryTypeName.endsWith("/")) {
            galleryTypeName = galleryTypeName.substring(0, galleryTypeName.length() - 1);
        }
        if (!galleryTypeName.equals("commons")) {
            wp.getSettings().setGalleryType(galleryTypeName);
        }
    }

    public void displayDialog() {
        if (DIALOG_CHANGEITEMTITLE.equals(this.getParamAction())) {
            this.changeItemTitle(this.getJsp().getRequest().getParameter(PARAM_ITEMPATH));
        } else if (DIALOG_CHANGEITEMLINKURL.equals(this.getParamAction())) {
            this.changeItemLinkUrl(this.getJsp().getRequest().getParameter(PARAM_ITEMPATH));
        } else if (DIALOG_GETCATEGORIES.equals(this.getParamAction())) {
            this.buildJsonCategoryList();
        } else if (DIALOG_GETGALLERIES.equals(this.getParamAction())) {
            this.buildJsonGalleryList();
        } else if (DIALOG_GETGALLERY.equals(this.getParamAction())) {
            this.buildJsonGalleryItem(this.getJsp().getRequest().getParameter(PARAM_GALLERYPATH));
        } else if (DIALOG_GETITEMS.equals(this.getParamAction())) {
            if (LISTMODE_CATEGORY.equals(this.getParamListMode())) {
                this.buildJsonResourceItems(this.getCategoryItems(), null);
            } else {
                this.buildJsonResourceItems(this.getGalleryItems(), this.getParamGalleryPath());
            }
        } else if (DIALOG_GETACTIVEITEM.equals(this.getParamAction())) {
            this.buildJsonActiveItem(this.getJsp().getRequest().getParameter(PARAM_ITEMPATH));
        }
    }

    public List<CmsResource> getGalleries() {
        return A_CmsAjaxGallery.getGalleries(this.getGalleryTypeId(), this.getCms());
    }

    public List<CmsResource> getGalleryItems() {
        if (this.m_galleryItems == null) {
            int resTypeId = this.getGalleryItemsTypeId();
            if (CmsStringUtil.isNotEmpty(this.getParamGalleryPath())) {
                try {
                    this.getSettings().setLastUsedGallery(this.getGalleryTypeId(), this.getParamGalleryPath());
                    CmsResourceFilter filter = resTypeId == -1 ? CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireTimerange().addRequireFile() : CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireTimerange().addRequireType(resTypeId);
                    this.m_galleryItems = this.getCms().readResources(this.getParamGalleryPath(), filter, false);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        return this.m_galleryItems;
    }

    public abstract int getGalleryItemsTypeId();

    public abstract int getGalleryTypeId();

    public abstract String getGalleryTypeName();

    public String getGalleryTypeParams() {
        return this.m_galleryTypeParams;
    }

    public String getParamDialogMode() {
        if (this.m_paramDialogMode == null) {
            return "";
        }
        return this.m_paramDialogMode;
    }

    public String getParamFieldId() {
        return this.m_paramFieldId;
    }

    public String getParamGalleryPath() {
        if (CmsStringUtil.isEmpty(this.m_paramGalleryPath)) {
            this.m_paramGalleryPath = "";
        }
        return this.m_paramGalleryPath;
    }

    public String getParamListMode() {
        return this.m_paramListMode;
    }

    public String getParamPropertyValue() {
        return this.m_paramPropertyValue;
    }

    public CmsResourceTypeFolderExtended getResourceType() {
        return this.m_resourceType;
    }

    public void init() {
    }

    public boolean isModeEditor() {
        return MODE_EDITOR.equals(this.getParamDialogMode());
    }

    public boolean isModeView() {
        return MODE_VIEW.equals(this.getParamDialogMode());
    }

    public boolean isModeWidget() {
        return MODE_WIDGET.equals(this.getParamDialogMode());
    }

    public void setParamDialogMode(String dialogMode) {
        this.m_paramDialogMode = dialogMode;
    }

    public void setParamFieldId(String fieldId) {
        this.m_paramFieldId = fieldId;
    }

    public void setParamGalleryPath(String galleryPath) {
        this.m_paramGalleryPath = galleryPath;
    }

    public void setParamListMode(String paramListMode) {
        this.m_paramListMode = paramListMode;
    }

    public void setParamPropertyValue(String paramPropertyValue) {
        this.m_paramPropertyValue = paramPropertyValue;
    }

    public void setResourceType(CmsResourceTypeFolderExtended type) {
        this.m_resourceType = type;
    }

    protected void buildJsonActiveItem(String itemUrl) {
        block8: {
            if (itemUrl.startsWith(OpenCms.getSiteManager().getWorkplaceServer())) {
                itemUrl = itemUrl.substring(OpenCms.getSiteManager().getWorkplaceServer().length());
            }
            if (itemUrl.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                itemUrl = itemUrl.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
            }
            try {
                JspWriter out = this.getJsp().getJspContext().getOut();
                if (this.getCms().existsResource(itemUrl)) {
                    try {
                        out.print((Object)this.buildJsonItemObject(this.getCms().readResource(itemUrl)));
                    }
                    catch (CmsException cmsException) {}
                } else {
                    out.print(RETURNVALUE_NONE);
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected void buildJsonCategoryList() {
        block9: {
            CmsCategoryService catService = CmsCategoryService.getInstance();
            List<Object> foundCategories = Collections.emptyList();
            String editedResource = null;
            if (CmsStringUtil.isNotEmpty(this.getParamResource())) {
                editedResource = this.getParamResource();
            }
            try {
                foundCategories = catService.readCategories(this.getCms(), "", true, editedResource);
            }
            catch (CmsException e) {
                // empty catch block
            }
            TreeMap<String, CmsCategory> sorted = new TreeMap<String, CmsCategory>();
            for (CmsCategory cmsCategory : foundCategories) {
                String string = cmsCategory.getPath();
                if (sorted.get(string) != null) continue;
                sorted.put(string, cmsCategory);
            }
            foundCategories = new ArrayList(sorted.values());
            JSONArray jSONArray = new JSONArray();
            for (CmsCategory cmsCategory : foundCategories) {
                JSONObject jsonObj = new JSONObject();
                try {
                    jsonObj.put("title", cmsCategory.getTitle());
                    jsonObj.put("path", cmsCategory.getPath());
                    jsonObj.put("rootpath", cmsCategory.getRootPath());
                    jsonObj.put("level", CmsResource.getPathLevel(cmsCategory.getPath()));
                    jsonObj.put("active", false);
                    jSONArray.put(jsonObj);
                }
                catch (JSONException e) {}
            }
            JspWriter jspWriter = this.getJsp().getJspContext().getOut();
            try {
                jspWriter.print(jSONArray.toString());
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected void buildJsonGalleryItem(String galleryUrl) {
        block9: {
            try {
                JspWriter out = this.getJsp().getJspContext().getOut();
                if (this.getCms().existsResource(galleryUrl)) {
                    JSONObject jsonObj = new JSONObject();
                    try {
                        CmsResource res = this.getCms().readResource(galleryUrl);
                        String path = this.getCms().getSitePath(res);
                        String title = this.getCms().readPropertyObject(res, "Title", false).getValue("");
                        try {
                            jsonObj.put("title", title);
                            jsonObj.put("path", path);
                            jsonObj.put("active", true);
                            out.print((Object)jsonObj);
                            break block9;
                        }
                        catch (JSONException e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                            break block9;
                        }
                    }
                    catch (CmsException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                        break block9;
                    }
                }
                out.print(RETURNVALUE_NONE);
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected void buildJsonGalleryList() {
        block13: {
            String startGallerySetting;
            String lastUsed = this.getSettings().getLastUsedGallery(this.getGalleryTypeId());
            if (CmsStringUtil.isEmpty(lastUsed) && (startGallerySetting = this.getSettings().getUserSettings().getStartGallery(this.getGalleryTypeName(), this.getCms())) != null) {
                String preselectedValue;
                if (startGallerySetting.equals("default") && (preselectedValue = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartGallery(this.getGalleryTypeName())) != null) {
                    startGallerySetting = preselectedValue;
                }
                String sitePath = this.getCms().getRequestContext().removeSiteRoot(startGallerySetting);
                if (this.getCms().existsResource(sitePath)) {
                    lastUsed = sitePath;
                }
            }
            JSONArray galleries = new JSONArray();
            Iterator<CmsResource> i = this.getGalleries().iterator();
            boolean isFirst = true;
            while (i.hasNext()) {
                block12: {
                    String title;
                    JSONObject jsonObj;
                    String path;
                    block11: {
                        CmsResource res = i.next();
                        path = this.getCms().getSitePath(res);
                        jsonObj = new JSONObject();
                        title = "";
                        try {
                            title = this.getCms().readPropertyObject(path, "Title", false).getValue("");
                        }
                        catch (CmsException e) {
                            if (!LOG.isErrorEnabled()) break block11;
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    try {
                        jsonObj.put("title", title);
                        jsonObj.put("path", path);
                        boolean active = false;
                        if (CmsStringUtil.isEmpty(lastUsed) && isFirst || path.equals(lastUsed)) {
                            active = true;
                        }
                        jsonObj.put("active", active);
                        galleries.put(jsonObj);
                    }
                    catch (JSONException e) {
                        if (!LOG.isErrorEnabled()) break block12;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                isFirst = false;
            }
            JspWriter out = this.getJsp().getJspContext().getOut();
            try {
                out.print(galleries.toString());
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block13;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected void buildJsonItemCommonPart(JSONObject jsonObj, CmsResource res, String sitePath) {
        block14: {
            try {
                boolean directPublishPermission;
                boolean writePermission;
                boolean editable;
                block13: {
                    jsonObj.put("sitepath", sitePath);
                    jsonObj.put("linkpath", this.getJsp().link(sitePath));
                    jsonObj.put("title", CmsStringUtil.escapeJavaScript(this.getJsp().property("Title", sitePath, res.getName())));
                    jsonObj.put("size", res.getLength() / 1024 + " " + this.key("GUI_LABEL_KILOBYTES_0"));
                    jsonObj.put("datecreated", this.getMessages().getDateTime(res.getDateCreated()));
                    jsonObj.put("datelastmodified", this.getMessages().getDateTime(res.getDateLastModified()));
                    CmsResourceState state = res.getState();
                    CmsLock lock = CmsLock.getNullLock();
                    try {
                        lock = this.getCms().getLock(res);
                    }
                    catch (CmsException e) {
                        // empty catch block
                    }
                    if (!lock.isNullLock() && lock.getType().isPublish()) {
                        state = CmsResourceState.STATE_UNCHANGED;
                    }
                    jsonObj.put("state", state);
                    String locked = "";
                    if (!(lock.isNullLock() || lock.getType().isPublish() || lock.getUserId().equals(this.getCms().getRequestContext().getCurrentUser().getId()))) {
                        try {
                            locked = this.getCms().readUser(lock.getUserId()).getName();
                        }
                        catch (CmsException e) {
                            locked = lock.getUserId().toString();
                        }
                    }
                    jsonObj.put("lockedby", locked);
                    editable = false;
                    writePermission = false;
                    directPublishPermission = false;
                    try {
                        if (!this.getCms().getRequestContext().getCurrentProject().isOnlineProject() && lock.isLockableBy(this.getCms().getRequestContext().getCurrentUser())) {
                            editable = true;
                            if (this.getCms().hasPermissions(res, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL)) {
                                writePermission = true;
                            }
                            if (this.getCms().hasPermissions(res, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL)) {
                                directPublishPermission = true;
                            }
                        }
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block13;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                jsonObj.put("editable", editable);
                jsonObj.put("writepermission", writePermission);
                jsonObj.put("directpublish", directPublishPermission);
                String desc = this.getJsp().property("Description", sitePath, "");
                jsonObj.put("description", CmsStringUtil.escapeJavaScript(desc));
            }
            catch (JSONException e) {
                if (!LOG.isErrorEnabled()) break block14;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected JSONObject buildJsonItemObject(CmsResource res) {
        JSONObject jsonObj = new JSONObject();
        String sitePath = this.getCms().getRequestContext().getSitePath(res);
        OpenCms.getSystemInfo().getOpenCmsContext();
        this.buildJsonItemCommonPart(jsonObj, res, sitePath);
        this.buildJsonItemSpecificPart(jsonObj, res, sitePath);
        return jsonObj;
    }

    protected abstract void buildJsonItemSpecificPart(JSONObject var1, CmsResource var2, String var3);

    protected void buildJsonResourceItems(List<CmsResource> resourceitems, String parentFolder) {
        block16: {
            if (resourceitems == null) {
                resourceitems = new ArrayList<CmsResource>();
            }
            boolean isPublishEnabled = false;
            boolean hasDirectPublish = false;
            boolean hasWritePermission = false;
            if (CmsStringUtil.isNotEmpty(parentFolder)) {
                try {
                    if (OpenCms.getPublishManager().getPublishList(this.getCms(), this.getCms().readResource(parentFolder), false).size() > 0) {
                        isPublishEnabled = true;
                    }
                }
                catch (CmsException e) {
                    // empty catch block
                }
                try {
                    if (this.getCms().hasPermissions(this.getCms().readResource(parentFolder), CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL)) {
                        hasDirectPublish = true;
                    }
                }
                catch (CmsException e) {
                    // empty catch block
                }
                try {
                    if (this.getCms().hasPermissions(this.getCms().readResource(parentFolder), CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL)) {
                        hasWritePermission = true;
                    }
                }
                catch (CmsException e) {
                    // empty catch block
                }
            }
            JSONObject publishInfo = new JSONObject();
            try {
                publishInfo.put("publishable", isPublishEnabled);
                publishInfo.put("directpublish", hasDirectPublish);
                publishInfo.put("writepermission", hasWritePermission);
            }
            catch (JSONException e) {
                // empty catch block
            }
            JSONArray items = new JSONArray();
            items.put(publishInfo);
            for (CmsResource res : resourceitems) {
                items.put(this.buildJsonItemObject(res));
            }
            JspWriter out = this.getJsp().getJspContext().getOut();
            try {
                out.print(items.toString());
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block16;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected void changeItemLinkUrl(String itemUrl) {
    }

    protected void changeItemTitle(String itemUrl) {
        block6: {
            try {
                JspWriter out = this.getJsp().getJspContext().getOut();
                if (this.getCms().existsResource(itemUrl)) {
                    try {
                        this.writeTitleProperty(this.getCms().readResource(itemUrl));
                        out.print((Object)this.buildJsonItemObject(this.getCms().readResource(itemUrl)));
                    }
                    catch (CmsException cmsException) {}
                } else {
                    out.print(RETURNVALUE_NONE);
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected List<CmsResource> getCategoryItems() {
        List<CmsResource> result;
        block8: {
            result = Collections.emptyList();
            if (CmsStringUtil.isNotEmpty(this.getParamGalleryPath())) {
                try {
                    CmsCategoryService service = CmsCategoryService.getInstance();
                    String editedResource = "/";
                    if (CmsStringUtil.isNotEmpty(this.getParamResource())) {
                        editedResource = CmsResource.getFolderPath(this.getParamResource());
                    }
                    result = service.readCategoryResources(this.getCms(), this.getParamGalleryPath(), true, editedResource);
                    int resTypeId = this.getGalleryItemsTypeId();
                    if (resTypeId != -1) {
                        ArrayList<CmsResource> unfiltered = new ArrayList<CmsResource>(result);
                        result = new ArrayList<CmsResource>(unfiltered.size());
                        for (CmsResource res : unfiltered) {
                            if (res.getTypeId() != resTypeId) continue;
                            result.add(res);
                        }
                    }
                }
                catch (CmsException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                catch (NullPointerException e) {
                    if (!LOG.isErrorEnabled()) break block8;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        String lastUsedGallery;
        this.fillParamValues(request);
        this.setParamDialogtype(LISTMODE_GALLERY);
        if (CmsStringUtil.isEmpty(this.getParamGalleryPath()) && CmsStringUtil.isNotEmpty(lastUsedGallery = this.getSettings().getLastUsedGallery(this.getGalleryTypeId()))) {
            try {
                this.getCms().readResource(lastUsedGallery, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                this.setParamGalleryPath(lastUsedGallery);
            }
            catch (CmsException e) {
                // empty catch block
            }
        }
    }

    protected void writeTitleProperty(CmsResource res) {
        String resPath = this.getCms().getSitePath(res);
        String currentPropertyValue = this.getParamPropertyValue();
        try {
            CmsProperty currentProperty = this.getCms().readPropertyObject(resPath, "Title", false);
            if (currentProperty.isNullProperty()) {
                currentProperty = new CmsProperty();
                currentProperty.setName("Title");
                if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                    currentProperty.setStructureValue(currentPropertyValue);
                    currentProperty.setResourceValue(null);
                } else {
                    currentProperty.setStructureValue(null);
                    currentProperty.setResourceValue(currentPropertyValue);
                }
            } else if (currentProperty.getStructureValue() != null) {
                currentProperty.setStructureValue(currentPropertyValue);
                currentProperty.setResourceValue(null);
            } else {
                currentProperty.setStructureValue(null);
                currentProperty.setResourceValue(currentPropertyValue);
            }
            CmsLock lock = this.getCms().getLock(res);
            if (lock.isUnlocked()) {
                this.getCms().lockResource(resPath);
            }
            this.getCms().writePropertyObject(resPath, currentProperty);
            this.getCms().unlockResource(resPath);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

