/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer.menu;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.explorer.menu.A_CmsMenuItemRule;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsMirMultiDirPublishStandard
extends A_CmsMenuItemRule {
    public static final String RULE_NAME = "multipubstandard";
    private static final Log LOG = CmsLog.getLog(CmsMirMultiDirPublishStandard.class);

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, CmsResourceUtil[] resourceUtil) {
        block4: {
            if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_ONLINEPROJECT_0");
            }
            try {
                CmsFolder parent = cms.readFolder(CmsResource.getParentFolder(cms.getSitePath(resourceUtil[0].getResource())));
                if (parent.getState().isNew()) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_PUBLISH_PARENTFOLDER_0");
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
    }

    @Override
    public boolean matches(CmsObject cms, CmsResourceUtil[] resourceUtil) {
        return true;
    }
}

