/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer.menu;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsPermissionSet;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.explorer.menu.A_CmsMenuItemRule;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;

public class CmsMirDirectPublish
extends A_CmsMenuItemRule {
    private static final Log LOG = CmsLog.getLog(CmsMirDirectPublish.class);

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, CmsResourceUtil[] resourceUtil) {
        CmsLock lock;
        block9: {
            if (!resourceUtil[0].isInsideProject()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_PUBLISH_OTHERPROJECT_0");
            }
            lock = resourceUtil[0].getLock();
            if (lock.isNullLock() || lock.isExclusiveOwnedInProjectBy(cms.getRequestContext().getCurrentUser(), cms.getRequestContext().getCurrentProject())) {
                try {
                    if (cms.hasPermissions(resourceUtil[0].getResource(), CmsPermissionSet.ACCESS_DIRECT_PUBLISH)) {
                        if (resourceUtil[0].getResource().isFolder() || !resourceUtil[0].getResource().getState().isUnchanged()) {
                            CmsFolder parent = cms.readFolder(CmsResource.getParentFolder(cms.getSitePath(resourceUtil[0].getResource())));
                            if (parent.getState().isNew()) {
                                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_PUBLISH_PARENTFOLDER_0");
                            }
                            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
                        }
                        if (!resourceUtil[0].getResource().isFolder() && resourceUtil[0].getResource().getState().isUnchanged()) {
                            return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_UNCHANGED_0");
                        }
                        break block9;
                    }
                    return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_PERM_PUBLISH_0");
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block9;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (lock.isInherited()) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_PUBLISH_INHERITED_0");
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey("GUI_CONTEXTMENU_TITLE_INACTIVE_PUBLISH_NOT_LOCKED_0");
    }

    @Override
    public boolean matches(CmsObject cms, CmsResourceUtil[] resourceUtil) {
        return true;
    }
}

