/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsExplorerContextMenu;
import org.opencms.workplace.explorer.CmsExplorerContextMenuItem;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.explorer.menu.A_CmsMenuItemRule;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;
import org.opencms.workplace.explorer.menu.CmsMenuRule;
import org.opencms.workplace.explorer.menu.CmsMenuRuleTranslator;
import org.opencms.workplace.explorer.menu.CmsMirMultiStandard;
import org.opencms.workplace.explorer.menu.I_CmsMenuItemRule;

public class CmsExplorerContextMenuBuilder
extends CmsWorkplace {
    private static final String HTML_SEPARATOR = "<li class=\"cmsep\"><span></span></li>";
    private String m_paramActtarget;
    private String m_paramResourcelist;

    public CmsExplorerContextMenuBuilder(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsExplorerContextMenuBuilder(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String contextMenu() {
        CmsExplorerContextMenu contextMenu;
        boolean isSingleSelection;
        List<String> resourceList = CmsStringUtil.splitAsList(this.getParamResourcelist(), "|");
        CmsResourceUtil[] resUtil = new CmsResourceUtil[resourceList.size()];
        for (int i = 0; i < resourceList.size(); ++i) {
            try {
                resUtil[i] = new CmsResourceUtil(this.getCms(), this.getCms().readResource(resourceList.get(i), CmsResourceFilter.ALL));
                continue;
            }
            catch (CmsException e) {
                return "";
            }
        }
        CmsExplorerTypeSettings settings = null;
        boolean bl = isSingleSelection = resourceList.size() == 1;
        if (isSingleSelection) {
            try {
                settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resUtil[0].getResourceTypeName());
            }
            catch (Throwable e) {
                return "";
            }
            if (settings == null || !settings.isEditable(this.getCms(), resUtil[0].getResource())) {
                return "";
            }
            contextMenu = settings.getContextMenu();
        } else {
            if (OpenCms.getWorkplaceManager().getMultiContextMenu() == null) {
                return "";
            }
            contextMenu = OpenCms.getWorkplaceManager().getMultiContextMenu();
        }
        CmsMenuRuleTranslator menuRuleTranslator = new CmsMenuRuleTranslator();
        HashMap<String, CmsMenuItemVisibilityMode> storedModes = new HashMap<String, CmsMenuItemVisibilityMode>();
        StringBuffer menu = new StringBuffer(4096);
        menu.append("<div id=\"menu\">");
        this.buildHtmlContextMenu(contextMenu.getAllEntries(), null, menu, resUtil, menuRuleTranslator, isSingleSelection, storedModes);
        menu.append("</div>");
        return menu.toString();
    }

    public String getParamActtarget() {
        return this.m_paramActtarget;
    }

    public String getParamResourcelist() {
        return this.m_paramResourcelist;
    }

    public void setParamActtarget(String paramActtarget) {
        this.m_paramActtarget = paramActtarget;
    }

    public void setParamResourcelist(String paramResourcelist) {
        this.m_paramResourcelist = paramResourcelist;
    }

    protected void buildHtmlContextMenu(List<CmsExplorerContextMenuItem> contextMenuEntries, CmsExplorerContextMenuItem parent, StringBuffer menu, CmsResourceUtil[] resUtil, CmsMenuRuleTranslator menuRuleTranslator, boolean isSingleSelection, Map<String, CmsMenuItemVisibilityMode> storedModes) {
        boolean insertSeparator = false;
        boolean firstEntryWritten = false;
        menu.append("\n<ul");
        if (parent != null) {
            menu.append(" id=\"");
            menu.append(parent.getKey().hashCode());
            menu.append("\"");
        }
        menu.append(">");
        for (CmsExplorerContextMenuItem item : contextMenuEntries) {
            StringBuffer parentIdsBuffer = new StringBuffer(64);
            CmsExplorerContextMenuItem pItem = item;
            boolean isFirst = true;
            while (pItem.isSubItem()) {
                if (isFirst) {
                    parentIdsBuffer.append("'");
                    isFirst = false;
                } else {
                    parentIdsBuffer.append(",");
                }
                parentIdsBuffer.append(pItem.getParent().getKey().hashCode());
                pItem = pItem.getParent();
            }
            if (!isFirst) {
                parentIdsBuffer.append("'");
            }
            String parentIds = parentIdsBuffer.toString();
            if (item.isParentItem()) {
                I_CmsMenuItemRule itemRule;
                CmsMenuRule rule;
                CmsMenuItemVisibilityMode mode = CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                String itemRuleName = item.getRule();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(itemRuleName) && (rule = OpenCms.getWorkplaceManager().getMenuRule(itemRuleName)) != null && (itemRule = rule.getMatchingRule(this.getCms(), resUtil)) != null) {
                    ArrayList<I_CmsMenuItemRule> itemRules = new ArrayList<I_CmsMenuItemRule>(item.getSubItems().size());
                    this.getSubItemRules(item, itemRules, resUtil);
                    I_CmsMenuItemRule[] itemRulesArray = new I_CmsMenuItemRule[itemRules.size()];
                    mode = itemRule.getVisibility(this.getCms(), resUtil, itemRules.toArray(itemRulesArray));
                }
                if (mode.isInVisible()) continue;
                if (insertSeparator) {
                    menu.append(HTML_SEPARATOR);
                    insertSeparator = false;
                }
                menu.append("\n<li><a class=\"x\" href=\"javascript:var ocm=1;\" onmouseover=\"window.status='';top.oSubC('");
                menu.append(item.getKey().hashCode());
                menu.append("'");
                if (CmsStringUtil.isNotEmpty(parentIds)) {
                    menu.append(",");
                    menu.append(parentIds);
                }
                menu.append(");return true;\">");
                menu.append(this.key(item.getKey()));
                menu.append("</a>");
                this.buildHtmlContextMenu(item.getSubItems(), item, menu, resUtil, menuRuleTranslator, isSingleSelection, storedModes);
                menu.append("</li>");
                firstEntryWritten = true;
                continue;
            }
            if ("entry".equals(item.getType())) {
                I_CmsMenuItemRule itemRule;
                CmsMenuRule rule;
                CmsMenuItemVisibilityMode mode;
                String itemName = this.key(item.getKey());
                CmsMenuRule customMenuRule = null;
                String itemRuleName = item.getRule();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(itemRuleName)) {
                    if (isSingleSelection) {
                        if (menuRuleTranslator.hasMenuRule(item.getRules())) {
                            itemRuleName = menuRuleTranslator.getMenuRuleName(item.getRules());
                            item.setRule(itemRuleName);
                        } else {
                            customMenuRule = menuRuleTranslator.createMenuRule(item.getRules());
                            itemRuleName = customMenuRule.getName();
                        }
                    } else {
                        itemRuleName = "multistandard";
                        if (!storedModes.containsKey(itemRuleName)) {
                            storedModes.put(itemRuleName, new CmsMirMultiStandard().getVisibility(this.getCms(), resUtil));
                        }
                    }
                }
                if ((mode = storedModes.get(itemRuleName)) == null && (rule = customMenuRule != null ? customMenuRule : OpenCms.getWorkplaceManager().getMenuRule(itemRuleName)) != null && (itemRule = rule.getMatchingRule(this.getCms(), resUtil)) != null) {
                    mode = itemRule instanceof A_CmsMenuItemRule ? ((A_CmsMenuItemRule)itemRule).getVisibility(this.getCms(), resUtil, item) : itemRule.getVisibility(this.getCms(), resUtil);
                    storedModes.put(item.getRule(), mode);
                }
                if (mode == null) continue;
                if (mode.isActive()) {
                    String itemTarget;
                    String itemLink = " ";
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(item.getUri())) {
                        itemLink = item.getUri().startsWith("/") ? this.getJsp().link(item.getUri()) : this.getJsp().link("/system/workplace/" + item.getUri());
                    }
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(itemTarget = item.getTarget())) {
                        itemTarget = "";
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamActtarget()) && item.getUri() != null && item.getUri().startsWith("views/admin/admin-main.jsp")) {
                            itemTarget = CmsEncoder.escapeXml(this.getParamActtarget());
                        }
                    }
                    if (insertSeparator) {
                        menu.append(HTML_SEPARATOR);
                        insertSeparator = false;
                    }
                    StringBuffer link = new StringBuffer(128);
                    if (isSingleSelection) {
                        link.append(" href=\"javascript:top.submitSingleAction('");
                        link.append(itemLink);
                        link.append("', '");
                        link.append(itemTarget);
                        link.append("');\"");
                    } else {
                        link.append(" href=\"javascript:top.submitMultiAction('");
                        link.append(itemLink);
                        link.append("');\"");
                    }
                    menu.append("\n<li><a ");
                    menu.append(link);
                    menu.append(" onmouseover=\"window.status='';top.cSubC(");
                    menu.append(parentIds);
                    menu.append(");return true;\"");
                    menu.append(">");
                    menu.append(itemName);
                    menu.append("</a></li>");
                    firstEntryWritten = true;
                    continue;
                }
                if (!mode.isInActive()) continue;
                if (insertSeparator) {
                    menu.append(HTML_SEPARATOR);
                    insertSeparator = false;
                }
                menu.append("\n<li>");
                menu.append("<a ");
                menu.append(" onmouseover=\"window.status='';top.cSubC(");
                menu.append(parentIds);
                menu.append(");return true;\"");
                if (CmsStringUtil.isNotEmpty(mode.getMessageKey())) {
                    menu.append(" title=\"");
                    menu.append(this.getMessages().key(CmsEncoder.escapeXml(mode.getMessageKey())));
                    menu.append("\"");
                }
                menu.append(" class=\"ina\" href=\"javascript:var ocm=1;\">").append(itemName).append("</a>");
                menu.append("</li>");
                firstEntryWritten = true;
                continue;
            }
            if (!firstEntryWritten) continue;
            insertSeparator = true;
        }
        menu.append("\n</ul>");
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
    }

    private void getSubItemRules(CmsExplorerContextMenuItem item, List<I_CmsMenuItemRule> itemRules, CmsResourceUtil[] resourceUtil) {
        for (CmsExplorerContextMenuItem subItem : item.getSubItems()) {
            I_CmsMenuItemRule rule;
            if (subItem.isParentItem()) {
                this.getSubItemRules(subItem, itemRules, resourceUtil);
                continue;
            }
            if (!"entry".equals(subItem.getType())) continue;
            String subItemRuleName = subItem.getRule();
            CmsMenuRule subItemRule = OpenCms.getWorkplaceManager().getMenuRule(subItemRuleName);
            if (subItemRule == null || (rule = subItemRule.getMatchingRule(this.getCms(), resourceUtil)) == null) continue;
            itemRules.add(rule);
        }
    }
}

