/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import java.util.Random;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.directedit.A_CmsDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.workplace.editors.directedit.CmsDirectEditResourceInfo;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsAdvancedDirectEditProvider
extends A_CmsDirectEditProvider {
    protected int m_lastPermissionMode;
    private Random m_random = new Random();
    protected boolean m_useIds;

    public String endDirectEditDisabled() {
        return "";
    }

    public String endDirectEditEnabled() {
        return "<div class=\"cms-editable-end\"></div>";
    }

    public synchronized String getRandomId() {
        return "editable_" + Math.abs(this.m_random.nextLong());
    }

    @Override
    public void insertDirectEditEnd(PageContext context) throws JspException {
        String content;
        switch (this.m_lastPermissionMode) {
            case 1: 
            case 2: {
                content = this.endDirectEditEnabled();
                break;
            }
            default: {
                content = null;
            }
        }
        this.m_lastPermissionMode = 0;
        this.print(context, content);
    }

    @Override
    public void insertDirectEditIncludes(PageContext context, CmsDirectEditParams params) throws JspException {
    }

    @Override
    public boolean insertDirectEditStart(PageContext context, CmsDirectEditParams params) throws JspException {
        String content;
        CmsDirectEditResourceInfo resourceInfo = this.getResourceInfo(params.getResourceName());
        this.m_lastPermissionMode = resourceInfo.getPermissions().getPermission();
        switch (this.m_lastPermissionMode) {
            case 1: 
            case 2: {
                try {
                    content = this.startDirectEditEnabled(params, resourceInfo);
                    break;
                }
                catch (JSONException e) {
                    throw new JspException((Throwable)e);
                }
            }
            default: {
                content = null;
            }
        }
        this.print(context, content);
        return content != null;
    }

    @Override
    public boolean isManual(CmsDirectEditMode mode) {
        return false;
    }

    @Override
    public I_CmsDirectEditProvider newInstance() {
        CmsAdvancedDirectEditProvider result = new CmsAdvancedDirectEditProvider();
        result.m_configurationParameters = this.m_configurationParameters;
        return result;
    }

    public String startDirectEditDisabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) {
        StringBuffer result = new StringBuffer(256);
        result.append("<!-- EDIT BLOCK START (DISABLED): ");
        result.append(params.m_resourceName);
        result.append(" [");
        result.append(resourceInfo.getResource().getState());
        result.append("] ");
        if (!resourceInfo.getLock().isUnlocked()) {
            result.append(" locked ");
            result.append(resourceInfo.getLock().getProject().getName());
        }
        result.append(" -->\n");
        return result.toString();
    }

    public String startDirectEditEnabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) throws JSONException {
        String editLocale = this.m_cms.getRequestContext().getLocale().toString();
        String editId = this.getNextDirectEditId();
        String editNewLink = CmsEncoder.encode(params.getLinkForNew());
        JSONObject editableData = new JSONObject();
        editableData.put("editId", editId);
        editableData.put("structureId", resourceInfo.getResource().getStructureId());
        editableData.put("sitePath", params.getResourceName());
        editableData.put("elementlanguage", editLocale);
        editableData.put("elementname", params.getElement());
        editableData.put("newlink", editNewLink);
        editableData.put("hasEdit", params.getButtonSelection().isShowEdit());
        editableData.put("hasDelete", params.getButtonSelection().isShowDelete());
        editableData.put("hasNew", params.getButtonSelection().isShowNew());
        editableData.put("newtitle", this.m_messages.key("GUI_EDITOR_TITLE_NEW_0"));
        if (this.m_lastPermissionMode == 1) {
            try {
                String noEditReason = new CmsResourceUtil(this.m_cms, resourceInfo.getResource()).getNoEditReason(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms), true);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(noEditReason)) {
                    editableData.put("noEditReason", noEditReason);
                }
            }
            catch (CmsException e) {
                e.printStackTrace();
            }
        }
        StringBuffer result = new StringBuffer(512);
        if (this.m_useIds) {
            result.append("<div id=\"" + this.getRandomId() + "\" class='cms-editable' rel='").append(editableData.toString()).append("'></div>");
        } else {
            result.append("<div class='cms-editable' rel='").append(editableData.toString()).append("'></div>");
        }
        return result.toString();
    }
}

