/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import java.io.IOException;
import java.util.Random;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessages;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.Messages;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditPermissions;
import org.opencms.workplace.editors.directedit.CmsDirectEditResourceInfo;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;

public abstract class A_CmsDirectEditProvider
implements I_CmsDirectEditProvider {
    protected static final String INCLUDE_FILE_DEFAULT = "/system/workplace/editors/direct_edit_include.txt";
    private static final Log LOG = CmsLog.getLog(A_CmsDirectEditProvider.class);
    protected CmsObject m_cms;
    protected CmsParameterConfiguration m_configurationParameters;
    protected int m_editButtonStyle;
    protected String m_fileName;
    protected CmsMessages m_messages;
    protected CmsDirectEditMode m_mode;
    protected Random m_rnd;

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        if (this.m_configurationParameters == null) {
            this.m_configurationParameters = new CmsParameterConfiguration();
        }
        this.m_configurationParameters.add(paramName, paramValue);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_configurationParameters;
    }

    public CmsDirectEditResourceInfo getResourceInfo(String resourceName) {
        block8: {
            try {
                boolean locked;
                if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                    return CmsDirectEditResourceInfo.INACTIVE;
                }
                if (CmsResource.isTemporaryFileName(resourceName)) {
                    return CmsDirectEditResourceInfo.INACTIVE;
                }
                if (!this.m_cms.isInsideCurrentProject(resourceName)) {
                    return CmsDirectEditResourceInfo.INACTIVE;
                }
                CmsResource resource = this.m_cms.readResource(resourceName, CmsResourceFilter.ALL);
                if (!OpenCms.getResourceManager().getResourceType(resource.getTypeId()).isDirectEditable()) {
                    return CmsDirectEditResourceInfo.INACTIVE;
                }
                CmsLock lock = this.m_cms.getLock(resource);
                boolean bl = locked = !lock.isUnlocked() && !lock.isOwnedInProjectBy(this.m_cms.getRequestContext().getCurrentUser(), this.m_cms.getRequestContext().getCurrentProject());
                if (this.m_cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION)) {
                    if (locked) {
                        return new CmsDirectEditResourceInfo(CmsDirectEditPermissions.DISABLED, resource, lock);
                    }
                    return new CmsDirectEditResourceInfo(CmsDirectEditPermissions.ENABLED, resource, lock);
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block8;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CALC_EDIT_MODE_FAILED_1", resourceName), (Throwable)e);
            }
        }
        return CmsDirectEditResourceInfo.INACTIVE;
    }

    @Override
    public void init(CmsObject cms, CmsDirectEditMode mode, String fileName) {
        this.m_cms = cms;
        this.m_fileName = fileName;
        if (CmsStringUtil.isEmpty(this.m_fileName)) {
            this.m_fileName = INCLUDE_FILE_DEFAULT;
        }
        this.m_mode = mode != null ? mode : CmsDirectEditMode.AUTO;
        this.m_rnd = new Random();
        CmsUserSettings settings = new CmsUserSettings(cms);
        this.m_messages = new CmsMessages(Messages.get().getBundleName(), settings.getLocale());
        this.m_editButtonStyle = settings.getEditorButtonStyle();
    }

    @Override
    public void initConfiguration() throws CmsConfigurationException {
        if (this.m_configurationParameters == null) {
            this.m_configurationParameters = new CmsParameterConfiguration();
        }
        this.m_configurationParameters = CmsParameterConfiguration.unmodifiableVersion(this.m_configurationParameters);
        if (this.m_configurationParameters == null) {
            throw new CmsConfigurationException(null);
        }
    }

    @Override
    public boolean isManual(CmsDirectEditMode mode) {
        return mode == CmsDirectEditMode.MANUAL || this.m_mode == CmsDirectEditMode.MANUAL && mode == CmsDirectEditMode.TRUE;
    }

    protected String getLink(String target) {
        return OpenCms.getLinkManager().substituteLink(this.m_cms, target);
    }

    protected String getNextDirectEditId() {
        return "ocms_".concat(String.valueOf(this.m_rnd.nextInt(1000000)));
    }

    protected void print(PageContext context, String content) throws JspException {
        if (content != null) {
            try {
                context.getOut().print(content);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
    }
}

