/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.HashMap;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.editors.A_CmsPreEditorActionDefinition;
import org.opencms.workplace.explorer.CmsNewResourceXmlContent;

public class CmsPreEditorActionDefinitionXmlContent
extends A_CmsPreEditorActionDefinition {
    @Override
    public boolean doPreAction(CmsResource resource, CmsDialog dialog, String originalParams) throws Exception {
        String newlink = dialog.getJsp().getRequest().getParameter("newlink");
        if (CmsStringUtil.isNotEmpty(newlink)) {
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
            String folderPath = dialog.getSettings().getExplorerResource();
            String resName = dialog.getJsp().getRequest().getParameter("resource");
            if (CmsStringUtil.isNotEmpty(resName)) {
                folderPath = CmsResource.getFolderPath(resName);
            }
            if (CmsNewResourceXmlContent.getModelFiles(dialog.getCms(), folderPath, type.getTypeName()).size() > 0) {
                HashMap<String, String[]> params = new HashMap<String, String[]>(4);
                params.put("originalparams", new String[]{originalParams});
                params.put("action", new String[]{"choosemodel"});
                params.put("title", new String[]{dialog.getJsp().getRequest().getParameter("editortitle")});
                params.put("newresourcetype", new String[]{type.getTypeName()});
                String paramBackLink = dialog.getJsp().getRequest().getParameter("backlink");
                if (CmsStringUtil.isNotEmpty(paramBackLink)) {
                    params.put("backlink", new String[]{paramBackLink});
                }
                if (CmsStringUtil.isNotEmpty(resName)) {
                    params.put("resource", new String[]{resName});
                }
                dialog.sendForward("/system/workplace/commons/newresource_xmlcontent_modelfile.jsp", params);
                return true;
            }
        }
        return false;
    }
}

