/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.commons.CmsPropertyCustom;
import org.opencms.workplace.editors.Messages;
import org.opencms.workplace.explorer.CmsNewResourceXmlPage;

public class CmsDialogProperty
extends CmsPropertyCustom {
    private static final Log LOG = CmsLog.getLog(CmsDialogProperty.class);
    private boolean m_templateChanged;

    public CmsDialogProperty(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDialogProperty(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public String buildEditForm() {
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        StringBuffer retValue = new StringBuffer(2048);
        boolean editable = this.isEditable();
        String disabled = "";
        if (!editable) {
            disabled = " disabled=\"disabled\"";
        }
        retValue.append("<table border=\"0\">\n");
        retValue.append("<tr>\n");
        retValue.append("\t<td class=\"textbold\">" + messages.key("GUI_INPUT_PROPERTY_0") + "</td>\n");
        retValue.append("\t<td class=\"textbold\">" + messages.key("GUI_LABEL_VALUE_0") + "</td>\n");
        retValue.append("\t<td class=\"textbold\" style=\"white-space: nowrap;\">" + messages.key("GUI_INPUT_USEDPROPERTY_0") + "</td>\n");
        retValue.append("</tr>\n");
        retValue.append("<tr><td><span style=\"height: 6px;\"></span></td></tr>\n");
        retValue.append(this.buildTableRowStart(messages.key("GUI_INPUT_TEMPLATE_0")));
        retValue.append(this.buildSelectTemplates("name=\"template\" class=\"maxwidth noborder\"" + disabled));
        retValue.append("</td>\n");
        retValue.append("\t<td class=\"textcenter\">");
        retValue.append("&nbsp;");
        retValue.append(this.buildTableRowEnd());
        retValue.append(this.buildTextInput(editable));
        if (this.showNavigation()) {
            retValue.append(this.buildNavigationProperties(editable));
        }
        retValue.append("</table>");
        return retValue.toString();
    }

    public String buildSelectTemplates(String attributes) {
        TreeMap<String, String> templates;
        String currentTemplate;
        int selectedValue;
        ArrayList<String> values;
        ArrayList<String> options;
        block8: {
            options = new ArrayList<String>();
            values = new ArrayList<String>();
            selectedValue = -1;
            currentTemplate = null;
            templates = null;
            try {
                currentTemplate = this.getCms().readPropertyObject(this.getParamResource(), "template", true).getValue();
                templates = CmsNewResourceXmlPage.getTemplates(this.getCms(), this.getParamResource());
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block8;
                LOG.info((Object)Messages.get().getBundle().key("LOG_READ_TEMPLATE_FAILED_0"), (Throwable)e);
            }
        }
        if (currentTemplate == null) {
            currentTemplate = "";
        }
        if (templates == null) {
            this.addCurrentTemplate(currentTemplate, options, values);
        } else {
            boolean found = false;
            Iterator i = templates.entrySet().iterator();
            int counter = 0;
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                String path = (String)entry.getValue();
                if (currentTemplate.equals(path)) {
                    selectedValue = counter;
                    found = true;
                }
                options.add(key);
                values.add(path);
                ++counter;
            }
            if (!found) {
                this.addCurrentTemplate(currentTemplate, options, values);
                selectedValue = 0;
            }
        }
        String hiddenField = "<input type=\"hidden\" name=\"valhiddentemplate\" value=\"" + currentTemplate + "\">";
        return CmsDialogProperty.buildSelect(attributes, options, values, selectedValue, false) + hiddenField;
    }

    public boolean hasTemplateChanged() {
        return this.m_templateChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean performEditOperation(HttpServletRequest request) throws CmsException {
        boolean useTempfileProject = Boolean.valueOf(this.getParamUsetempfileproject());
        try {
            if (useTempfileProject) {
                this.switchToTempProject();
            }
            for (String curProperty : this.getExplorerTypeSettings().getProperties()) {
                String paramValue = request.getParameter("valprop" + curProperty);
                String oldValue = request.getParameter("valhidden" + curProperty);
                this.writeProperty(curProperty, paramValue, oldValue);
            }
            String paramValue = null;
            String oldValue = null;
            if (this.showNavigation()) {
                paramValue = request.getParameter("enablenav");
                if (Boolean.valueOf(paramValue).booleanValue()) {
                    paramValue = request.getParameter("navpos");
                    if (!"-1".equals(paramValue)) {
                        oldValue = request.getParameter("valhiddenNavPos");
                        this.writeProperty("NavPos", paramValue, oldValue);
                    }
                    paramValue = request.getParameter("valpropNavText");
                    oldValue = request.getParameter("valhiddenNavText");
                    this.writeProperty("NavText", paramValue, oldValue);
                } else {
                    this.writeProperty("NavPos", null, null);
                    this.writeProperty("NavText", null, null);
                }
            }
            paramValue = request.getParameter("template");
            oldValue = request.getParameter("valhiddentemplate");
            this.writeProperty("template", paramValue, oldValue);
            if (paramValue != null && !paramValue.equals(oldValue)) {
                this.m_templateChanged = true;
            }
        }
        finally {
            if (useTempfileProject) {
                this.switchToCurrentProject();
            }
        }
        return true;
    }

    private void addCurrentTemplate(String currentTemplate, List<String> options, List<String> values) {
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        if (CmsStringUtil.isEmpty(currentTemplate)) {
            options.add(0, "--- " + messages.key("GUI_PLEASE_SELECT_0") + " ---");
            values.add(0, "");
        } else {
            String name;
            block5: {
                name = null;
                try {
                    name = this.getCms().readPropertyObject(currentTemplate, "Title", false).getValue();
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block5;
                    LOG.info((Object)messages.key("LOG_READ_TITLE_PROP_FAILED_1", currentTemplate), (Throwable)e);
                }
            }
            if (name == null) {
                name = currentTemplate;
            }
            options.add(0, "* " + name);
            values.add(0, currentTemplate);
        }
    }
}

