/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsDateUtil;
import org.opencms.workplace.comparison.CmsAttributeComparison;

public class CmsResourceComparison {
    public static final String TYPE_ADDED = "added";
    public static final String TYPE_CHANGED = "changed";
    public static final String TYPE_REMOVED = "removed";
    public static final String TYPE_UNCHANGED = "unchanged";
    private static final Log LOG = CmsLog.getLog(CmsResourceComparison.class);

    protected CmsResourceComparison() {
    }

    public static List compareAttributes(CmsObject cms, CmsResource resource1, CmsResource resource2) {
        ArrayList<CmsAttributeComparison> comparedAttributes = new ArrayList<CmsAttributeComparison>();
        comparedAttributes.add(new CmsAttributeComparison("GUI_HISTORY_COLS_SIZE_0", String.valueOf(resource1.getLength()), String.valueOf(resource2.getLength())));
        String release1 = 0L == resource1.getDateReleased() ? "-" : CmsDateUtil.getDateTime(new Date(resource1.getDateReleased()), 3, cms.getRequestContext().getLocale());
        String release2 = 0L == resource2.getDateReleased() ? "-" : CmsDateUtil.getDateTime(new Date(resource2.getDateReleased()), 3, cms.getRequestContext().getLocale());
        comparedAttributes.add(new CmsAttributeComparison("GUI_LABEL_DATE_RELEASED_0", release1, release2));
        String expire1 = Long.MAX_VALUE == resource1.getDateExpired() ? "-" : CmsDateUtil.getDateTime(new Date(resource1.getDateExpired()), 3, cms.getRequestContext().getLocale());
        String expire2 = Long.MAX_VALUE == resource2.getDateExpired() ? "-" : CmsDateUtil.getDateTime(new Date(resource2.getDateExpired()), 3, cms.getRequestContext().getLocale());
        comparedAttributes.add(new CmsAttributeComparison("GUI_LABEL_DATE_EXPIRED_0", expire1, expire2));
        comparedAttributes.add(new CmsAttributeComparison("GUI_PERMISSION_INTERNAL_0", String.valueOf(resource1.isInternal()), String.valueOf(resource2.isInternal())));
        String dateLastModified1 = CmsDateUtil.getDateTime(new Date(resource1.getDateLastModified()), 3, cms.getRequestContext().getLocale());
        String dateLastModified2 = CmsDateUtil.getDateTime(new Date(resource2.getDateLastModified()), 3, cms.getRequestContext().getLocale());
        comparedAttributes.add(new CmsAttributeComparison("GUI_LABEL_DATE_LAST_MODIFIED_0", dateLastModified1, dateLastModified2));
        try {
            String type1 = OpenCms.getResourceManager().getResourceType(resource1.getTypeId()).getTypeName();
            String type2 = OpenCms.getResourceManager().getResourceType(resource2.getTypeId()).getTypeName();
            comparedAttributes.add(new CmsAttributeComparison("GUI_HISTORY_COLS_FILE_TYPE_0", type1, type2));
        }
        catch (CmsLoaderException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        String dateCreated1 = CmsDateUtil.getDateTime(new Date(resource1.getDateCreated()), 3, cms.getRequestContext().getLocale());
        String dateCreated2 = CmsDateUtil.getDateTime(new Date(resource2.getDateCreated()), 3, cms.getRequestContext().getLocale());
        comparedAttributes.add(new CmsAttributeComparison("GUI_HISTORY_COLS_DATE_PUBLISHED_0", dateCreated1, dateCreated2));
        try {
            String userLastModified1 = resource1.getUserLastModified().toString();
            try {
                userLastModified1 = CmsPrincipal.readPrincipalIncludingHistory(cms, resource1.getUserLastModified()).getName();
            }
            catch (CmsDbEntryNotFoundException e) {
                // empty catch block
            }
            String userLastModified2 = resource2.getUserLastModified().toString();
            try {
                userLastModified2 = CmsPrincipal.readPrincipalIncludingHistory(cms, resource2.getUserLastModified()).getName();
            }
            catch (CmsDbEntryNotFoundException e) {
                // empty catch block
            }
            comparedAttributes.add(new CmsAttributeComparison("GUI_LABEL_USER_LAST_MODIFIED_0", userLastModified1, userLastModified2));
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        String path1 = cms.getRequestContext().removeSiteRoot(resource1.getRootPath());
        String path2 = cms.getRequestContext().removeSiteRoot(resource2.getRootPath());
        comparedAttributes.add(new CmsAttributeComparison("GUI_HISTORY_COLS_RESOURCE_PATH_0", path1, path2));
        return comparedAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List compareProperties(CmsObject cms, CmsResource resource1, String version1, CmsResource resource2, String version2) throws CmsException {
        List<CmsProperty> properties2;
        List<CmsProperty> properties1;
        if (resource1 instanceof I_CmsHistoryResource) {
            properties1 = cms.readHistoryPropertyObjects((I_CmsHistoryResource)((Object)resource1));
        } else if (Integer.parseInt(version1) < 0) {
            CmsProject prj = cms.getRequestContext().getCurrentProject();
            try {
                cms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                properties1 = cms.readPropertyObjects(resource1, false);
            }
            finally {
                cms.getRequestContext().setCurrentProject(prj);
            }
        } else {
            properties1 = cms.readPropertyObjects(resource1, false);
        }
        if (resource2 instanceof I_CmsHistoryResource) {
            properties2 = cms.readHistoryPropertyObjects((I_CmsHistoryResource)((Object)resource2));
        } else if (Integer.parseInt(version2) < 0) {
            CmsProject prj = cms.getRequestContext().getCurrentProject();
            try {
                cms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                properties2 = cms.readPropertyObjects(resource2, false);
            }
            finally {
                cms.getRequestContext().setCurrentProject(prj);
            }
        } else {
            properties2 = cms.readPropertyObjects(resource2, false);
        }
        ArrayList<CmsAttributeComparison> comparedProperties = new ArrayList<CmsAttributeComparison>();
        ArrayList<CmsProperty> removedProperties = new ArrayList<CmsProperty>(properties1);
        removedProperties.removeAll(properties2);
        ArrayList<CmsProperty> addedProperties = new ArrayList<CmsProperty>(properties2);
        addedProperties.removeAll(properties1);
        ArrayList<CmsProperty> retainedProperties = new ArrayList<CmsProperty>(properties2);
        retainedProperties.retainAll(properties1);
        for (CmsProperty prop : addedProperties) {
            comparedProperties.add(new CmsAttributeComparison(prop.getName(), "", prop.getValue(), TYPE_ADDED));
        }
        for (CmsProperty prop : removedProperties) {
            comparedProperties.add(new CmsAttributeComparison(prop.getName(), prop.getValue(), "", TYPE_REMOVED));
        }
        for (CmsProperty prop : retainedProperties) {
            String value2;
            String value1 = properties1.get(properties1.indexOf(prop)).getValue();
            if (value1.equals(value2 = properties2.get(properties2.indexOf(prop)).getValue())) {
                comparedProperties.add(new CmsAttributeComparison(prop.getName(), value1, value2, TYPE_UNCHANGED));
                continue;
            }
            comparedProperties.add(new CmsAttributeComparison(prop.getName(), value1, value2, TYPE_CHANGED));
        }
        return comparedProperties;
    }
}

