/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListResourceCollector;
import org.opencms.workplace.list.CmsListExplorerColumn;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListResourceCollector;

public class CmsShowSiblingsList
extends A_CmsListExplorerDialog {
    private static final String LIST_ID = "lshsib";
    private I_CmsListResourceCollector m_collector;

    public CmsShowSiblingsList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_SHOW_SIBLINGS_LIST_NAME_0"));
        CmsResourceUtil resUtil = this.getResourceUtil();
        resUtil.setAbbrevLength(50);
        resUtil.setRelativeTo(this.getCms().getRequestContext().addSiteRoot(jsp.getRequestContext().getFolderUri()));
        resUtil.setSiteMode(CmsResourceUtil.SITE_MODE_MATCHING);
    }

    @Override
    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    @Override
    public I_CmsListResourceCollector getCollector() {
        if (this.m_collector == null) {
            this.m_collector = new A_CmsListResourceCollector(this){
                private static final String COLLECTOR_NAME = "showSiblings";

                public List getCollectorNames() {
                    ArrayList<String> names = new ArrayList<String>();
                    names.add(COLLECTOR_NAME);
                    return names;
                }

                public List getResources(CmsObject cms, Map params) throws CmsException {
                    return CmsShowSiblingsList.this.getCms().readSiblings(((CmsShowSiblingsList)this.getWp()).getParamResource(), CmsResourceFilter.ALL);
                }

                @Override
                protected void setAdditionalColumns(CmsListItem item, CmsResourceUtil resUtil) {
                }
            };
        }
        return this.m_collector;
    }

    @Override
    protected String defaultActionHtmlStart() {
        return this.getList().listJs() + CmsListExplorerColumn.getExplorerStyleDef() + this.dialogContentStart(this.getParamTitle());
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        metadata.getColumnDefinition("ecn").setName(org.opencms.workplace.explorer.Messages.get().container("GUI_INPUT_PATH_0"));
    }

    @Override
    protected boolean isColumnVisible(int colFlag) {
        boolean isVisible = colFlag == 1;
        isVisible = isVisible || colFlag == "ecti".hashCode();
        isVisible = isVisible || colFlag == "ecli".hashCode();
        isVisible = isVisible || colFlag == "ecpi".hashCode();
        isVisible = isVisible || colFlag == "ecn".hashCode();
        isVisible = isVisible || colFlag == 2;
        isVisible = isVisible || colFlag == 8;
        isVisible = isVisible || colFlag == "ecsi".hashCode() && OpenCms.getSiteManager().getSites().size() > 1;
        return isVisible;
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }

    @Override
    protected void validateParamaters() throws Exception {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.getParamResource())) {
            throw new Exception();
        }
    }
}

