/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLockFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsHtmlReport;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.CmsLock;
import org.opencms.workplace.commons.CmsProgressThread;
import org.opencms.workplace.commons.CmsProgressWidget;
import org.opencms.workplace.commons.CmsPublishBrokenRelationsList;
import org.opencms.workplace.commons.CmsPublishResourcesList;
import org.opencms.workplace.commons.Messages;

public class CmsPublishProject
extends CmsMultiDialog {
    public static final int ACTION_PUBLISH = 110;
    public static final int ACTION_RESOURCES_CONFIRMED = 111;
    public static final String DIALOG_RESOURCES_CONFIRMED = "resourcesconfirmed";
    public static final String DIALOG_TYPE = "publishproject";
    public static final String PARAM_DIRECTPUBLISH = "directpublish";
    public static final String PARAM_PUBLISHSIBLINGS = "publishsiblings";
    public static final String PARAM_RELATEDRESOURCES = "relatedresources";
    public static final String PARAM_SUBRESOURCES = "subresources";
    private static final Log LOG = CmsLog.getLog(CmsPublishProject.class);
    private String m_paramDirectpublish;
    private String m_paramProgresskey;
    private String m_paramProjectid;
    private String m_paramProjectname;
    private String m_paramPublishsiblings;
    private String m_paramRelatedresources;
    private String m_paramSubresources;
    private CmsProgressWidget m_progress;

    public CmsPublishProject(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPublishProject(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionPublish() throws JspException {
        try {
            boolean isFolder = false;
            if (!this.isMultiOperation() && this.isDirectPublish()) {
                isFolder = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL).isFolder();
            }
            if (this.performDialogOperation()) {
                if (this.isMultiOperation() || isFolder) {
                    ArrayList<String> folderList = new ArrayList<String>();
                    folderList.add(CmsResource.getParentFolder(this.getResourceList().get(0)));
                    for (String res : this.getResourceList()) {
                        if (!CmsResource.isFolder(res)) continue;
                        folderList.add(res);
                    }
                    this.getJsp().getRequest().setAttribute("__CmsWorkplace.RELOADTREE", folderList);
                }
                this.actionCloseDialog();
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public String buildConfirmation() {
        StringBuffer result = new StringBuffer(512);
        result.append("<p><div id='conf-msg'>\n");
        if (!this.isDirectPublish()) {
            result.append(this.key("GUI_PUBLISH_PROJECT_CONFIRMATION_1", new Object[]{this.getProjectname()}));
        } else {
            boolean isFolder = false;
            if (!this.isMultiOperation()) {
                try {
                    isFolder = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL).isFolder();
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
            if (this.isMultiOperation() || isFolder || this.hasSiblings() && this.hasCorrectLockstate()) {
                result.append(this.key("GUI_PUBLISH_MULTI_CONFIRMATION_0"));
            } else {
                result.append(this.key("GUI_PUBLISH_CONFIRMATION_0"));
            }
        }
        result.append("\n</div></p>\n");
        return result.toString();
    }

    @Override
    public String buildLockConfirmationMessageJS() {
        StringBuffer html = new StringBuffer(512);
        html.append("<script type='text/javascript'><!--\n");
        html.append("function setConfirmationMessage(locks, blockinglocks) {\n");
        html.append("\tvar confMsg = document.getElementById('conf-msg');\n");
        html.append("\tif (locks > -1) {\n");
        html.append("\t\tdocument.getElementById('butClose').className = 'hide';\n");
        html.append("\t\tdocument.getElementById('butContinue').className = '';\n");
        html.append("\t\tif (locks > 0) {\n");
        html.append("\t\t\tshowAjaxReportContent();\n");
        html.append("\t\t\tconfMsg.innerHTML = '");
        html.append(this.key("GUI_PUBLISH_UNLOCK_CONFIRMATION_0"));
        html.append("';\n");
        html.append("\t\t} else {\n");
        html.append("\t\tshowAjaxOk();\n");
        html.append("\t\t\tconfMsg.innerHTML = '");
        html.append(this.key("GUI_PUBLISH_NO_LOCKS_CONFIRMATION_0"));
        html.append("';\n");
        html.append("\t\t}\n");
        html.append("\t} else {\n");
        html.append("\t\tdocument.getElementById('butClose').className = '';\n");
        html.append("\t\tdocument.getElementById('butContinue').className = 'hide';\n");
        html.append("\t\tconfMsg.innerHTML = '");
        html.append(this.key("GUI_AJAX_REPORT_WAIT_0"));
        html.append("';\n");
        html.append("\t}\n");
        html.append("}\n");
        html.append("// -->\n");
        html.append("</script>\n");
        return html.toString();
    }

    @Override
    public String buildLockDialog() throws CmsException {
        CmsLockFilter nonBlockingFilter = CmsLockFilter.FILTER_ALL;
        nonBlockingFilter = nonBlockingFilter.filterLockableByUser(this.getCms().getRequestContext().getCurrentUser());
        nonBlockingFilter = nonBlockingFilter.filterSharedExclusive();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamProjectid())) {
            nonBlockingFilter = nonBlockingFilter.filterProject(new CmsUUID(this.getParamProjectid()));
        }
        return this.buildLockDialog(nonBlockingFilter, this.getBlockingFilter(), 0, true);
    }

    @Override
    public String buildLockHeaderBox() throws CmsException {
        if (this.isDirectPublish()) {
            return super.buildLockHeaderBox();
        }
        StringBuffer html = new StringBuffer(512);
        html.append(this.dialogBlockStart(null));
        html.append(this.key("GUI_LABEL_PROJECT_0"));
        html.append(": ");
        html.append(this.getProjectname());
        html.append(this.dialogBlockEnd());
        return html.toString();
    }

    public String buildPublishOptions() {
        StringBuffer result = new StringBuffer(128);
        boolean showOptionSiblings = this.isMultiOperation() || this.isOperationOnFolder() || this.isDirectPublish() && this.hasSiblings() && this.hasCorrectLockstate();
        boolean showOptionSubresources = this.isMultiOperation() || this.isOperationOnFolder();
        result.append("<p>");
        if (showOptionSiblings) {
            if (!this.isMultiOperation() && !this.isOperationOnFolder()) {
                result.append(this.key("GUI_DELETE_WARNING_SIBLINGS_0"));
                result.append("<br>");
            }
            result.append("<input type='checkbox' name='");
            result.append(PARAM_PUBLISHSIBLINGS);
            result.append("' value='true' onclick=\"reloadReport();\"");
            if (Boolean.valueOf(this.getParamPublishsiblings()).booleanValue()) {
                result.append(" checked='checked'");
            }
            result.append(">&nbsp;");
            result.append(this.key("GUI_PUBLISH_ALLSIBLINGS_0"));
            result.append("<br>\n");
        } else {
            result.append("<input type='hidden' name='");
            result.append(PARAM_PUBLISHSIBLINGS);
            result.append("' value='");
            result.append(Boolean.valueOf(this.getParamPublishsiblings()));
            result.append("'");
            if (Boolean.valueOf(this.getParamPublishsiblings()).booleanValue()) {
                result.append(" checked='checked'");
            }
            result.append(">\n");
        }
        if (showOptionSubresources) {
            result.append("<input type='checkbox' name='");
            result.append(PARAM_SUBRESOURCES);
            result.append("' value='true' onclick=\"reloadReport();\"");
            if (Boolean.valueOf(this.getParamSubresources()).booleanValue()) {
                result.append(" checked='checked'");
            }
            result.append(">&nbsp;");
            if (this.isMultiOperation()) {
                result.append(this.key("GUI_PUBLISH_MULTI_SUBRESOURCES_0"));
            } else {
                result.append(this.key("GUI_PUBLISH_SUBRESOURCES_0"));
            }
            result.append("<br>\n");
        } else {
            result.append("<input type='hidden' name='");
            result.append(PARAM_SUBRESOURCES);
            result.append("' value='");
            result.append(Boolean.valueOf(this.getParamSubresources()));
            result.append("'");
            if (Boolean.valueOf(this.getParamSubresources()).booleanValue()) {
                result.append(" checked='checked'");
            }
            result.append(">\n");
        }
        boolean disabled = false;
        if (OpenCms.getWorkplaceManager().getDefaultUserSettings().getPublishRelatedResources() == CmsDefaultUserSettings.PUBLISH_RELATED_RESOURCES_MODE_FORCE && !OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.VFS_MANAGER)) {
            disabled = true;
        }
        result.append("<input type='checkbox' name='");
        result.append(PARAM_RELATEDRESOURCES);
        result.append("' value='true' onclick=\"reloadReport();\"");
        if (Boolean.valueOf(this.getParamRelatedresources()).booleanValue()) {
            result.append(" checked='checked'");
        }
        if (disabled) {
            result.append(" disabled='disabled'");
        }
        result.append(">&nbsp;");
        result.append(this.key("GUI_PUBLISH_RELATED_RESOURCES_0"));
        result.append("<br>\n");
        result.append("</p>\n");
        return result.toString();
    }

    public CmsPublishBrokenRelationsList getBrokenRelationsList() {
        return new CmsPublishBrokenRelationsList(this.getJsp(), this.getParentFolder());
    }

    public String getParamDirectpublish() {
        return this.m_paramDirectpublish;
    }

    @Override
    public String getParamFramename() {
        String fn = super.getParamFramename();
        if (fn == null && !this.isDirectPublish()) {
            fn = "body";
        }
        return fn;
    }

    public String getParamProgresskey() {
        return this.m_paramProgresskey;
    }

    public String getParamProjectid() {
        return this.m_paramProjectid;
    }

    public String getParamProjectname() {
        return this.m_paramProjectname;
    }

    public String getParamPublishsiblings() {
        return this.m_paramPublishsiblings;
    }

    public String getParamRelatedresources() {
        return this.m_paramRelatedresources;
    }

    public String getParamSubresources() {
        return this.m_paramSubresources;
    }

    public CmsProgressWidget getProgress() {
        return this.m_progress;
    }

    public CmsPublishList getPublishList() throws JspException {
        CmsPublishList publishList = null;
        if (this.isDirectPublish()) {
            ArrayList<CmsResource> publishResources = new ArrayList<CmsResource>(this.getResourceList().size());
            for (String resName : this.getResourceList()) {
                try {
                    publishResources.add(this.getCms().readResource(resName, CmsResourceFilter.ALL));
                }
                catch (CmsException e) {
                    this.addMultiOperationException(e);
                }
            }
            try {
                boolean publishSubResources = Boolean.valueOf(this.getParamSubresources());
                boolean publishSiblings = Boolean.valueOf(this.getParamPublishsiblings());
                publishList = OpenCms.getPublishManager().getPublishList(this.getCms(), publishResources, publishSiblings, publishSubResources);
            }
            catch (CmsException e) {
                this.addMultiOperationException(e);
            }
        } else {
            try {
                publishList = OpenCms.getPublishManager().getPublishList(this.getCms());
            }
            catch (CmsException e) {
                this.addMultiOperationException(e);
            }
        }
        try {
            this.checkMultiOperationException(Messages.get(), "ERR_PUBLISH_LIST_CREATION_0");
        }
        catch (Throwable e) {
            publishList = null;
            this.includeErrorpage(this, e);
        }
        this.getSettings().setPublishList(publishList);
        return publishList;
    }

    public CmsPublishResourcesList getPublishResourcesList() throws JspException {
        if (this.getPublishList() != null) {
            return new CmsPublishResourcesList(this.getJsp(), this.getParentFolder(), Boolean.valueOf(this.getParamRelatedresources()));
        }
        return null;
    }

    public boolean hasBrokenLinks() {
        return this.getBrokenRelationsList().getList().getTotalSize() > 0;
    }

    public boolean isCanPublish() {
        return OpenCms.getWorkplaceManager().getDefaultUserSettings().isAllowBrokenRelations() || OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.VFS_MANAGER);
    }

    public boolean isLockStateOk() {
        CmsLock lockDialog = new CmsLock(this.getJsp());
        lockDialog.setParamIncluderelated(CmsStringUtil.TRUE);
        lockDialog.setBlockingFilter(this.getBlockingFilter());
        if (!this.isDirectPublish()) {
            lockDialog.setParamResource("/");
        }
        if (!lockDialog.getBlockingLockedResources().isEmpty()) {
            return false;
        }
        if (!this.isDirectPublish()) {
            return true;
        }
        boolean locked = true;
        boolean unlocked = true;
        for (String resName : this.getResourceList()) {
            try {
                org.opencms.lock.CmsLock lock = this.getCms().getLock(this.getCms().readResource(resName, CmsResourceFilter.ALL));
                if (lock.isUnlocked()) continue;
                unlocked = false;
                if (!locked || lock.isOwnedInProjectBy(this.getCms().getRequestContext().getCurrentUser(), this.getCms().getRequestContext().getCurrentProject())) continue;
                locked = false;
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return locked || unlocked;
    }

    public void setParamDirectpublish(String value) {
        this.m_paramDirectpublish = value;
    }

    public void setParamProgresskey(String value) {
        this.m_paramProgresskey = value;
    }

    public void setParamProjectid(String value) {
        this.m_paramProjectid = value;
    }

    public void setParamProjectname(String value) {
        this.m_paramProjectname = value;
    }

    public void setParamPublishsiblings(String value) {
        this.m_paramPublishsiblings = value;
    }

    public void setParamRelatedresources(String relatedResources) {
        this.m_paramRelatedresources = relatedResources;
    }

    public void setParamSubresources(String paramSubresources) {
        this.m_paramSubresources = paramSubresources;
    }

    @Override
    public void actionCloseDialog() throws JspException {
        CmsProgressThread thread = CmsProgressWidget.getProgressThread(this.getParamProgresskey());
        if (thread != null) {
            thread.interrupt();
            CmsProgressWidget.removeProgressThread(thread.getKey());
        }
        super.actionCloseDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        this.m_progress = new CmsProgressWidget(this.getJsp());
        this.m_progress.setWidth("300px");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamResource()) || this.isMultiOperation()) {
            this.setParamDirectpublish(CmsStringUtil.TRUE);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.getParamAction()) || "initial".equals(this.getParamAction())) {
            this.setParamPublishsiblings(String.valueOf(this.getSettings().getUserSettings().getDialogPublishSiblings()));
            this.setParamSubresources(Boolean.TRUE.toString());
            String defValue = CmsStringUtil.TRUE;
            if (OpenCms.getWorkplaceManager().getDefaultUserSettings().getPublishRelatedResources() == CmsDefaultUserSettings.PUBLISH_RELATED_RESOURCES_MODE_FALSE) {
                defValue = CmsStringUtil.FALSE;
            }
            this.setParamRelatedresources(defValue);
        }
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(110);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if (DIALOG_RESOURCES_CONFIRMED.equals(this.getParamAction())) {
            CmsProgressThread thread;
            block30: {
                this.setAction(111);
                CmsPublishList publishList = this.getSettings().getPublishList();
                if (publishList == null) {
                    this.setAction(4);
                    return;
                }
                if (Boolean.valueOf(this.getParamRelatedresources()).booleanValue() && publishList.isDirectPublish()) {
                    try {
                        thread = CmsProgressWidget.getProgressThread(this.getParamProgresskey());
                        CmsPublishList storedList = null;
                        if (thread != null) {
                            storedList = ((CmsPublishResourcesList)thread.getList()).getPublishList();
                        }
                        if (storedList == null) {
                            CmsPublishList relResources = OpenCms.getPublishManager().getRelatedResourcesToPublish(this.getCms(), publishList);
                            publishList = OpenCms.getPublishManager().mergePublishLists(this.getCms(), publishList, relResources);
                        } else {
                            publishList = storedList;
                        }
                        this.getSettings().setPublishList(publishList);
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block30;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            CmsProgressWidget.removeProgressThread(this.getProgress().getKey());
            this.getProgress().startProgress(this.getBrokenRelationsList());
            CmsPublishProject e = this;
            synchronized (e) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            thread = CmsProgressWidget.getProgressThread(this.getProgress().getKey());
            if (!thread.isAlive() && thread.getList().getList().getTotalSize() == 0) {
                this.setAction(110);
            }
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            if (this.isDirectPublish()) {
                if (!this.getCms().isManagerOfProject() && !this.checkResourcePermissions(CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false)) {
                    this.setAction(4);
                    return;
                }
                this.setDialogTitle("GUI_PUBLISH_RESOURCE_1", "GUI_PUBLISH_MULTI_2");
            } else {
                this.setParamTitle(this.key("GUI_PUBLISH_PROJECT_0"));
                this.computePublishProject();
            }
            if (this.isLockStateOk()) {
                this.setAction(99);
            }
        }
    }

    @Override
    protected boolean performDialogOperation() throws CmsException {
        CmsPublishList publishList = this.getSettings().getPublishList();
        if (publishList == null) {
            throw new CmsException(Messages.get().container("ERR_GET_PUBLISH_LIST_PROJECT_1", this.getProjectname()));
        }
        OpenCms.getPublishManager().publishProject(this.getCms(), new CmsHtmlReport(this.getLocale(), this.getCms().getRequestContext().getSiteRoot()), publishList);
        OpenCms.getPublishManager().waitWhileRunning(1500L);
        return true;
    }

    private void computePublishProject() {
        String projectId = this.getParamProjectid();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(projectId)) {
            CmsUUID id = this.getCms().getRequestContext().getCurrentProject().getUuid();
            this.setParamProjectname(this.getCms().getRequestContext().getCurrentProject().getName());
            this.setParamProjectid("" + id);
        } else {
            CmsUUID id = new CmsUUID(projectId);
            try {
                this.setParamProjectname(this.getCms().readProject(id).getName());
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_SET_PROJECT_NAME_FAILED_0"), (Throwable)e);
            }
        }
    }

    private CmsLockFilter getBlockingFilter() {
        CmsLockFilter blockingFilter = CmsLockFilter.FILTER_ALL;
        blockingFilter = blockingFilter.filterNotLockableByUser(this.getCms().getRequestContext().getCurrentUser());
        if (!this.isDirectPublish()) {
            blockingFilter = blockingFilter.filterProject(new CmsUUID(this.getParamProjectid()));
        }
        return blockingFilter;
    }

    private String getParentFolder() {
        String relativeTo = this.isDirectPublish() ? CmsResource.getParentFolder(this.getResourceList().get(0)) : this.getCms().getRequestContext().getSiteRoot() + "/";
        return relativeTo;
    }

    private String getProjectname() {
        CmsUUID id = new CmsUUID(this.getParamProjectid());
        try {
            return this.getCms().readProject(id).getName();
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_SET_PROJECT_NAME_FAILED_0"), (Throwable)e);
            return "-error-";
        }
    }

    private boolean isDirectPublish() {
        if (this.getParamDirectpublish() != null) {
            return Boolean.valueOf(this.getParamDirectpublish());
        }
        return this.getDialogUri().endsWith("publishresource.jsp");
    }
}

