/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDefaultJsAction;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.tools.CmsToolMacroResolver;

public class CmsGroupSelectionList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_ACTION_SELECT = "js";
    public static final String LIST_COLUMN_DISPLAY = "cdis";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_ID = "lug";
    private String m_paramFlags;
    private String m_paramOufqn;
    private String m_paramUser;

    public CmsGroupSelectionList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_GROUPSELECTION_LIST_NAME_0"), LIST_COLUMN_DISPLAY, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsGroupSelectionList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public String dialogTitle() {
        StringBuffer html = new StringBuffer(512);
        html.append("<div class='screenTitle'>\n");
        html.append("\t<table width='100%' cellspacing='0'>\n");
        html.append("\t\t<tr>\n");
        html.append("\t\t\t<td>\n");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamUser())) {
            html.append(Messages.get().getBundle(this.getLocale()).key("GUI_GROUPSELECTION_USER_TITLE_1", this.getParamUser()));
        } else {
            html.append(Messages.get().getBundle(this.getLocale()).key("GUI_GROUPSELECTION_INTRO_TITLE_0"));
        }
        html.append("\n\t\t\t</td>");
        html.append("\t\t</tr>\n");
        html.append("\t</table>\n");
        html.append("</div>\n");
        return CmsToolMacroResolver.resolveMacros(html.toString(), this);
    }

    @Override
    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public String getParamFlags() {
        return this.m_paramFlags;
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public String getParamUser() {
        return this.m_paramUser;
    }

    public void setParamFlags(String flags) {
        this.m_paramFlags = flags;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setParamUser(String userName) {
        this.m_paramUser = userName;
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    protected List getGroups() throws CmsException {
        List<Object> ret = new ArrayList<CmsGroup>();
        if (this.getParamUser() != null) {
            ret.addAll(this.getCms().getGroupsOfUser(this.getParamUser(), false));
        } else {
            ret.addAll(OpenCms.getRoleManager().getManageableGroups(this.getCms(), "", true));
        }
        if (this.getParamFlags() != null) {
            int flags = Integer.parseInt(this.getParamFlags());
            ret = CmsPrincipal.filterFlag(ret, flags);
        }
        if (this.getParamOufqn() != null && !this.getParamOufqn().equals("null")) {
            Iterator<Object> itTempRet = ret.iterator();
            while (itTempRet.hasNext()) {
                CmsGroup group = (CmsGroup)itTempRet.next();
                if (group.getOuFqn().startsWith(this.getParamOufqn())) continue;
                itTempRet.remove();
            }
        }
        return ret;
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List groups = this.getGroups();
        for (CmsGroup group : groups) {
            CmsListItem item = this.getList().newItem(group.getId().toString());
            item.set(LIST_COLUMN_NAME, group.getName());
            item.set(LIST_COLUMN_DISPLAY, OpenCms.getWorkplaceManager().translateGroupName(group.getName(), true));
            ret.add(item);
        }
        return ret;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_GROUPSELECTION_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_GROUPSELECTION_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListDirectAction iconAction = new CmsListDirectAction(LIST_ACTION_ICON);
        iconAction.setName(Messages.get().container("GUI_GROUPSELECTION_LIST_ICON_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_GROUPSELECTION_LIST_ICON_HELP_0"));
        iconAction.setIconPath("buttons/group.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction(iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_GROUPSELECTION_LIST_COLS_NAME_0"));
        nameCol.setVisible(false);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition displayCol = new CmsListColumnDefinition(LIST_COLUMN_DISPLAY);
        displayCol.setName(Messages.get().container("GUI_GROUPSELECTION_LIST_COLS_NAME_0"));
        displayCol.setWidth("100%");
        A_CmsListDefaultJsAction selectAction = new A_CmsListDefaultJsAction(LIST_ACTION_SELECT){

            @Override
            public String jsCode() {
                return "window.opener.setGroupFormValue('" + this.getItem().get(CmsGroupSelectionList.LIST_COLUMN_NAME) + "'); window.opener.focus(); window.close();";
            }
        };
        selectAction.setName(Messages.get().container("GUI_GROUPSELECTION_LIST_ACTION_SELECT_NAME_0"));
        selectAction.setHelpText(Messages.get().container("GUI_GROUPSELECTION_LIST_ACTION_SELECT_HELP_0"));
        displayCol.addDefaultAction(selectAction);
        metadata.addColumn(displayCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_DISPLAY));
        searchAction.setCaseInSensitive(true);
        metadata.setSearchAction(searchAction);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }

    @Override
    protected void validateParamaters() throws Exception {
        try {
            this.getCms().readUser(this.getParamUser()).getName();
        }
        catch (Exception e) {
            this.setParamUser(null);
        }
        try {
            Integer.valueOf(this.getParamFlags());
        }
        catch (Throwable e) {
            this.setParamFlags(null);
        }
    }
}

