/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsResource;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListResourceIconAction;
import org.opencms.workplace.list.I_CmsListFormatter;

public class CmsDeletedResourcesList
extends A_CmsListDialog {
    public static final String ICON_LIST_WARNING = "list/warning.png";
    public static final String ICON_MULTI_RESTORE = "tools/ex_history/buttons/restore.png";
    public static final String LIST_ACTION_CONFLICT = "drlac";
    public static final String LIST_ACTION_ICON = "drlai";
    public static final String LIST_COLUMN_CONFLICT = "drlcc";
    public static final String LIST_COLUMN_DELETION_DATE = "drlcdd";
    public static final String LIST_COLUMN_ICON = "drlci";
    public static final String LIST_COLUMN_NAME = "drlcn";
    public static final String LIST_COLUMN_TYPEID = "drlct";
    public static final String LIST_COLUMN_VERSION = "drlcv";
    public static final String LIST_ID = "drl";
    public static final String LIST_MACTION_RESTORE = "mr";
    private boolean m_readTree;
    private String m_resourcename;

    public CmsDeletedResourcesList(CmsJspActionElement jsp, String resourcename, boolean readTree) {
        super(jsp, LIST_ID, Messages.get().container("GUI_DELETED_RESOURCES_LIST_NAME_0"), null, CmsListOrderEnum.ORDER_ASCENDING, null);
        this.setParamStyle("");
        this.getList().setMaxItemsPerPage(Integer.MAX_VALUE);
        this.getList().getMetadata().getIndependentAction("iap").setVisible(false);
        this.getList().setBoxed(false);
        this.m_readTree = readTree;
        this.m_resourcename = resourcename;
    }

    @Override
    public void executeListMultiActions() throws CmsRuntimeException {
    }

    @Override
    public void executeListSingleActions() throws CmsRuntimeException {
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List<I_CmsHistoryResource> list = this.getCms().readDeletedResources(this.m_resourcename, this.m_readTree);
        for (I_CmsHistoryResource res : list) {
            CmsListItem item = this.getList().newItem(res.getStructureId().toString());
            String resourcePath = this.getCms().getSitePath((CmsResource)((Object)res));
            item.set(LIST_COLUMN_NAME, this.m_resourcename + "|" + resourcePath);
            item.set(LIST_COLUMN_DELETION_DATE, new Date(res.getDateLastModified()));
            item.set(LIST_COLUMN_VERSION, String.valueOf(res.getVersion()));
            item.set(LIST_COLUMN_TYPEID, String.valueOf(res.getTypeId()));
            ret.add(item);
        }
        return ret;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_DELETED_RESOURCES_LIST_COLS_ICON_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListResourceIconAction iconAction = new CmsListResourceIconAction(LIST_ACTION_ICON, LIST_COLUMN_TYPEID, this.getCms());
        iconAction.setName(Messages.get().container("GUI_DELETED_RESOURCES_LIST_ACTION_ICON_0"));
        iconAction.setEnabled(false);
        iconCol.addDirectAction(iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition conflictCol = new CmsListColumnDefinition(LIST_COLUMN_CONFLICT);
        conflictCol.setName(Messages.get().container("GUI_DELETED_RESOURCES_LIST_COLS_CONFLICT_0"));
        conflictCol.setWidth("20");
        conflictCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        conflictCol.setSorteable(false);
        CmsListResourceIconAction conflictAction = new CmsListResourceIconAction(LIST_ACTION_CONFLICT, null, this.getCms()){

            @Override
            public String getIconPath() {
                return CmsDeletedResourcesList.ICON_LIST_WARNING;
            }

            @Override
            public boolean isVisible() {
                String path = (String)this.getItem().get(CmsDeletedResourcesList.LIST_COLUMN_NAME);
                return this.getCms().existsResource(path);
            }
        };
        conflictAction.setName(Messages.get().container("GUI_DELETED_RESOURCES_LIST_ACTION_WARNING_0"));
        conflictAction.setEnabled(false);
        conflictCol.addDirectAction(conflictAction);
        metadata.addColumn(conflictCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_DELETED_RESOURCES_LIST_COLS_NAME_0"));
        nameCol.setSorteable(false);
        nameCol.setWidth("60%");
        nameCol.setFormatter(new I_CmsListFormatter(){

            @Override
            public String format(Object data, Locale locale) {
                String resourcePath;
                String[] dataArray = CmsStringUtil.splitAsArray((String)data, "|");
                String resourceName = dataArray[0];
                String orgResourcePath = resourcePath = dataArray[1];
                while (CmsStringUtil.isNotEmptyOrWhitespaceOnly(resourcePath)) {
                    try {
                        CmsDeletedResourcesList.this.getCms().readResource(CmsDeletedResourcesList.this.getCms().getRequestContext().removeSiteRoot(resourcePath));
                        break;
                    }
                    catch (CmsException e) {
                        resourcePath = CmsResource.getParentFolder(resourcePath);
                    }
                }
                resourcePath = resourcePath != null ? resourcePath.substring(resourceName.length()) : "";
                orgResourcePath = orgResourcePath.substring(resourceName.length());
                StringBuffer ret = new StringBuffer();
                ret.append(resourcePath);
                ret.append("<span style=\"color:#0000aa;\">");
                ret.append(orgResourcePath.substring(resourcePath.length()));
                ret.append("</span>");
                return ret.toString();
            }
        });
        metadata.addColumn(nameCol);
        CmsListColumnDefinition delDateCol = new CmsListColumnDefinition(LIST_COLUMN_DELETION_DATE);
        delDateCol.setName(Messages.get().container("GUI_DELETED_RESOURCES_LIST_COLS_DEL_DATE_0"));
        delDateCol.setSorteable(false);
        delDateCol.setWidth("20%");
        delDateCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(delDateCol);
        CmsListColumnDefinition versionCol = new CmsListColumnDefinition(LIST_COLUMN_VERSION);
        versionCol.setName(Messages.get().container("GUI_DELETED_RESOURCES_LIST_COLS_VERSION_0"));
        versionCol.setSorteable(false);
        versionCol.setWidth("20%");
        versionCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        metadata.addColumn(versionCol);
        CmsListColumnDefinition typeidCol = new CmsListColumnDefinition(LIST_COLUMN_TYPEID);
        typeidCol.setName(Messages.get().container("GUI_DELETED_RESOURCES_LIST_COLS_TYPEID_0"));
        typeidCol.setVisible(false);
        metadata.addColumn(typeidCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction restoreMultiAction = new CmsListMultiAction(LIST_MACTION_RESTORE);
        restoreMultiAction.setName(Messages.get().container("GUI_DELETED_RESOURCES_LIST_MACTION_RESTORE_NAME_0"));
        restoreMultiAction.setIconPath(ICON_MULTI_RESTORE);
        restoreMultiAction.setHelpText(Messages.get().container("GUI_DELETED_RESOURCES_LIST_MACTION_RESTORE_HELP_0"));
        restoreMultiAction.setVisible(false);
        metadata.addMultiAction(restoreMultiAction);
    }
}

