/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.I_CmsDialogHandler;
import org.opencms.workplace.commons.CmsDeleteBrokenRelationsList;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.CmsListExplorerColumn;

public class CmsDelete
extends CmsMultiDialog
implements I_CmsDialogHandler {
    public static final int ACTION_DELETE = 100;
    public static final String DIALOG_TYPE = "delete";
    public static final Log LOG = CmsLog.getLog(CmsDelete.class);
    public static final String PARAM_DELETE_SIBLINGS = "deletesiblings";
    public static final String URI_DELETE_DIALOG = "/system/workplace/commons/delete_standard.jsp";
    private String m_deleteSiblings;

    public CmsDelete() {
        super(null);
    }

    public CmsDelete(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDelete(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionDelete() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            boolean isFolder = false;
            if (!this.isMultiOperation()) {
                isFolder = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL).isFolder();
            }
            if (this.performDialogOperation()) {
                if (this.isMultiOperation() || isFolder) {
                    ArrayList<String> folderList = new ArrayList<String>(1);
                    folderList.add(CmsResource.getParentFolder(this.getResourceList().get(0)));
                    this.getJsp().getRequest().setAttribute("__CmsWorkplace.RELOADTREE", folderList);
                }
                this.actionCloseDialog();
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
    }

    public String buildConfirmation() {
        StringBuffer result = new StringBuffer(512);
        boolean isFolder = false;
        if (!this.isMultiOperation()) {
            try {
                isFolder = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL).isFolder();
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        result.append("<div id='conf-msg'>\n");
        if (this.isMultiOperation() || isFolder || this.hasSiblings() && this.hasCorrectLockstate()) {
            result.append(this.key("GUI_DELETE_MULTI_CONFIRMATION_0"));
        } else {
            result.append(this.key("GUI_DELETE_CONFIRMATION_0"));
        }
        result.append("\n</div>\n");
        return result.toString();
    }

    public String buildDeleteSiblings() {
        StringBuffer result = new StringBuffer(512);
        if (this.isMultiOperation() || this.hasSiblings() && this.hasCorrectLockstate()) {
            CmsResource.CmsResourceDeleteMode defaultMode;
            CmsResource.CmsResourceDeleteMode cmsResourceDeleteMode = defaultMode = Boolean.valueOf(this.getParamDeleteSiblings()) != false ? CmsResource.DELETE_REMOVE_SIBLINGS : CmsResource.DELETE_PRESERVE_SIBLINGS;
            if (!this.isMultiOperation()) {
                result.append(this.key("GUI_DELETE_WARNING_SIBLINGS_0"));
                result.append("<p>");
            }
            result.append("<input type=\"radio\" name=\"");
            result.append(PARAM_DELETE_SIBLINGS);
            result.append("radio\" value=\"false\"");
            if (defaultMode == CmsResource.DELETE_PRESERVE_SIBLINGS) {
                result.append(" checked=\"checked\"");
            }
            result.append(" onclick='reloadDialog(false);'>&nbsp;");
            result.append(this.key("GUI_DELETE_PRESERVE_SIBLINGS_0"));
            result.append("<br>");
            result.append("<input type=\"radio\" name=\"");
            result.append(PARAM_DELETE_SIBLINGS);
            result.append("radio\" value=\"true\"");
            if (defaultMode == CmsResource.DELETE_REMOVE_SIBLINGS) {
                result.append(" checked=\"checked\"");
            }
            result.append(" onclick='reloadDialog(true);'>&nbsp;");
            result.append(this.key("GUI_DELETE_ALL_SIBLINGS_0"));
            result.append("<p>");
        }
        return result.toString();
    }

    public String buildReport() throws JspException, ServletException, IOException {
        CmsDeleteBrokenRelationsList list = new CmsDeleteBrokenRelationsList(this.getJsp(), this.getResourceList(), Boolean.valueOf(this.getParamDeleteSiblings()));
        list.actionDialog();
        StringBuffer result = new StringBuffer(512);
        list.getList().setBoxed(false);
        result.append("<input type='hidden' name='result' value='");
        result.append(list.getList().getTotalSize()).append("'>\n");
        result.append(CmsListExplorerColumn.getExplorerStyleDef());
        result.append("<div style='height:150px; overflow: auto;'>\n");
        result.append(list.getList().listHtml());
        result.append("</div>\n");
        return result.toString();
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return CmsParameterConfiguration.EMPTY_PARAMETERS;
    }

    @Override
    public String getDialogHandler() {
        return "class_dialog_delete";
    }

    @Override
    public String getDialogUri(String resource, CmsJspActionElement jsp) {
        return URI_DELETE_DIALOG;
    }

    public String getParamDeleteSiblings() {
        return this.m_deleteSiblings;
    }

    @Override
    public void initConfiguration() {
    }

    public boolean isCanDelete() {
        return OpenCms.getWorkplaceManager().getDefaultUserSettings().isAllowBrokenRelations() || OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.VFS_MANAGER);
    }

    public void setParamDeleteSiblings(String value) {
        this.m_deleteSiblings = value;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.getParamDeleteSiblings())) {
            this.setParamDeleteSiblings(Boolean.toString(this.getSettings().getUserSettings().getDialogDeleteFileMode() == CmsResource.DELETE_REMOVE_SIBLINGS));
        }
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setDialogTitle("GUI_DELETE_RESOURCE_1", "GUI_DELETE_MULTI_2");
        }
    }

    @Override
    protected boolean performDialogOperation() throws CmsException {
        boolean isFolder = this.isOperationOnFolder();
        if ((this.isMultiOperation() || isFolder) && !"wait".equals(this.getParamAction())) {
            return false;
        }
        CmsResource.CmsResourceDeleteMode deleteOption = Boolean.valueOf(this.getParamDeleteSiblings()) != false ? CmsResource.DELETE_REMOVE_SIBLINGS : CmsResource.DELETE_PRESERVE_SIBLINGS;
        for (String resName : this.getResourceList()) {
            try {
                this.performSingleDeleteOperation(resName, deleteOption);
            }
            catch (CmsException e) {
                if (this.isMultiOperation()) {
                    this.addMultiOperationException(e);
                    continue;
                }
                throw e;
            }
        }
        this.checkMultiOperationException(Messages.get(), "ERR_DELETE_MULTI_0");
        return true;
    }

    protected void performSingleDeleteOperation(String resource, CmsResource.CmsResourceDeleteMode deleteOption) throws CmsException {
        this.checkLock(resource);
        this.getCms().deleteResource(resource, deleteOption);
    }
}

