/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsImageScaler;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;

public class CmsCommentImages
extends CmsDialog {
    public static final int ACTION_COMMENTIMAGES = 100;
    public static final String DIALOG_TYPE = "commentimages";
    public static final String PREFIX_DESCRIPTION = "desc_";
    public static final String PREFIX_TITLE = "title_";
    public static final int THUMB_HEIGHT = 150;
    public static final int THUMB_WIDTH = 200;
    private static final Log LOG = CmsLog.getLog(CmsCommentImages.class);
    private CmsImageScaler m_imageScaler;

    public CmsCommentImages(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsCommentImages(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommentImages() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            this.performDialogOperation();
            this.actionCloseDialog();
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public String buildDialogForm() {
        StringBuffer result = new StringBuffer(16384);
        Iterator i = this.getImages().iterator();
        result.append("<div style=\"height: 450px; padding: 4px; overflow: auto;\">");
        while (i.hasNext()) {
            String description;
            String propertySuffix;
            block8: {
                String title;
                CmsResource res;
                block7: {
                    res = (CmsResource)i.next();
                    String imageName = res.getName();
                    propertySuffix = "" + imageName.hashCode();
                    result.append(this.dialogBlockStart(imageName));
                    result.append("<table border=\"0\">\n");
                    result.append("<tr>\n\t<td style=\"vertical-align: top;\">");
                    result.append("<img src=\"");
                    StringBuffer link = new StringBuffer(256);
                    link.append(this.getCms().getSitePath(res));
                    link.append(this.getImageScaler().toRequestParam());
                    result.append(this.getJsp().link(link.toString()));
                    result.append("\" border=\"0\" alt=\"\" width=\"");
                    result.append(this.getImageScaler().getWidth());
                    result.append("\" height=\"");
                    result.append(this.getImageScaler().getHeight());
                    result.append("\">");
                    result.append("</td>\n");
                    result.append("\t<td class=\"maxwidth\" style=\"vertical-align: top;\">\n");
                    result.append("\t\t<table border=\"0\">\n");
                    title = "";
                    try {
                        title = this.getCms().readPropertyObject(res, "Title", false).getValue();
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block7;
                        LOG.error((Object)e.getLocalizedMessage(this.getLocale()));
                    }
                }
                result.append("\t\t<tr>\n\t\t\t<td style=\"white-space: nowrap;\" unselectable=\"on\">");
                result.append(this.key("GUI_LABEL_TITLE_0"));
                result.append(":</td>\n\t\t\t<td class=\"maxwidth\">");
                result.append("<input type=\"text\" class=\"maxwidth\" name=\"");
                result.append(PREFIX_TITLE);
                result.append(propertySuffix);
                result.append("\" value=\"");
                if (CmsStringUtil.isNotEmpty(title)) {
                    result.append(CmsEncoder.escapeXml(title));
                }
                result.append("\">");
                result.append("</td>\n\t\t</tr>\n");
                description = "";
                try {
                    description = this.getCms().readPropertyObject(res, "Description", false).getValue();
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block8;
                    LOG.error((Object)e.getLocalizedMessage(this.getLocale()));
                }
            }
            result.append("\t\t<tr>\n\t\t\t<td style=\"white-space: nowrap; vertical-align: top;\" unselectable=\"on\">");
            result.append(this.key("GUI_LABEL_DESCRIPTION_0"));
            result.append(":</td>\n\t\t\t<td style=\"vertical-align: top; height: 110px;\">");
            result.append("<textarea rows=\"8\" class=\"maxwidth\" style=\"overflow: auto;\" name=\"");
            result.append(PREFIX_DESCRIPTION);
            result.append(propertySuffix);
            result.append("\">");
            if (CmsStringUtil.isNotEmpty(description)) {
                result.append(CmsEncoder.escapeXml(description));
            }
            result.append("</textarea>");
            result.append("</td>\n\t\t</tr>\n");
            result.append("\t\t</table>\n");
            result.append("</td>\n</tr>\n");
            result.append("</table>\n");
            result.append(this.dialogBlockEnd());
            if (!i.hasNext()) continue;
            result.append(this.dialogSpacer());
        }
        result.append("</div>");
        return result.toString();
    }

    protected List getImages() {
        int imageId;
        try {
            imageId = OpenCms.getResourceManager().getResourceType(CmsResourceTypeImage.getStaticTypeName()).getTypeId();
        }
        catch (CmsLoaderException e1) {
            LOG.warn((Object)e1.getLocalizedMessage(), (Throwable)e1);
            imageId = CmsResourceTypeImage.getStaticTypeId();
        }
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(imageId);
        try {
            return this.getCms().readResources(this.getParamResource(), filter, false);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(this.getLocale()));
            }
            return new ArrayList(0);
        }
    }

    protected CmsImageScaler getImageScaler() {
        if (this.m_imageScaler == null) {
            this.m_imageScaler = new CmsImageScaler();
            this.m_imageScaler.setWidth(200);
            this.m_imageScaler.setHeight(150);
            this.m_imageScaler.setRenderMode(2);
            this.m_imageScaler.setColor(new Color(0, 0, 0));
            this.m_imageScaler.setType(1);
        }
        return this.m_imageScaler;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            Object[] args = new Object[]{this.getParamResource()};
            this.setParamTitle(this.key("GUI_COMMENTIMAGES_TITLE_1", args));
        }
    }

    protected boolean performDialogOperation() throws CmsException {
        this.checkLock(this.getParamResource());
        for (CmsResource res : this.getImages()) {
            String imageName = res.getName();
            String propertySuffix = "" + imageName.hashCode();
            CmsProperty titleProperty = this.getCms().readPropertyObject(res, "Title", false);
            String newValue = this.getJsp().getRequest().getParameter(PREFIX_TITLE + propertySuffix);
            this.writeProperty(res, "Title", newValue, titleProperty);
            CmsProperty descProperty = this.getCms().readPropertyObject(res, "Description", false);
            newValue = this.getJsp().getRequest().getParameter(PREFIX_DESCRIPTION + propertySuffix);
            this.writeProperty(res, "Description", newValue, descProperty);
        }
        return true;
    }

    protected void writeProperty(CmsResource res, String propName, String propValue, CmsProperty currentProperty) throws CmsException {
        if (currentProperty.isNullProperty()) {
            currentProperty = new CmsProperty();
            currentProperty.setName(propName);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(propValue)) {
            boolean writeProperty = false;
            if (currentProperty.getStructureValue() != null) {
                currentProperty.setStructureValue("");
                currentProperty.setResourceValue(null);
                writeProperty = true;
            } else if (currentProperty.getResourceValue() != null) {
                currentProperty.setResourceValue("");
                currentProperty.setStructureValue(null);
                writeProperty = true;
            }
            if (writeProperty) {
                this.getCms().writePropertyObject(this.getCms().getSitePath(res), currentProperty);
            }
        } else if (!propValue.equals(currentProperty.getValue())) {
            if (currentProperty.getStructureValue() == null && currentProperty.getResourceValue() == null) {
                if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                    currentProperty.setStructureValue(propValue);
                    currentProperty.setResourceValue(null);
                } else {
                    currentProperty.setResourceValue(propValue);
                    currentProperty.setStructureValue(null);
                }
            } else if (currentProperty.getStructureValue() != null) {
                currentProperty.setStructureValue(propValue);
                currentProperty.setResourceValue(null);
            } else {
                currentProperty.setResourceValue(propValue);
                currentProperty.setStructureValue(null);
            }
            this.getCms().writePropertyObject(this.getCms().getSitePath(res), currentProperty);
        }
    }
}

