/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsProject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsSecurityException;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.Messages;

public class CmsLoginHelper
extends CmsWorkplace {
    private CmsException m_loginException;

    public CmsLoginHelper(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public CmsException getLoginException() {
        return this.m_loginException;
    }

    public String getStacktrace() {
        String stacktrace = CmsException.getStackTraceAsString(this.getLoginException());
        stacktrace = CmsEncoder.escapeXml(stacktrace);
        return stacktrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String userName, String password, String projectName, String siteRoot, String resourceName) {
        if (this.getCms().getRequestContext().getCurrentUser().isGuestUser()) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName) || CmsStringUtil.isEmptyOrWhitespaceOnly(password)) {
                return false;
            }
            try {
                this.getCms().loginUser(userName, password, this.getCms().getRequestContext().getRemoteAddress());
            }
            catch (CmsException e) {
                this.m_loginException = e;
                return false;
            }
        }
        CmsUserSettings userSettings = new CmsUserSettings(this.getCms());
        try {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(projectName)) {
                projectName = userSettings.getStartProject();
            }
            CmsProject project = this.getCms().readProject(projectName);
            if (!OpenCms.getOrgUnitManager().getAllAccessibleProjects(this.getCms(), project.getOuFqn(), false).contains(project)) {
                throw new CmsSecurityException(Messages.get().container("ERR_PROJECT_NOT_ACCESSIBLE_2", userName, projectName));
            }
            this.getCms().getRequestContext().setCurrentProject(project);
        }
        catch (CmsException e) {
            this.m_loginException = e;
        }
        if (this.m_loginException == null) {
            try {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(siteRoot)) {
                    siteRoot = userSettings.getStartSite();
                }
                String oldSite = this.getCms().getRequestContext().getSiteRoot();
                try {
                    this.getCms().getRequestContext().setSiteRoot("");
                    this.getCms().readResource(siteRoot);
                }
                finally {
                    this.getCms().getRequestContext().setSiteRoot(oldSite);
                }
                boolean hasAccess = false;
                CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
                Iterator<CmsSite> accessibles = OpenCms.getSiteManager().getAvailableSites(this.getCms(), false).iterator();
                while (accessibles.hasNext() && !hasAccess && site != null) {
                    CmsSite accessible = accessibles.next();
                    if (!accessible.getSiteRoot().equals(site.getSiteRoot())) continue;
                    hasAccess = true;
                }
                if (!hasAccess) {
                    throw new CmsSecurityException(Messages.get().container("ERR_SITE_NOT_ACCESSIBLE_2", userName, siteRoot));
                }
                this.getCms().getRequestContext().setSiteRoot(siteRoot);
            }
            catch (CmsException e) {
                this.m_loginException = e;
            }
        }
        try {
            this.getCms().readResource(resourceName);
        }
        catch (CmsException e) {
            this.m_loginException = e;
        }
        if (this.m_loginException != null) {
            HttpSession session = this.getJsp().getRequest().getSession(false);
            if (session != null) {
                session.invalidate();
            }
            return false;
        }
        if (OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.WORKPLACE_USER)) {
            CmsWorkplaceSettings wpSettings = this.getSettings();
            if (wpSettings == null) {
                wpSettings = new CmsWorkplaceSettings();
                wpSettings = CmsLoginHelper.initWorkplaceSettings(this.getCms(), wpSettings, false);
            }
            wpSettings.setSite(this.getCms().getRequestContext().getSiteRoot());
            wpSettings.setProject(this.getCms().getRequestContext().getCurrentProject().getUuid());
            wpSettings.setUser(this.getCms().getRequestContext().getCurrentUser());
            HttpSession session = this.getJsp().getRequest().getSession(true);
            CmsLoginHelper.storeSettings(session, wpSettings);
        }
        return true;
    }

    @Override
    protected void checkRole() {
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
    }
}

