/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsLoginMessage;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsAcceptLanguageHeaderParser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspLoginBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUriSplitter;
import org.opencms.workplace.CmsLoginUserAgreement;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.Messages;

public class CmsLogin
extends CmsJspLoginBean {
    public static final int ACTION_DISPLAY = 0;
    public static final int ACTION_LOGIN = 1;
    public static final int ACTION_LOGOUT = 2;
    public static final String PARAM_ACTION_GETOULIST = "getoulist";
    public static final String PARAM_ACTION_LOGIN = "login";
    public static final String PARAM_ACTION_LOGOUT = "logout";
    public static final String PARAM_FORM = "ocLoginForm";
    public static final String PARAM_OUFQN = "ocOuFqn";
    public static final String PARAM_OUSEARCH = "ocOuSearch";
    public static final String PARAM_PASSWORD = "ocPword";
    public static final String PARAM_PCTYPE = "ocPcType";
    public static final String PARAM_PREDEF_OUFQN = "ocPredefOuFqn";
    public static final String PARAM_USERNAME = "ocUname";
    public static final String PARAM_WPDATA = "ocWpData";
    public static final String PCTYPE_PRIVATE = "private";
    public static final String PCTYPE_PUBLIC = "public";
    private static final String COOKIE_OUFQN = "OpenCmsOuFqn";
    private static final String COOKIE_PCTYPE = "OpenCmsPcType";
    private static final String COOKIE_USERNAME = "OpenCmsUserName";
    private static final String COOKIE_WP_DATA = "OpenCmsWpData";
    private static final Log LOG = CmsLog.getLog(CmsLogin.class);
    private int m_action;
    private String m_actionLogin;
    private String m_actionLogout;
    private String m_directEditPath;
    private Locale m_locale;
    private CmsMessageContainer m_message;
    private CmsOrganizationalUnit m_ou;
    private String m_oufqn;
    private List<CmsOrganizationalUnit> m_ous;
    private String m_password;
    private String m_pcType;
    private String m_requestedResource;
    private String m_username;

    public CmsLogin(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
        res.setDateHeader("Last-Modified", System.currentTimeMillis());
        CmsRequestUtil.setNoCacheHeaders(res);
        CmsAcceptLanguageHeaderParser parser = new CmsAcceptLanguageHeaderParser(req, OpenCms.getWorkplaceManager().getDefaultLocale());
        List<Locale> acceptedLocales = parser.getAcceptedLocales();
        List<Locale> workplaceLocales = OpenCms.getWorkplaceManager().getLocales();
        this.m_locale = OpenCms.getLocaleManager().getFirstMatchingLocale(acceptedLocales, workplaceLocales);
        if (this.m_locale == null) {
            this.m_locale = OpenCms.getWorkplaceManager().getDefaultLocale();
        }
    }

    public String buildOrgUnitSelector() {
        StringBuffer html = new StringBuffer();
        html.append("<select style='width: 100%;' size='1' ");
        this.appendId(html, PARAM_OUFQN);
        html.append(">\n");
        for (CmsOrganizationalUnit ou : this.getOus()) {
            String selected = "";
            if (ou.getName().equals(this.m_oufqn) || CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_oufqn) && ou.getName().equals(this.m_oufqn.substring(1))) {
                selected = " selected='selected'";
            }
            html.append("<option value='").append(ou.getName()).append("'").append(selected).append(">");
            html.append(ou.getDisplayName(this.m_locale));
            html.append("</option>\n");
        }
        html.append("</select>\n");
        return html.toString();
    }

    public String displayDialog() throws IOException {
        if (OpenCms.getSiteManager().getSites().size() > 1 && !OpenCms.getSiteManager().isWorkplaceRequest(this.getRequest())) {
            StringBuffer loginLink = new StringBuffer(256);
            loginLink.append(OpenCms.getSiteManager().getWorkplaceSiteMatcher().toString());
            loginLink.append(this.getFormLink());
            this.getResponse().sendRedirect(loginLink.toString());
            return null;
        }
        CmsObject cms = this.getCmsObject();
        this.m_message = null;
        if (cms.getRequestContext().getCurrentUser().isGuestUser()) {
            this.m_action = 0;
            this.m_username = CmsRequestUtil.getNotEmptyParameter(this.getRequest(), PARAM_USERNAME);
            if (this.m_username != null) {
                this.m_username = this.m_username.trim();
            }
            this.m_password = CmsRequestUtil.getNotEmptyParameter(this.getRequest(), PARAM_PASSWORD);
            this.m_actionLogin = CmsRequestUtil.getNotEmptyParameter(this.getRequest(), PARAM_ACTION_LOGIN);
            this.m_oufqn = this.getRequest().getParameter(PARAM_OUFQN);
            if (this.m_oufqn == null) {
                this.m_oufqn = this.getPreDefOuFqn();
            }
            this.m_pcType = OpenCms.getLoginManager().isEnableSecurity() ? CmsRequestUtil.getNotEmptyParameter(this.getRequest(), PARAM_PCTYPE) : PCTYPE_PRIVATE;
            this.getCookieData();
            if (this.m_pcType == null) {
                this.m_pcType = PCTYPE_PUBLIC;
            }
        } else {
            this.m_oufqn = cms.getRequestContext().getOuFqn();
            this.m_action = 1;
            this.m_actionLogout = CmsRequestUtil.getNotEmptyParameter(this.getRequest(), PARAM_ACTION_LOGOUT);
        }
        if (this.m_oufqn == null) {
            this.m_oufqn = "/";
        }
        String actionGetOus = CmsRequestUtil.getNotEmptyParameter(this.getRequest(), PARAM_ACTION_GETOULIST);
        if (Boolean.TRUE.toString().equals(actionGetOus)) {
            return this.getJsonOrgUnitList();
        }
        this.m_ou = null;
        try {
            this.m_ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCmsObject(), this.m_oufqn);
        }
        catch (CmsException e) {
            this.m_oufqn = "/";
            try {
                this.m_ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCmsObject(), this.m_oufqn);
            }
            catch (CmsException exc) {
                LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
            }
        }
        this.m_requestedResource = CmsRequestUtil.getNotEmptyParameter(this.getRequest(), "requestedResource");
        if (this.m_requestedResource == null) {
            this.m_requestedResource = "/system/workplace/views/workplace.jsp";
        }
        if (Boolean.valueOf(this.m_actionLogin).booleanValue()) {
            if (this.m_username == null && this.m_password == null) {
                this.m_message = Messages.get().container("GUI_LOGIN_NO_DATA_0");
            } else if (this.m_username == null) {
                this.m_message = Messages.get().container("GUI_LOGIN_NO_NAME_0");
            } else if (this.m_password == null) {
                this.m_message = Messages.get().container("GUI_LOGIN_NO_PASSWORD_0");
            } else if (this.m_username != null && this.m_password != null) {
                this.login((this.m_oufqn == null ? "/" : this.m_oufqn) + this.m_username, this.m_password);
                if (this.getLoginException() == null) {
                    this.m_action = 1;
                    CmsWorkplaceSettings workplaceSettings = CmsWorkplace.initWorkplaceSettings(cms, null, false);
                    String startSite = CmsWorkplace.getStartSiteRoot(cms, workplaceSettings);
                    workplaceSettings.setSite(startSite);
                    cms.getRequestContext().setSiteRoot(startSite);
                    this.getRequest().getSession().setAttribute("__CmsWorkplace.WORKPLACE_SETTINGS", (Object)workplaceSettings);
                    CmsUserSettings settings = workplaceSettings.getUserSettings();
                    this.m_directEditPath = this.getDirectEditPath(settings);
                    try {
                        CmsProject project = cms.readProject(settings.getStartProject());
                        if (OpenCms.getOrgUnitManager().getAllAccessibleProjects(cms, project.getOuFqn(), false).contains(project)) {
                            workplaceSettings.setProject(project.getUuid());
                            cms.getRequestContext().setCurrentProject(project);
                        }
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_LOGIN_NO_STARTUP_PROJECT_2", this.m_username, settings.getStartProject()), (Throwable)e);
                    }
                } else {
                    CmsLoginMessage loginMessage;
                    if ("ERR_LOGIN_FAILED_DISABLED_2" == this.getLoginException().getMessageContainer().getKey()) {
                        this.m_message = Messages.get().container("GUI_LOGIN_FAILED_DISABLED_0");
                    } else if ("ERR_LOGIN_FAILED_TEMP_DISABLED_4" == this.getLoginException().getMessageContainer().getKey()) {
                        this.m_message = Messages.get().container("GUI_LOGIN_FAILED_TEMP_DISABLED_0");
                    } else if ("ERR_LOGIN_FAILED_WITH_MESSAGE_1" == this.getLoginException().getMessageContainer().getKey() && (loginMessage = OpenCms.getLoginManager().getLoginMessage()) != null) {
                        this.m_message = Messages.get().container("GUI_LOGIN_FAILED_WITH_MESSAGE_1", loginMessage.getMessage());
                    }
                    if (this.m_message == null) {
                        this.m_message = Messages.get().container("GUI_LOGIN_FAILED_0");
                    }
                }
            }
        } else if (Boolean.valueOf(this.m_actionLogout).booleanValue()) {
            this.m_action = 2;
            Cookie wpDataCookie = this.getCookie(COOKIE_WP_DATA);
            String wpData = CmsRequestUtil.getNotEmptyParameter(this.getRequest(), PARAM_WPDATA);
            if (wpData != null) {
                wpData = CmsEncoder.escapeXml(wpData);
                wpDataCookie.setValue(wpData);
                this.setCookie(wpDataCookie, false);
            }
            this.logout();
            return null;
        }
        if (this.m_action == 1) {
            this.m_message = null;
            CmsUriSplitter splitter = new CmsUriSplitter(this.m_requestedResource, true);
            String resource = splitter.getPrefix();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(resource)) {
                resource = "/system/workplace/views/workplace.jsp";
            }
            if (!this.getCmsObject().existsResource(resource, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                if ("/system/workplace/views/workplace.jsp".equals(resource)) {
                    this.m_message = Messages.get().container("GUI_LOGIN_FAILED_NO_WORKPLACE_PERMISSIONS_0");
                    this.m_action = 0;
                } else if (this.getCmsObject().existsResource("/system/workplace/views/workplace.jsp")) {
                    this.m_message = Messages.get().container("GUI_LOGIN_UNKNOWN_RESOURCE_1", this.m_requestedResource);
                    this.m_requestedResource = "/system/workplace/views/workplace.jsp";
                } else {
                    this.m_message = Messages.get().container("GUI_LOGIN_FAILED_NO_TARGET_PERMISSIONS_1", this.m_requestedResource);
                    this.m_action = 0;
                }
            }
            if (this.m_action == 0) {
                this.m_requestedResource = null;
                HttpSession session = this.getRequest().getSession(false);
                if (session != null) {
                    session.invalidate();
                }
            } else {
                this.setCookieData();
            }
        }
        return this.displayLoginForm();
    }

    public void getCookieData() {
        Cookie pcTypeCookie = this.getCookie(COOKIE_PCTYPE);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(pcTypeCookie.getValue()) && this.m_pcType == null) {
            this.m_pcType = pcTypeCookie.getValue();
        }
        if ("null".equals(this.m_pcType)) {
            this.m_pcType = null;
        }
        if (this.m_pcType == null || PCTYPE_PRIVATE.equals(this.m_pcType)) {
            Cookie ouFqnCookie;
            Cookie userNameCookie = this.getCookie(COOKIE_USERNAME);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(userNameCookie.getValue())) {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_username)) {
                    this.m_username = userNameCookie.getValue();
                }
                if (this.m_pcType == null) {
                    this.m_pcType = PCTYPE_PRIVATE;
                }
            }
            if ("null".equals(this.m_username)) {
                this.m_username = null;
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((ouFqnCookie = this.getCookie(COOKIE_OUFQN)).getValue()) && this.m_oufqn == null) {
                this.m_oufqn = ouFqnCookie.getValue();
            }
            if ("null".equals(this.m_oufqn)) {
                this.m_oufqn = null;
            }
        }
    }

    @Override
    public String getFormLink() {
        if (this.getPreDefOuFqn() == null) {
            return super.getFormLink();
        }
        String preDefOuFqn = (String)this.getRequest().getAttribute(PARAM_PREDEF_OUFQN);
        try {
            OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCmsObject(), preDefOuFqn);
        }
        catch (CmsException e) {
            return super.getFormLink();
        }
        return this.link("/system/login" + CmsEncoder.escapeXml(preDefOuFqn));
    }

    public String getJsonOrgUnitList() {
        List<CmsOrganizationalUnit> allOus = this.getOus();
        ArrayList<JSONObject> jsonOus = new ArrayList<JSONObject>(allOus.size());
        int index = 0;
        for (CmsOrganizationalUnit ou : allOus) {
            JSONObject jsonObj = new JSONObject();
            try {
                jsonObj.put("name", ou.getName());
                jsonObj.put("displayname", ou.getDisplayName(this.m_locale));
                jsonObj.put("simplename", ou.getSimpleName());
                jsonObj.put("description", ou.getDescription(this.m_locale));
                boolean isSelected = false;
                if (ou.getName().equals(this.m_oufqn) || CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_oufqn) && ou.getName().equals(this.m_oufqn.substring(1))) {
                    isSelected = true;
                }
                jsonObj.put("active", isSelected);
                jsonObj.put("level", CmsResource.getPathLevel(ou.getName()));
                jsonObj.put("index", index);
                jsonOus.add(jsonObj);
                ++index;
            }
            catch (JSONException e) {}
        }
        JSONArray jsonArr = new JSONArray(jsonOus);
        return jsonArr.toString();
    }

    public void setCookieData() {
        Cookie userNameCookie;
        if (OpenCms.getLoginManager().isEnableSecurity() && CmsStringUtil.isNotEmpty(this.m_pcType)) {
            Cookie pcTypeCookie = this.getCookie(COOKIE_PCTYPE);
            pcTypeCookie.setValue(this.m_pcType);
            this.setCookie(pcTypeCookie, false);
        }
        if (PCTYPE_PRIVATE.equals(this.m_pcType)) {
            userNameCookie = this.getCookie(COOKIE_USERNAME);
            userNameCookie.setValue(this.m_username);
            this.setCookie(userNameCookie, false);
            Cookie ouFqnCookie = this.getCookie(COOKIE_OUFQN);
            ouFqnCookie.setValue(this.m_oufqn);
            this.setCookie(ouFqnCookie, false);
        } else if (OpenCms.getLoginManager().isEnableSecurity() && PCTYPE_PUBLIC.equals(this.m_pcType)) {
            userNameCookie = this.getCookie(COOKIE_USERNAME);
            this.setCookie(userNameCookie, true);
            Cookie ouFqnCookie = this.getCookie(COOKIE_OUFQN);
            this.setCookie(ouFqnCookie, true);
        }
    }

    protected void appendDefaultLoginScript(StringBuffer html, CmsMessageContainer message) {
        html.append("<script type=\"text/javascript\" src=\"");
        html.append(CmsWorkplace.getSkinUri()).append("jquery/packed/jquery.js");
        html.append("\"></script>\n");
        html.append("<script type=\"text/javascript\">\n");
        if (message != null) {
            html.append("function showAlert() {\n");
            html.append("\talert(\"");
            html.append(CmsStringUtil.escapeJavaScript(message.key(this.m_locale)));
            html.append("\");\n");
            html.append("}\n");
        }
        html.append("var orgUnitShow = false;\n");
        html.append("var orgUnits = null;\n");
        html.append("var activeOu = -1;\n");
        html.append("var searchTimeout;\n");
        html.append("var searchDefaultValue = \"");
        html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_ORGUNIT_SEARCH_0"));
        html.append("\";\n");
        html.append("function orgUnitSelection() {\n");
        html.append("\tif (!orgUnitShow) {\n");
        html.append("\t\tif (orgUnits == null) {\n");
        html.append("\t\t\t$.post(\"");
        html.append(this.getFormLink());
        html.append("\", { ");
        html.append(PARAM_ACTION_GETOULIST);
        html.append(": \"true\" }");
        html.append(", function(data){ fillOrgUnits(data); });\n");
        html.append("\t\t}\n");
        html.append("\t\tdocument.getElementById('ouSelId').style.display = 'block';\n");
        html.append("\t\tdocument.getElementById('ouLabelId').style.display = 'block';\n");
        html.append("\t\tdocument.getElementById('ouSearchId').style.display = 'block';\n");
        html.append("\t\tdocument.getElementById('ouBtnId').value = '");
        html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_ORGUNIT_SELECT_OFF_0"));
        html.append("';\n");
        html.append("\t} else {\n");
        html.append("\t\tdocument.getElementById('ouSelId').style.display = 'none';\n");
        html.append("\t\tdocument.getElementById('ouLabelId').style.display = 'none';\n");
        html.append("\t\tdocument.getElementById('ouSearchId').style.display = 'none';\n");
        html.append("\t\tdocument.getElementById('ouBtnId').value = '");
        html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_ORGUNIT_SELECT_ON_0"));
        html.append("';\n");
        html.append("\t}\n");
        html.append("\torgUnitShow = !orgUnitShow;\n");
        html.append("\tdocument.getElementById('titleId').style.display = 'block';\n");
        html.append("\tdocument.getElementById('titleIdOu').style.display = 'none';\n");
        html.append("}\n");
        html.append("function fillOrgUnits(data) {\n");
        html.append("\torgUnits = eval(data);\n");
        html.append("\tvar html = \"\";\n");
        html.append("\tvar foundOu = false;\n");
        html.append("\tvar activeIndex = -1;\n");
        html.append("\tfor (var i = 0; i < orgUnits.length; i++) {\n");
        html.append("\t\tvar currOu = orgUnits[i];\n");
        html.append("\t\tvar actClass = \"\";\n");
        html.append("\t\tif (currOu.active == true) {\n");
        html.append("\t\t\t// this is the active OU\n");
        html.append("\t\t\tactiveOu = currOu.index;\n");
        html.append("\t\t\tactClass = \" class=\\\"active\\\"\";\n");
        html.append("\t\t}\n");
        html.append("\t\tvar actStyle = \"\";\n");
        html.append("\t\tif (currOu.level > 0) {\n");
        html.append("\t\t\tactStyle = \" style=\\\"margin-left: \" + (currOu.level * 20) + \"px;\\\"\";\n");
        html.append("\t\t}\n");
        html.append("\t\thtml += \"<div\";\n");
        html.append("\t\thtml += actClass;\n");
        html.append("\t\thtml += actStyle;\n");
        html.append("\t\thtml += \" id=\\\"ou\" + currOu.index;\n");
        html.append("\t\thtml += \"\\\" onclick=\\\"selectOu('\";\n");
        html.append("\t\thtml += currOu.name;\n");
        html.append("\t\thtml += \"', \" + currOu.index;\n");
        html.append("\t\thtml += \");\\\"><span class=\\\"name\\\">\";\n");
        html.append("\t\thtml += currOu.description;\n");
        html.append("\t\thtml += \"</span>\";\n");
        html.append("\t\tif (currOu.name != \"\") {\n");
        html.append("\t\t\thtml += \"<span class=\\\"path\\\"\";\n");
        html.append("\t\t\thtml += \" title=\\\"\";\n");
        html.append("\t\t\thtml += currOu.name;\n");
        html.append("\t\t\thtml += \"\\\">\";\n");
        html.append("\t\t\thtml += currOu.simplename;\n");
        html.append("\t\t\thtml += \"</span>\";\n");
        html.append("\t\t}\n");
        html.append("\t\thtml += \"</div>\";\n");
        html.append("\t}\n");
        html.append("\thtml += \"<div id=\\\"nooufound\\\" style=\\\"display: none;\\\"><span class=\\\"name\\\">\";\n");
        html.append("\thtml += \"");
        html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_ORGUNIT_SEARCH_NORESULTS_0"));
        html.append("\";\n");
        html.append("\thtml += \"</span></div>\";\n");
        html.append("\t$(\"#ouSelId\").append(html);\n");
        html.append("\t$(\"#ouSelId\").slideDown();\n");
        html.append("\tscrollToActiveOu();\n");
        html.append("}\n");
        html.append("function showOrgUnits(searchTerm) {\n");
        html.append("\tvar html = \"\";\n");
        html.append("\tvar foundOu = false;\n");
        html.append("\tfor (var i = 0; i < orgUnits.length; i++) {\n");
        html.append("\t\tvar currOu = orgUnits[i];\n");
        html.append("\t\tif (searchTerm != \"\") {\n");
        html.append("\t\t\tvar stLower = searchTerm.toLowerCase();\n");
        html.append("\t\t\tif (currOu.name.toLowerCase().indexOf(stLower )== -1 && currOu.description.toLowerCase().indexOf(stLower) == -1) {\n");
        html.append("\t\t\t\t$(\"#ou\" + i + \":visible\").slideUp();\n");
        html.append("\t\t\t} else {\n");
        html.append("\t\t\t\t$(\"#ou\" + i + \":hidden\").slideDown();\n");
        html.append("\t\t\t\t$(\"#ou\" + i).removeAttr(\"style\");\n");
        html.append("\t\t\t\tfoundOu = true;\n");
        html.append("\t\t\t}\n");
        html.append("\t\t} else {\n");
        html.append("\t\t\tfoundOu = true;\n");
        html.append("\t\t\tvar actStyle = \"\";\n");
        html.append("\t\t\tif (currOu.level > 0) {\n");
        html.append("\t\t\t\tactStyle = \"margin-left: \" + (currOu.level * 20) + \"px;\";\n");
        html.append("\t\t\t}\n");
        html.append("\t\t\t$(\"#ou\" + i).attr(\"style\", actStyle);\n");
        html.append("\t\t\t$(\"#ou\" + i + \":hidden\").slideDown();\n");
        html.append("\t\t}\n");
        html.append("\t}\n");
        html.append("\tif (searchTerm != \"\" && foundOu == false) {\n");
        html.append("\t\t$(\"#nooufound:hidden\").slideDown();\n");
        html.append("\t} else {\n");
        html.append("\t\t$(\"#nooufound:visible\").slideUp();\n");
        html.append("\t}\n");
        html.append("\tif (searchTerm == \"\") {\n");
        html.append("\t\tscrollToActiveOu();\n");
        html.append("\t}\n");
        html.append("}\n");
        html.append("function selectOu(ouPath, ouIndex) {\n");
        html.append("\tif (ouIndex != -1 && ouIndex != activeOu) {\n");
        html.append("\t\t$(\"#ou\" + ouIndex).addClass(\"active\");\n");
        html.append("\t\torgUnits[ouIndex].active = true;\n");
        html.append("\t\t$(\"#");
        html.append(PARAM_OUFQN);
        html.append("\").val(ouPath);\n");
        html.append("\t\tif (activeOu != -1) {\n");
        html.append("\t\t\torgUnits[activeOu].active = false;\n");
        html.append("\t\t\t$(\"#ou\" + activeOu).removeClass();\n");
        html.append("\t\t}\n");
        html.append("\t\tactiveOu = ouIndex;\n");
        html.append("\t}\n");
        html.append("}\n");
        html.append("function searchOu() {\n");
        html.append("\tvar searchElem = $(\"#");
        html.append(PARAM_OUSEARCH);
        html.append("\");\n");
        html.append("\tvar searchTerm = searchElem.val();\n");
        html.append("\tif (searchTerm == searchDefaultValue) {");
        html.append("\t\tsearchTerm = \"\";");
        html.append("\t}");
        html.append("\tclearTimeout(searchTimeout);\n");
        html.append("\tsearchTimeout = setTimeout(\"showOrgUnits(\\\"\" + trim(searchTerm) + \"\\\");\", 750);\n");
        html.append("}\n");
        html.append("function checkOuValue() {\n");
        html.append("\tvar searchElem = $(\"#");
        html.append(PARAM_OUSEARCH);
        html.append("\");\n");
        html.append("\tif (searchElem.val() == searchDefaultValue) {");
        html.append("\t\tsearchElem.val(\"\");");
        html.append("\t\tsearchElem.removeAttr(\"class\");");
        html.append("\t} else if (searchElem.val() == \"\") {");
        html.append("\t\tsearchElem.val(searchDefaultValue);");
        html.append("\t\tsearchElem.attr(\"class\", \"inactive\");");
        html.append("\t}");
        html.append("}\n");
        html.append("function scrollToActiveOu() {\n");
        html.append("\tif (activeOu != -1) {\n");
        html.append("\t\tvar activeOffset = $(\"#ou\" + activeOu).offset().top;\n");
        html.append("\t\tvar parentOffset = $(\"#ouSelId\").offset().top;\n");
        html.append("\t\tactiveOffset = activeOffset - parentOffset;\n");
        html.append("\t\tif (activeOffset > $(\"#ouSelId\").height()) {;\n");
        html.append("\t\t\t$(\"#ouSelId\").animate({scrollTop: activeOffset}, 500);\n");
        html.append("\t\t};\n");
        html.append("\t}\n");
        html.append("}\n");
        html.append("function doOnload() {\n");
        html.append("\tdocument.");
        html.append(PARAM_FORM);
        html.append(".");
        html.append(PARAM_USERNAME);
        html.append(".select();\n");
        html.append("\tdocument.");
        html.append(PARAM_FORM);
        html.append(".");
        html.append(PARAM_USERNAME);
        html.append(".focus();\n");
        if (message != null) {
            html.append("\tshowAlert();\n");
        }
        html.append("}\n");
        html.append("function trim (myStr) {\n");
        html.append("\treturn myStr.replace(/^\\s+/, '').replace (/\\s+$/, '');\n");
        html.append("}\n");
        html.append("</script>\n");
    }

    protected void appendDirectEditOpenerScript(StringBuffer html) {
        html.append("<script type=\"text/javascript\">\n");
        html.append("function doOnload() {\n");
        html.append("window.name='preview';");
        html.append("window.location.replace('");
        html.append(this.link(this.m_directEditPath));
        html.append("');");
        html.append("}\n");
        html.append("</script>\n");
    }

    protected void appendId(StringBuffer html, String id) {
        html.append(" name=\"");
        html.append(id);
        html.append("\" id=\"");
        html.append(id);
        html.append("\" ");
    }

    protected void appendWorkplaceOpenerScript(StringBuffer html, String requestedResource, CmsMessageContainer message) {
        String[] winValues;
        CmsLoginMessage loginMessage;
        String winId = "OpenCms" + System.currentTimeMillis();
        html.append("<script type=\"text/javascript\">\n");
        html.append("function doOnload() {\n");
        if (message != null) {
            html.append("\talert(\"");
            html.append(CmsStringUtil.escapeJavaScript(message.key(this.m_locale)));
            html.append("\");\n");
        }
        if ((loginMessage = OpenCms.getLoginManager().getLoginMessage()) != null && loginMessage.isActive()) {
            String msg = loginMessage.isLoginForbidden() ? Messages.get().container("GUI_LOGIN_SUCCESS_WITH_MESSAGE_2", loginMessage.getMessage(), new Date(loginMessage.getTimeEnd())).key(this.m_locale) : loginMessage.getMessage();
            html.append("\talert(\"");
            html.append(CmsStringUtil.escapeJavaScript(msg));
            html.append("\");\n");
        }
        String openResource = requestedResource;
        CmsLoginUserAgreement agreementInfo = new CmsLoginUserAgreement(this);
        if (agreementInfo.isShowUserAgreement()) {
            openResource = agreementInfo.getConfigurationVfsPath() + "?" + "wpres" + "=" + requestedResource;
        }
        html.append("\tvar openUri = \"");
        html.append(this.link(openResource));
        html.append("\";\n");
        html.append("\tvar workplaceWin = openWorkplace(openUri, \"");
        html.append(winId);
        html.append("\");\n");
        html.append("\tif (window.name != \"");
        html.append(winId);
        html.append("\") {\n");
        html.append("\t\twindow.opener = workplaceWin;\n");
        html.append("\t\tif (workplaceWin != null) {\n");
        html.append("\t\t\twindow.close();\n");
        html.append("\t\t}\n");
        html.append("\t}\n");
        html.append("}\n");
        html.append("function openWorkplace(url, name) {\n");
        Cookie wpDataCookie = this.getCookie(COOKIE_WP_DATA);
        boolean useCookieData = false;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(wpDataCookie.getValue()) && (winValues = CmsStringUtil.splitAsArray(wpDataCookie.getValue(), '|')).length == 4) {
            useCookieData = true;
            html.append("\tvar winLeft = ").append(winValues[0]).append(";\n");
            html.append("\tvar winTop = ").append(winValues[1]).append(";\n");
            html.append("\tvar winWidth = ").append(winValues[2]).append(";\n");
            html.append("\tvar winHeight = ").append(winValues[3]).append(";\n");
        }
        if (!useCookieData) {
            html.append("\tvar isInWin = (window.name.match(/^OpenCms\\d+$/) != null);\n");
            html.append("\tvar winHeight = 0, winWidth = 0, winTop = 0, winLeft = 0;\n");
            html.append("\tif (window.innerHeight) {\n");
            html.append("\t\twinHeight = window.innerHeight;\n");
            html.append("\t\twinWidth = window.innerWidth;\n");
            html.append("\t} else if (document.documentElement && document.documentElement.clientHeight) {\n");
            html.append("\t\twinHeight = document.documentElement.clientHeight;\n");
            html.append("\t\twinWidth = document.documentElement.clientWidth;\n");
            html.append("\t} else if (document.body && document.body.clientHeight) {\n");
            html.append("\t\twinHeight = document.body.clientWidth;\n");
            html.append("\t\twinWidth = document.body.clientHeight;\n");
            html.append("\t}\n");
            html.append("\tif (window.screenY) {\n");
            html.append("\t\twinTop = window.screenY;\n");
            html.append("\t\twinLeft = window.screenX;\n");
            html.append("\t\tif (! isInWin) {\n");
            html.append("\t\t\twinTop += 25;\n");
            html.append("\t\t\twinLeft += 25;\n");
            html.append("\t\t}\n");
            html.append("\t} else if (window.screenTop) {\n");
            html.append("\t\twinTop = window.screenTop;\n");
            html.append("\t\twinLeft = window.screenLeft;\n");
            html.append("\t}\n");
            html.append("\n");
        }
        if (requestedResource.startsWith("/system/workplace/")) {
            html.append("\tvar openerStr = \"width=\" + winWidth + \",height=\" + winHeight + \",left=\" + winLeft + \",top=\" + winTop + \",scrollbars=no,location=no,toolbar=no,menubar=no,directories=no,status=yes,resizable=yes\";\n");
        } else {
            html.append("\tvar openerStr = \"width=\" + winWidth + \",height=\" + winHeight + \",left=\" + winLeft + \",top=\" + winTop + \",scrollbars=yes,location=yes,toolbar=yes,menubar=yes,directories=no,status=yes,resizable=yes\";\n");
        }
        html.append("\tvar OpenCmsWin = window.open(url, name, openerStr);\n");
        html.append("\n");
        html.append("\ttry{\n");
        html.append("\t\tif (! OpenCmsWin.opener) {\n");
        html.append("\t\t\tOpenCmsWin.opener = self;\n");
        html.append("\t\t}\n");
        html.append("\t\tif (OpenCmsWin.focus) {\n");
        html.append("\t\t\tOpenCmsWin.focus();\n");
        html.append("\t\t}\n");
        html.append("\t} catch (e) {}\n");
        html.append("\n");
        html.append("\treturn OpenCmsWin;\n");
        html.append("}\n");
        html.append("</script>\n");
    }

    protected String displayLoginForm() {
        StringBuffer html = new StringBuffer(8192);
        html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n");
        html.append("<html><head>\n");
        html.append("<title>");
        html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_TITLE_0"));
        html.append("OpenCms " + OpenCms.getSystemInfo().getVersionNumber());
        html.append("</title>\n");
        String encoding = this.getRequestContext().getEncoding();
        html.append("<meta HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=");
        html.append(encoding);
        html.append("\">\n");
        html.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        html.append(CmsWorkplace.getStyleUri(this, "workplace.css"));
        html.append("\">\n");
        html.append("<link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"");
        html.append(CmsWorkplace.getSkinUri()).append("commons/favicon.ico");
        html.append("\">\n");
        if (this.m_action == 0) {
            this.appendDefaultLoginScript(html, this.m_message);
        } else if (this.m_action == 1) {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_directEditPath)) {
                this.appendDirectEditOpenerScript(html);
            } else {
                this.appendWorkplaceOpenerScript(html, this.m_requestedResource, this.m_message);
            }
        }
        html.append("</head>\n");
        html.append("<body class=\"dialog\" onload=\"doOnload();\">\n");
        html.append("<div style=\"text-align: center; padding-top: 50px;\">");
        html.append("<img src=\"");
        html.append(CmsWorkplace.getResourceUri("commons/login_logo.png"));
        html.append("\" alt=\"OpenCms Logo\">");
        html.append("</div>\n");
        html.append("<table class=\"logindialog\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>\n");
        html.append("<table class=\"dialogbox\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>\n");
        html.append("<div class=\"dialoghead\">");
        if (this.m_oufqn == null) {
            this.m_oufqn = "/";
        }
        if (this.m_action == 0) {
            html.append("<div id='titleId'");
            if (!this.m_oufqn.equals("/")) {
                html.append(" style='display: none;'");
            }
            html.append(">\n");
            html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_HEADLINE_0"));
            html.append("</div>\n");
            html.append("<div id='titleIdOu'");
            if (this.m_oufqn.equals("/")) {
                html.append(" style='display: none;'");
            }
            html.append(">\n");
            html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_HEADLINE_SELECTED_ORGUNIT_1", this.m_ou.getDescription(this.getCmsObject().getRequestContext().getLocale())));
            html.append("</div>\n");
        } else if (this.m_action == 1) {
            html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_HEADLINE_ALREADY_IN_0"));
        }
        html.append("</div>\n");
        if (this.m_action == 0) {
            html.append("<form style=\"margin: 0px; padding: 0px;\" action=\"");
            html.append(this.getFormLink());
            html.append("\"");
            if (PCTYPE_PUBLIC.equals(this.m_pcType)) {
                html.append(" autocomplete=\"off\"");
            }
            this.appendId(html, PARAM_FORM);
            html.append("method=\"POST\">\n");
        }
        html.append("<div class=\"dialogcontent\">\n");
        html.append("<table border=\"0\">\n");
        if (this.m_action == 0 && OpenCms.getLoginManager().isEnableSecurity()) {
            html.append("<tr>\n");
            html.append("<td rowspan=\"2\">\n");
            html.append("</td>\n");
            html.append("<td colspan=\"2\" style=\"white-space: nowrap;\">\n");
            html.append("<div style=\"padding-bottom: 5px;\"><b>");
            html.append(CmsStringUtil.escapeHtml(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_SECURITY_0")));
            html.append("</b></div>\n");
            html.append("</td>\n");
            html.append("</tr>\n");
            html.append("<tr>\n");
            html.append("<td colspan=\"2\" style=\"white-space: nowrap;\">");
            html.append("<div class=\"loginsecurity\">");
            html.append("<input type=\"radio\" value=\"");
            html.append(PCTYPE_PUBLIC);
            html.append("\" name=\"");
            html.append(PARAM_PCTYPE);
            html.append("\"");
            if (PCTYPE_PUBLIC.equals(this.m_pcType)) {
                html.append(" checked=\"checked\"");
            }
            html.append(">&nbsp;");
            html.append(CmsStringUtil.escapeHtml(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_PCTYPE_PUBLIC_0")));
            html.append("<br/>");
            html.append("<input type=\"radio\" value=\"");
            html.append(PCTYPE_PRIVATE);
            html.append("\" name=\"");
            html.append(PARAM_PCTYPE);
            html.append("\"");
            if (PCTYPE_PRIVATE.equals(this.m_pcType)) {
                html.append(" checked=\"checked\"");
            }
            html.append(">&nbsp;");
            html.append(CmsStringUtil.escapeHtml(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_PCTYPE_PRIVATE_0")));
            html.append("</div></td>\n");
            html.append("</tr>\n");
        }
        html.append("<tr>\n");
        html.append("<td></td>\n<td colspan=\"2\" style=\"white-space: nowrap;\">\n");
        html.append("<div style=\"padding-bottom: 10px;\">");
        if (this.m_action == 0) {
            html.append(CmsStringUtil.escapeHtml(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_MESSAGE_0")));
        } else if (this.m_action == 1) {
            html.append(CmsStringUtil.escapeHtml(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_MESSAGE_ALREADY_IN_0")));
        }
        html.append("</div>\n");
        html.append("</td>\n");
        html.append("</tr>\n");
        html.append("<tr>\n");
        html.append("<td style=\"width: 60px; text-align: center; vertical-align: top\" rowspan=\"5\">");
        html.append("<img src=\"");
        html.append(CmsWorkplace.getResourceUri("commons/login.png"));
        html.append("\" height=\"48\" width=\"48\" alt=\"\">");
        html.append("</td>\n");
        html.append("<td style=\"white-space: nowrap;\"><b>");
        html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_USERNAME_0"));
        html.append("</b>&nbsp;&nbsp;</td>\n");
        html.append("<td style=\"width: 300px; white-space: nowrap;\">");
        if (this.m_action == 0) {
            html.append("<input style=\"width: 300px;\" type=\"text\"");
            if (PCTYPE_PUBLIC.equals(this.m_pcType)) {
                html.append(" autocomplete=\"off\"");
            }
            this.appendId(html, PARAM_USERNAME);
            html.append("value=\"");
            html.append(CmsStringUtil.isEmpty(this.m_username) || PCTYPE_PUBLIC.equals(this.m_pcType) ? "" : CmsEncoder.escapeXml(this.m_username));
            html.append("\">");
        } else if (this.m_action == 1) {
            html.append(this.getRequestContext().getCurrentUser().getFullName());
        }
        html.append("</td>\n");
        html.append("</tr>\n");
        if (this.m_action == 0) {
            html.append("<tr>\n");
            html.append("<td style=\"white-space: nowrap;\"><b>");
            html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_PASSWORD_0"));
            html.append("</b>&nbsp;&nbsp;</td>\n");
            html.append("<td style=\"width: 300px; white-space: nowrap;\">");
            html.append("<input style=\"width: 300px;\" type=\"password\"");
            if (PCTYPE_PUBLIC.equals(this.m_pcType)) {
                html.append(" autocomplete=\"off\"");
            }
            this.appendId(html, PARAM_PASSWORD);
            html.append(">");
            html.append("</td>\n");
            html.append("</tr>\n");
            html.append("<tr>\n");
            html.append("<td style=\"white-space: nowrap;\"><div id='ouLabelId' style='display: none;'><b>");
            html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_ORGUNIT_0")).append("</b>&nbsp;&nbsp;\n");
            html.append("</div></td>\n");
            html.append("<td style=\"width: 300px; white-space: nowrap;\"><div id='ouSearchId' style='display: none;'><input class=\"inactive\" style=\"width: 300px;\" type=\"text\" value=\"");
            html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_ORGUNIT_SEARCH_0"));
            html.append("\"");
            this.appendId(html, PARAM_OUSEARCH);
            html.append(" onfocus=\"checkOuValue();\"");
            html.append(" onblur=\"checkOuValue();\"");
            html.append(" onkeyup=\"searchOu();\"");
            html.append("/>");
            html.append("<input type=\"hidden\" value=\"");
            html.append(this.m_oufqn == null ? "" : this.m_oufqn);
            html.append("\"");
            this.appendId(html, PARAM_OUFQN);
            html.append("/>");
            html.append("</div></td>\n");
            html.append("</tr>\n");
            html.append("<tr>\n");
            html.append("<td colspan=\"2\"><div id='ouSelId' style='display: none;'>");
            html.append("</div></td>\n");
            html.append("</tr>\n");
            html.append("<tr>\n");
            html.append("<td>\n");
            html.append("</td>\n");
            html.append("<td style=\"white-space: nowrap;\">\n");
            html.append("<input type=\"hidden\"");
            this.appendId(html, PARAM_ACTION_LOGIN);
            html.append("value=\"true\">\n");
            if (this.m_requestedResource != null) {
                html.append("<input type=\"hidden\"");
                this.appendId(html, "requestedResource");
                html.append("value=\"");
                html.append(CmsEncoder.escapeXml(this.m_requestedResource));
                html.append("\">\n");
            }
            html.append("<input class=\"loginbutton\" type=\"submit\" value=\"");
            html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_BUTTON_0"));
            html.append("\">\n");
            if (this.getOus().size() > 1 && (this.getPreDefOuFqn() == null || this.getPreDefOuFqn().equals("/"))) {
                html.append("&nbsp;<input id='ouBtnId' class='loginbutton' type='button' value='");
                html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_ORGUNIT_SELECT_ON_0"));
                html.append("' onclick='javascript:orgUnitSelection();'>\n");
            }
            html.append("</td>\n");
            html.append("</tr>\n");
        } else if (this.m_action == 1) {
            html.append("<tr><td></td><td></td></tr>\n");
            html.append("<tr>\n");
            html.append("<td></td>\n");
            html.append("<td style=\"width:100%; white-space: nowrap;\">\n");
            html.append("<input class=\"loginbutton\" type=\"button\" value=\"");
            html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_BUTTON_ALREADY_IN_0"));
            html.append("\" onclick=\"doOnload()\">\n");
            html.append("</td>\n");
            html.append("</tr>\n");
        }
        html.append("</table>\n");
        html.append("</div>");
        if (this.m_action == 0) {
            html.append("</form>\n");
        }
        html.append("</td></tr></table>\n");
        html.append("</td></tr></table>\n");
        html.append("<div style=\"text-align: center; font-size: 10px; white-space: nowrap;\">");
        html.append("<a href=\"http://www.opencms.org\" target=\"_blank\">OpenCms</a> ");
        html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_OPENCMS_IS_FREE_SOFTWARE_0"));
        html.append("</div>\n");
        html.append("<div style=\"text-align: center; font-size: 10px; white-space: nowrap;\">");
        html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_TRADEMARKS_0"));
        html.append("</div>\n");
        html.append("<div style=\"text-align: center; font-size: 10px; white-space: nowrap;\">");
        html.append("&copy; 2002 - 2013 Alkacon Software GmbH. ");
        html.append(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_RIGHTS_RESERVED_0"));
        html.append("</div>\n");
        html.append("<noscript>\n");
        html.append("<div style=\"text-align: center; font-size: 14px; border: 2px solid black; margin: 50px; padding: 20px; background-color: red; color: white; white-space: nowrap;\"><b>");
        html.append(CmsStringUtil.escapeHtml(Messages.get().getBundle(this.m_locale).key("GUI_LOGIN_NOSCRIPT_1", OpenCms.getSiteManager().getWorkplaceSiteMatcher())));
        html.append("</b></div>\n");
        html.append("</noscript>\n");
        html.append("</body></html>");
        return html.toString();
    }

    protected Cookie getCookie(String name) {
        Cookie[] cookies = this.getRequest().getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
            return cookies[i];
        }
        return new Cookie(name, "");
    }

    protected List<CmsOrganizationalUnit> getOus() {
        if (this.m_ous == null) {
            this.m_ous = new ArrayList<CmsOrganizationalUnit>();
            try {
                if (this.getPreDefOuFqn() == null) {
                    this.m_ous.add(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCmsObject(), ""));
                    this.m_ous.addAll(OpenCms.getOrgUnitManager().getOrganizationalUnits(this.getCmsObject(), "", true));
                    Iterator<CmsOrganizationalUnit> itOus = this.m_ous.iterator();
                    while (itOus.hasNext()) {
                        CmsOrganizationalUnit ou = itOus.next();
                        if (!ou.hasFlagHideLogin() && !ou.hasFlagWebuser()) continue;
                        itOus.remove();
                    }
                } else {
                    this.m_ous.add(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCmsObject(), this.m_oufqn));
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.m_ous;
    }

    protected String getPreDefOuFqn() {
        if (Boolean.valueOf(this.m_actionLogout).booleanValue() && this.getRequest().getAttribute(PARAM_PREDEF_OUFQN) == null) {
            String oufqn = this.getCmsObject().getRequestContext().getOuFqn();
            if (!oufqn.startsWith("/")) {
                oufqn = "/" + oufqn;
            }
            this.getRequest().setAttribute(PARAM_PREDEF_OUFQN, (Object)oufqn);
        }
        return (String)this.getRequest().getAttribute(PARAM_PREDEF_OUFQN);
    }

    protected void setCookie(Cookie cookie, boolean delete) {
        if (this.getRequest().getAttribute(PARAM_PREDEF_OUFQN) != null) {
            return;
        }
        int maxAge = 0;
        if (!delete) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(2, 6);
            maxAge = (int)((cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L);
        }
        cookie.setMaxAge(maxAge);
        cookie.setPath(this.link("/system/login"));
        this.getResponse().addCookie(cookie);
    }

    private String getDirectEditPath(CmsUserSettings userSettings) {
        if (userSettings.getStartView().equals("/system/workplace/views/explorer/directEdit.jsp")) {
            try {
                String folder;
                CmsResource targetRes;
                CmsObject cloneCms = OpenCms.initCmsObject(this.getCmsObject());
                cloneCms.getRequestContext().setSiteRoot(userSettings.getStartSite());
                String projectName = userSettings.getStartProject();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(projectName)) {
                    cloneCms.getRequestContext().setCurrentProject(cloneCms.readProject(projectName));
                }
                if ((targetRes = cloneCms.readDefaultFile(folder = userSettings.getStartFolder())) != null) {
                    return cloneCms.getSitePath(targetRes);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
        }
        return null;
    }
}

