/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workflow;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsPublish;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.CmsPublishResourceInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.workflow.Messages;

public class CmsRelease
extends CmsPublish {
    protected static final Log LOG = CmsLog.getLog(CmsPublish.class);
    private Map<CmsUUID, Boolean> m_workflowProjectStatus = new MapMaker().makeComputingMap((Function)new Function<CmsUUID, Boolean>(){

        public Boolean apply(CmsUUID projectId) {
            try {
                CmsProject project = CmsRelease.this.m_cms.readProject(projectId);
                return new Boolean(project.isWorkflowProject());
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return Boolean.FALSE;
            }
        }
    });

    public CmsRelease(CmsObject cms) {
        super(cms);
    }

    public CmsRelease(CmsObject cms, CmsPublishOptions options) {
        super(cms, options);
    }

    @Override
    public List<CmsPublishResource> getPublishResourceBeans(CmsPublish.ResourcesAndRelated rawPublishResources) {
        Set<CmsResource> published = this.getAlreadyPublishedResources(rawPublishResources);
        HashSet<CmsResource> exclude = new HashSet<CmsResource>(published);
        CmsPublish.ResourcesAndRelated locked = this.getBlockingLockedResources(rawPublishResources, exclude);
        exclude.clear();
        exclude.addAll(published);
        exclude.addAll(locked.getResources());
        CmsPublish.ResourcesAndRelated pubResources = new CmsPublish.ResourcesAndRelated();
        pubResources.getResources().addAll(rawPublishResources.getResources());
        pubResources.getResources().removeAll(exclude);
        pubResources.getRelatedResources().addAll(rawPublishResources.getRelatedResources());
        pubResources.getRelatedResources().removeAll(locked.getRelatedResources());
        ArrayList<CmsResource> resourcesWithoutTempfiles = new ArrayList<CmsResource>();
        for (CmsResource res : rawPublishResources.getResources()) {
            if (CmsResource.isTemporaryFileName(res.getRootPath())) continue;
            resourcesWithoutTempfiles.add(res);
        }
        HashSet<CmsResource> allPubRes = new HashSet<CmsResource>(pubResources.getRelatedResources());
        allPubRes.addAll(pubResources.getResources());
        ArrayList<CmsResource> pubList = new ArrayList();
        try {
            pubList = OpenCms.getPublishManager().getUsersPubList(this.m_cms);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        ArrayList<CmsPublishResource> publishResources = new ArrayList<CmsPublishResource>();
        for (CmsResource resource : resourcesWithoutTempfiles) {
            CmsPublishResource pubRes = this.createPublishResource(resource, pubList, allPubRes, published, new CmsPublish.ResourcesAndRelated(), locked);
            publishResources.add(pubRes);
        }
        return publishResources;
    }

    protected String getMessage(String key, String ... args) {
        return Messages.get().getBundle(this.m_cms.getRequestContext().getLocale()).key(key, args);
    }

    @Override
    protected List<CmsResource> getRawPublishResources() throws CmsException {
        ArrayList<CmsResource> rawResourceList = new ArrayList<CmsResource>();
        if (this.m_options.getProjectId() == null || this.m_options.getProjectId().isNullUUID()) {
            rawResourceList.addAll(OpenCms.getPublishManager().getUsersPubList(this.m_cms));
        } else {
            rawResourceList.addAll(this.m_cms.readProjectView(this.m_options.getProjectId(), CmsResource.STATE_KEEP));
        }
        return rawResourceList;
    }

    @Override
    protected CmsPublishResourceInfo getResourceInfo(CmsResource resource, Set<CmsResource> published, CmsPublish.ResourcesAndRelated permissions, CmsPublish.ResourcesAndRelated locked) {
        CmsUUID projectId;
        CmsPublishResourceInfo info = super.getResourceInfo(resource, published, permissions, locked);
        if (info == null && this.isWorkflowProject(projectId = resource.getProjectLastModified())) {
            info = new CmsPublishResourceInfo(this.getMessage("GUI_ALREADY_IN_WORKFLOW_0", new String[0]), CmsPublishResourceInfo.Type.WORKFLOW);
        }
        return info;
    }

    private boolean isWorkflowProject(CmsUUID projectId) {
        return this.m_workflowProjectStatus.get(projectId);
    }
}

