/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsSelectGroupWidget
extends CmsSelectWidget {
    protected static final String CONFIGURATION_GROUPFILTER = "groupfilter";
    protected static final String CONFIGURATION_GROUPS = "groups";
    protected static final String CONFIGURATION_INCLUDESUBOUS = "includesubous";
    protected static final String CONFIGURATION_OUFQN = "oufqn";
    private static final Log LOG = CmsLog.getLog(CmsSelectGroupWidget.class);
    Pattern m_groupFilter;
    List<String> m_groupNames;
    private boolean m_includeSubOus;
    private String m_ouFqn;

    public CmsSelectGroupWidget() {
    }

    public CmsSelectGroupWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        this.parseSelectOptions(cms, messages, (I_CmsWidgetParameter)schemaType);
        String results = this.getConfiguration();
        return results;
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsSelectGroupWidget(this.getConfiguration());
    }

    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, CmsMessages messages, I_CmsWidgetParameter param) {
        if (this.getSelectOptions() == null) {
            this.parseConfiguration(cms, messages);
            ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
            if (this.isUseGroupNames()) {
                for (String groupName : this.getGroupNames()) {
                    try {
                        CmsGroup group = cms.readGroup(this.getOuFqn() + groupName);
                        result.add(new CmsSelectWidgetOption(group.getName(), false, group.getSimpleName()));
                    }
                    catch (CmsException e) {}
                }
            } else {
                try {
                    List<CmsGroup> groups = OpenCms.getOrgUnitManager().getGroups(cms, this.getOuFqn(), this.isIncludeSubOus());
                    for (CmsGroup group : groups) {
                        if (this.isUseGroupFilter() && !this.getGroupFilter().matcher(group.getSimpleName()).matches()) continue;
                        result.add(new CmsSelectWidgetOption(group.getName(), false, group.getSimpleName()));
                    }
                }
                catch (CmsException e) {
                    // empty catch block
                }
            }
            this.setSelectOptions(result);
        }
        return this.getSelectOptions();
    }

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        return this.parseSelectOptions(cms, widgetDialog.getMessages(), param);
    }

    private Pattern getGroupFilter() {
        return this.m_groupFilter;
    }

    private List<String> getGroupNames() {
        return this.m_groupNames;
    }

    private String getOuFqn() {
        return this.m_ouFqn;
    }

    private boolean isIncludeSubOus() {
        return this.m_includeSubOus;
    }

    private boolean isUseGroupFilter() {
        return this.getGroupFilter() != null;
    }

    private boolean isUseGroupNames() {
        return this.getGroupNames() != null;
    }

    private void parseConfiguration(CmsObject cms, CmsMessages widgetDialog) {
        String configString = "";
        if (widgetDialog != null) {
            String filter;
            configString = CmsMacroResolver.resolveMacros(this.getConfiguration(), cms, widgetDialog);
            Map<String, String> config = CmsStringUtil.splitAsMap(configString, "|", "=");
            String groups = config.get(CONFIGURATION_GROUPS);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(groups)) {
                this.m_groupNames = CmsStringUtil.splitAsList(groups, ',', true);
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(filter = config.get(CONFIGURATION_GROUPFILTER))) {
                try {
                    this.m_groupFilter = Pattern.compile(filter);
                }
                catch (PatternSyntaxException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_WIDGET_SELECTGROUP_PATTERN_1", filter));
                }
            }
            this.m_ouFqn = config.get(CONFIGURATION_OUFQN);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_ouFqn)) {
                this.m_ouFqn = "";
            } else if (!this.m_ouFqn.endsWith("/")) {
                this.m_ouFqn = this.m_ouFqn + "/";
            }
            this.m_includeSubOus = Boolean.valueOf(config.get(CONFIGURATION_INCLUDESUBOUS));
        }
    }
}

