/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsHtmlWidget;
import org.opencms.widgets.CmsHtmlWidgetOption;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.editors.CmsEditorDisplayOptions;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsHtmlWidget
extends A_CmsHtmlWidget
implements I_CmsADEWidget {
    private static final Log LOG = CmsLog.getLog(CmsHtmlWidget.class);
    private I_CmsWidget m_editorWidget;

    public CmsHtmlWidget() {
        this("");
    }

    public CmsHtmlWidget(CmsHtmlWidgetOption configuration) {
        super(configuration);
    }

    public CmsHtmlWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        return this.getJSONConfiguration(cms, resource).toString();
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getEditorWidget(cms, widgetDialog).getDialogIncludes(cms, widgetDialog);
    }

    @Override
    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getEditorWidget(cms, widgetDialog).getDialogInitCall(cms, widgetDialog);
    }

    @Override
    public String getDialogInitMethod(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getEditorWidget(cms, widgetDialog).getDialogInitMethod(cms, widgetDialog);
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        return this.getEditorWidget(cms, widgetDialog).getDialogWidget(cms, widgetDialog, param);
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return CmsHtmlWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsHtmlWidget(this.getConfiguration());
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            String val = CmsEncoder.decode(values[0], "UTF-8");
            param.setStringValue(cms, val);
        }
    }

    protected JSONObject getJSONConfiguration(CmsObject cms, CmsResource resource) {
        JSONObject result = new JSONObject();
        CmsEditorDisplayOptions options = OpenCms.getWorkplaceManager().getEditorDisplayOptions();
        Properties displayOptions = options.getDisplayOptions(cms);
        try {
            String formatSelectOptions;
            if (options.showElement("gallery.enhancedoptions", displayOptions)) {
                result.put("cmsGalleryEnhancedOptions", true);
            }
            if (options.showElement("gallery.usethickbox", displayOptions)) {
                result.put("cmsGalleryUseThickbox", true);
            }
            result.put("fullpage", this.getHtmlWidgetOption().isFullPage());
            List<String> toolbarItems = this.getHtmlWidgetOption().getButtonBarShownItems();
            result.put("toolbar_items", toolbarItems);
            result.put("language", OpenCms.getWorkplaceManager().getWorkplaceLocale(cms).getLanguage());
            String editorHeight = this.getHtmlWidgetOption().getEditorHeight();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(editorHeight)) {
                editorHeight = editorHeight.replaceAll("px", "");
                result.put("height", editorHeight);
            }
            boolean cssConfigured = false;
            String cssPath = "";
            if (this.getHtmlWidgetOption().useCss()) {
                cssPath = this.getHtmlWidgetOption().getCssPath();
                this.getHtmlWidgetOption().setCssPath(null);
                cssConfigured = true;
            } else if (OpenCms.getWorkplaceManager().getEditorCssHandlers().size() > 0) {
                Iterator<I_CmsEditorCssHandler> i = OpenCms.getWorkplaceManager().getEditorCssHandlers().iterator();
                try {
                    String editedResourceSitePath;
                    String string = editedResourceSitePath = resource == null ? null : cms.getSitePath(resource);
                    while (i.hasNext()) {
                        I_CmsEditorCssHandler handler = i.next();
                        if (!handler.matches(cms, editedResourceSitePath)) continue;
                        cssPath = handler.getUriStyleSheet(cms, editedResourceSitePath);
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(cssPath)) {
                            cssConfigured = true;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cssConfigured) {
                result.put("content_css", OpenCms.getLinkManager().substituteLink(cms, cssPath));
            }
            if (this.getHtmlWidgetOption().showStylesFormat()) {
                try {
                    CmsFile file = cms.readFile(this.getHtmlWidgetOption().getStylesFormatPath());
                    String characterEncoding = OpenCms.getSystemInfo().getDefaultEncoding();
                    result.put("style_formats", new String(file.getContents(), characterEncoding));
                }
                catch (CmsException cmsException) {
                    LOG.error((Object)("Can not open file:" + this.getHtmlWidgetOption().getStylesFormatPath()), (Throwable)cmsException);
                }
                catch (UnsupportedEncodingException ex) {
                    LOG.error((Object)ex);
                }
            }
            if (!CmsStringUtil.isEmpty(formatSelectOptions = this.getHtmlWidgetOption().getFormatSelectOptions()) && !this.getHtmlWidgetOption().isButtonHidden("formatselect")) {
                formatSelectOptions = StringUtils.replace((String)formatSelectOptions, (String)";", (String)",");
                result.put("block_formats", formatSelectOptions);
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    private I_CmsWidget getEditorWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        if (this.m_editorWidget == null) {
            String widgetClassName = OpenCms.getWorkplaceManager().getWorkplaceEditorManager().getWidgetEditor(cms.getRequestContext(), widgetDialog.getUserAgent());
            boolean foundWidget = true;
            if (CmsStringUtil.isEmpty(widgetClassName)) {
                widgetClassName = CmsTextareaWidget.class.getName();
                foundWidget = false;
            }
            try {
                if (foundWidget) {
                    Class<?> widgetClass = Class.forName(widgetClassName);
                    A_CmsHtmlWidget editorWidget = (A_CmsHtmlWidget)widgetClass.newInstance();
                    editorWidget.setHtmlWidgetOption(this.getHtmlWidgetOption());
                    this.m_editorWidget = editorWidget;
                } else {
                    Class<?> widgetClass = Class.forName(widgetClassName);
                    I_CmsWidget editorWidget = (I_CmsWidget)widgetClass.newInstance();
                    editorWidget.setConfiguration("15");
                    this.m_editorWidget = editorWidget;
                }
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().container("LOG_CREATE_HTMLWIDGET_INSTANCE_FAILED_1", widgetClassName).key());
            }
        }
        return this.m_editorWidget;
    }
}

