/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsCategoryWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    public static final String CONFIGURATION_CATEGORY = "category";
    public static final String CONFIGURATION_ONLYLEAFS = "onlyleafs";
    public static final String CONFIGURATION_PROPERTY = "property";
    private static final String CONFIGURATION_SELECTIONTYPE = "selectiontype";
    private static final String CONFIGURATION_PARENTSELECTION = "parentSelection";
    private static final Log LOG = CmsLog.getLog(CmsCategoryWidget.class);
    private String m_category;
    private String m_onlyLeafs;
    private String m_property;
    private String m_selectiontype = "single";
    private boolean m_parentSelection;

    public CmsCategoryWidget() {
    }

    public CmsCategoryWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration() {
        StringBuffer result = new StringBuffer(8);
        if (this.m_category != null) {
            result.append(CONFIGURATION_CATEGORY);
            result.append("=");
            result.append(this.m_category);
        }
        if (this.m_onlyLeafs != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_ONLYLEAFS);
            result.append("=");
            result.append(this.m_onlyLeafs);
        }
        if (this.m_property != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_PROPERTY);
            result.append("=");
            result.append(this.m_property);
        }
        return result.toString();
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        String result = this.getConfiguration();
        this.m_selectiontype = schemaType.getTypeName().equals("OpenCmsCategory") ? "multi" : "single";
        if (this.m_selectiontype != null) {
            if (result.length() > 0) {
                result = result + "|";
            }
            result = result + CONFIGURATION_SELECTIONTYPE;
            result = result + "=";
            result = result + this.m_selectiontype;
        }
        if (this.m_parentSelection) {
            if (result.length() > 0) {
                result = result + "|";
            }
            result = result + CONFIGURATION_PARENTSELECTION;
        }
        CmsCategoryService catService = CmsCategoryService.getInstance();
        List<String> categoriesList = catService.getCategoryRepositories(cms, cms.getSitePath(resource));
        Iterator<String> it = categoriesList.iterator();
        String catList = "|CategoryList=";
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                catList = catList + ",";
            }
            String rootPath = it.next();
            catList = catList + rootPath;
            ++i;
        }
        return result + catList;
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append("<script type=\"text/javascript\" src=\"");
        result.append(CmsWorkplace.getSkinUri());
        result.append("components/widgets/category.js\"></script>\n");
        return result.toString();
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        CmsCategory selected = null;
        try {
            String name = param.getStringValue(cms);
            selected = CmsCategoryService.getInstance().getCategory(cms, name);
        }
        catch (CmsException e) {
            // empty catch block
        }
        StringBuffer result = new StringBuffer(16);
        ArrayList levels = new ArrayList();
        try {
            int baseLevel;
            result.append("<script language='javascript'>\n");
            String referencePath = null;
            try {
                referencePath = cms.getSitePath(this.getResource(cms, param));
            }
            catch (Exception e) {
                // empty catch block
            }
            String startingCat = this.getStartingCategory(cms, referencePath);
            List<CmsCategory> cats = CmsCategoryService.getInstance().readCategories(cms, startingCat, true, referencePath);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(startingCat)) {
                baseLevel = 0;
            } else {
                baseLevel = CmsResource.getPathLevel(startingCat);
                if (!startingCat.startsWith("/") || !startingCat.endsWith("/")) {
                    ++baseLevel;
                }
            }
            HashSet<String> done = new HashSet<String>();
            List<CmsSelectWidgetOption> options = new ArrayList<CmsSelectWidgetOption>();
            String jsId = CmsStringUtil.substitute(param.getId(), ".", "");
            int level = baseLevel + 1;
            while (!cats.isEmpty()) {
                if (level != baseLevel + 1) {
                    result.append("var cat" + (level - baseLevel) + jsId + " = new Array(\n");
                }
                Iterator<CmsCategory> itSubs = cats.iterator();
                while (itSubs.hasNext()) {
                    CmsCategory cat = itSubs.next();
                    String title = cat.getTitle();
                    String titleJs = StringEscapeUtils.escapeJavaScript((String)title);
                    String titleHtml = StringEscapeUtils.escapeHtml((String)title);
                    if (CmsResource.getPathLevel(cat.getPath()) + 1 != level) continue;
                    itSubs.remove();
                    if (done.contains(cat.getPath())) continue;
                    if (level != baseLevel + 1) {
                        result.append("new Array('" + cat.getId() + "', '" + CmsCategoryService.getInstance().readCategory(cms, CmsResource.getParentFolder(cat.getPath()), referencePath).getId() + "', '" + titleJs + "'),\n");
                    }
                    if (level == baseLevel + 1 || selected != null && selected.getPath().startsWith(CmsResource.getParentFolder(cat.getPath()))) {
                        if (levels.size() < level - baseLevel) {
                            options = new ArrayList();
                            levels.add(options);
                            options.add(new CmsSelectWidgetOption("", true, Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_CATEGORY_SELECT_0")));
                        }
                        options.add(new CmsSelectWidgetOption(cat.getId().toString(), false, titleHtml));
                    }
                    done.add(cat.getPath());
                }
                if (level != baseLevel + 1) {
                    result.deleteCharAt(result.length() - 1);
                    result.deleteCharAt(result.length() - 1);
                    result.append(");\n");
                }
                ++level;
            }
            result.append("</script>\n");
            result.append("<td class=\"xmlTd\" >");
            result.append("<input id='" + param.getId() + "' name='" + param.getId() + "' type='hidden' value='" + (selected != null ? selected.getId().toString() : "") + "'>\n");
            for (int i = 1; i < level - baseLevel; ++i) {
                result.append("<span id='" + param.getId() + "cat" + i + "IdDisplay'");
                if (levels.size() >= i) {
                    options = (List)levels.get(i - 1);
                } else {
                    result.append(" style='display:none'");
                    options = new ArrayList();
                    options.add(new CmsSelectWidgetOption("", true, Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_CATEGORY_SELECT_0")));
                }
                result.append(">");
                result.append(this.buildSelectBox(param.getId(), i, options, selected != null ? CmsCategoryService.getInstance().readCategory(cms, CmsResource.getPathPart(selected.getPath(), i + baseLevel), referencePath).getId().toString() : "", param.hasError(), i == level - baseLevel - 1));
                result.append("</span>&nbsp;");
            }
            result.append("</td>");
        }
        catch (CmsException e) {
            result.append(e.getLocalizedMessage());
        }
        return result.toString();
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return CmsCategoryWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    public boolean isOnlyLeafs() {
        return Boolean.valueOf(this.m_onlyLeafs);
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsCategoryWidget(this.getConfiguration());
    }

    @Override
    public void setConfiguration(String configuration) {
        this.m_category = "";
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration)) {
            int propertyIndex;
            int parentSelectionIndex;
            int onlyLeafsIndex;
            int categoryIndex = configuration.indexOf(CONFIGURATION_CATEGORY);
            if (categoryIndex != -1) {
                String category = configuration.substring(CONFIGURATION_CATEGORY.length() + 1);
                if (category.indexOf(124) != -1) {
                    category = category.substring(0, category.indexOf(124));
                }
                this.m_category = category;
            }
            if ((onlyLeafsIndex = configuration.indexOf(CONFIGURATION_ONLYLEAFS)) != -1) {
                String onlyLeafs = configuration.substring(onlyLeafsIndex + CONFIGURATION_ONLYLEAFS.length() + 1);
                if (onlyLeafs.indexOf(124) != -1) {
                    onlyLeafs = onlyLeafs.substring(0, onlyLeafs.indexOf(124));
                }
                this.m_onlyLeafs = onlyLeafs;
            }
            if ((parentSelectionIndex = configuration.indexOf(CONFIGURATION_PARENTSELECTION)) != -1) {
                this.m_parentSelection = true;
            }
            if ((propertyIndex = configuration.indexOf(CONFIGURATION_PROPERTY)) != -1) {
                String property = configuration.substring(propertyIndex + CONFIGURATION_PROPERTY.length() + 1);
                if (property.indexOf(124) != -1) {
                    property = property.substring(0, property.indexOf(124));
                }
                this.m_property = property;
            }
        }
        super.setConfiguration(configuration);
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        super.setEditorValue(cms, formParameters, widgetDialog, param);
        String id = param.getStringValue(cms);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(id)) {
            return;
        }
        try {
            CmsCategory cat = CmsCategoryService.getInstance().getCategory(cms, cms.readResource(new CmsUUID(id)));
            String referencePath = null;
            try {
                referencePath = cms.getSitePath(this.getResource(cms, param));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (cat.getPath().startsWith(this.getStartingCategory(cms, referencePath))) {
                param.setStringValue(cms, cat.getRootPath());
            } else {
                param.setStringValue(cms, "");
            }
        }
        catch (CmsException e) {
            param.setStringValue(cms, "");
        }
    }

    protected String buildSelectBox(String baseId, int level, List<CmsSelectWidgetOption> options, String selected, boolean hasError, boolean last) {
        StringBuffer result = new StringBuffer(16);
        String id = baseId + "cat" + level + "Id";
        String childId = baseId + "cat" + (level + 1) + "Id";
        result.append("<select class=\"xmlInput");
        if (hasError) {
            result.append(" xmlInputError");
        }
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" onchange=\"");
        if (last) {
            result.append("setWidgetValue('" + baseId + "');");
        } else {
            String jsId = CmsStringUtil.substitute(baseId, ".", "");
            result.append("setChildListBox(this, getElemById('" + childId + "'), cat" + (level + 1) + jsId + ");");
        }
        result.append("\">");
        for (CmsSelectWidgetOption option : options) {
            result.append("<option value=\"");
            result.append(option.getValue());
            result.append("\"");
            if (selected != null && selected.equals(option.getValue())) {
                result.append(" selected=\"selected\"");
            }
            result.append(">");
            result.append(option.getOption());
            result.append("</option>");
        }
        result.append("</select>");
        return result.toString();
    }

    protected Locale getDefaultLocale(CmsObject cms, String resource) {
        Locale locale = OpenCms.getLocaleManager().getDefaultLocale(cms, resource);
        if (locale == null) {
            List<Locale> locales = OpenCms.getLocaleManager().getAvailableLocales();
            locale = locales.size() > 0 ? locales.get(0) : Locale.ENGLISH;
        }
        return locale;
    }

    protected CmsResource getResource(CmsObject cms, I_CmsWidgetParameter param) {
        CmsFile file;
        block6: {
            I_CmsXmlContentValue value = (I_CmsXmlContentValue)((Object)param);
            file = value.getDocument().getFile();
            String resourceName = cms.getSitePath(file);
            if (CmsWorkplace.isTemporaryFile(file)) {
                StringBuffer result = new StringBuffer(resourceName.length() + 2);
                result.append(CmsResource.getFolderPath(resourceName));
                result.append(CmsResource.getName(resourceName).substring(1));
                resourceName = result.toString();
            }
            try {
                List<CmsResource> listsib = cms.readSiblings(resourceName, CmsResourceFilter.ALL);
                for (int i = 0; i < listsib.size(); ++i) {
                    CmsResource resource = listsib.get(i);
                    Locale locale = this.getDefaultLocale(cms, cms.getSitePath(resource));
                    if (!locale.equals(value.getLocale())) continue;
                    return resource;
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return file;
    }

    protected String getStartingCategory(CmsObject cms, String referencePath) {
        String ret;
        block9: {
            ret = "";
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_category) && CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_property)) {
                ret = "/";
            } else if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_property)) {
                ret = this.m_category;
            } else if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(referencePath)) {
                try {
                    ret = cms.readPropertyObject(referencePath, this.m_property, true).getValue("/");
                }
                catch (CmsException ex) {
                    if (!LOG.isErrorEnabled()) break block9;
                    LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        }
        if (!ret.endsWith("/")) {
            ret = ret + "/";
        }
        if (ret.startsWith("/")) {
            ret = ret.substring(1);
        }
        return ret;
    }
}

